/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.hades;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Services;
import com.wynntils.features.players.HadesFeature;
import com.wynntils.hades.objects.HadesConnection;
import com.wynntils.hades.protocol.enums.HadesVersion;
import com.wynntils.hades.protocol.interfaces.HadesPacket;
import com.wynntils.hades.protocol.interfaces.adapters.IHadesClientAdapter;
import com.wynntils.hades.protocol.packets.client.HCPacketAuthenticate;
import com.wynntils.hades.protocol.packets.server.HSPacketAuthenticationResponse;
import com.wynntils.hades.protocol.packets.server.HSPacketClearMutual;
import com.wynntils.hades.protocol.packets.server.HSPacketDisconnect;
import com.wynntils.hades.protocol.packets.server.HSPacketDiscordLobbyServer;
import com.wynntils.hades.protocol.packets.server.HSPacketPong;
import com.wynntils.hades.protocol.packets.server.HSPacketUpdateMutual;
import com.wynntils.services.hades.HadesUser;
import com.wynntils.services.hades.HadesUserRegistry;
import com.wynntils.services.hades.event.HadesEvent;
import com.wynntils.services.hades.event.HadesUserEvent;
import com.wynntils.utils.mc.McUtils;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class HadesClientHandler
implements IHadesClientAdapter {
    private final HadesConnection hadesConnection;
    private final HadesUserRegistry userRegistry;

    public HadesClientHandler(HadesConnection hadesConnection, HadesUserRegistry userRegistry) {
        this.hadesConnection = hadesConnection;
        this.userRegistry = userRegistry;
        Thread.currentThread().setContextClassLoader(WynntilsMod.class.getClassLoader());
    }

    public void onConnect() {
        if (!Services.WynntilsAccount.isLoggedIn()) {
            this.hadesConnection.disconnect();
            if (Managers.Connection.onServer()) {
                McUtils.sendErrorToClient("Could not connect to the remote player server because you are not logged in on Athena.");
            }
            throw new IllegalStateException("Tried to auth to the remote player server without being logged in on Athena.");
        }
        this.hadesConnection.sendPacketAndFlush((HadesPacket)new HCPacketAuthenticate(Services.WynntilsAccount.getToken(), HadesVersion.VERSION_0_6_1));
    }

    public void onDisconnect() {
        WynntilsMod.postEvent(new HadesEvent.Disconnected());
        if (Managers.Connection.onServer()) {
            McUtils.sendErrorToClient("Disconnected from the remote player server.");
        }
        WynntilsMod.info("Disconnected from the remote player server.");
        this.userRegistry.getHadesUserMap().clear();
    }

    public void handleAuthenticationResponse(HSPacketAuthenticationResponse packet) {
        MutableComponent userComponent = Component.empty();
        switch (packet.getResponse()) {
            case SUCCESS: {
                WynntilsMod.info("Successfully connected to the remote player server: " + packet.getMessage());
                userComponent = Component.literal((String)"Successfully connected to the remote player server.").withStyle(ChatFormatting.GREEN);
                WynntilsMod.postEvent(new HadesEvent.Authenticated());
                break;
            }
            case INVALID_TOKEN: {
                WynntilsMod.error("Got invalid token when trying to connect to the remote player server: " + packet.getMessage());
                userComponent = Component.literal((String)"Got invalid token when connecting the remote player server.").withStyle(ChatFormatting.RED);
                break;
            }
            case ERROR: {
                WynntilsMod.error("Got an error trying to connect to the remote player server: " + packet.getMessage());
                userComponent = Component.literal((String)"Got error when connecting the remote player server.").withStyle(ChatFormatting.RED);
            }
        }
        if (Managers.Connection.onServer()) {
            McUtils.sendMessageToClient((Component)userComponent);
        }
    }

    public void handlePing(HSPacketPong packet) {
    }

    public void handleUpdateMutual(HSPacketUpdateMutual packet) {
        if (!((Boolean)Managers.Feature.getFeatureInstance(HadesFeature.class).getOtherPlayerInfo.get()).booleanValue()) {
            return;
        }
        Optional<HadesUser> userOptional = this.userRegistry.getUser(packet.getUser());
        if (userOptional.isPresent()) {
            userOptional.get().updateFromPacket(packet);
        } else {
            HadesUser hadesUser = new HadesUser(packet);
            this.userRegistry.putUser(packet.getUser(), hadesUser);
            WynntilsMod.postEventOnMainThread(new HadesUserEvent.Added(hadesUser));
        }
    }

    public void handleDiscordLobbyServer(HSPacketDiscordLobbyServer packet) {
    }

    public void handleClearMutual(HSPacketClearMutual packet) {
        HadesUser oldUser = this.userRegistry.removeUser(packet.getUser());
        WynntilsMod.postEventOnMainThread(new HadesUserEvent.Removed(oldUser));
    }

    public void handleDisconnect(HSPacketDisconnect packet) {
        WynntilsMod.info("Disconnected from the remote player server. Reason: " + packet.getReason());
        if (Managers.Connection.onServer()) {
            McUtils.sendMessageToClient((Component)Component.literal((String)"[Wynntils] Disconnected from the remote player server.").withStyle(ChatFormatting.YELLOW));
        }
        this.userRegistry.getHadesUserMap().clear();
    }
}

