/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.hint;

import com.google.common.reflect.TypeToken;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Service;
import com.wynntils.core.net.DownloadRegistry;
import com.wynntils.core.net.UrlId;
import com.wynntils.core.text.StyledText;
import com.wynntils.services.hint.type.HintAction;
import com.wynntils.utils.mc.McUtils;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;

public class HintService
extends Service {
    private static final String DEFAULT_LANGUAGE = "en_us";
    private static final String UNBOUND_KEY = "key.keyboard.unknown";
    private static final Random RANDOM = new Random();
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\{(?<action>[^:}]+):(?<value>[^}]+)\\}");
    private List<Map<String, String>> hints = new ArrayList<Map<String, String>>();

    public HintService() {
        super(List.of());
    }

    @Override
    public void registerDownloads(DownloadRegistry registry) {
        registry.registerDownload(UrlId.DATA_STATIC_HINTS).handleReader(this::handleHintMessages);
    }

    private void handleHintMessages(Reader reader) {
        Type type = new TypeToken<List<Map<String, String>>>(){}.getType();
        this.hints = (List)WynntilsMod.GSON.fromJson(reader, type);
    }

    public void sendHint() {
        String languageCode = McUtils.mc().getLanguageManager().getSelected();
        if (this.hints.isEmpty()) {
            return;
        }
        int hintNum = RANDOM.nextInt(this.hints.size());
        Map<String, String> currentHint = this.hints.get(hintNum);
        String hint = currentHint.containsKey(languageCode) ? currentHint.get(languageCode) : currentHint.getOrDefault(DEFAULT_LANGUAGE, "");
        if (hint.isEmpty()) {
            WynntilsMod.warn("Hint " + hintNum + " has no en_us translation.");
            return;
        }
        MutableComponent component = this.formatHint(hint);
        if (component.equals((Object)Component.empty())) {
            return;
        }
        McUtils.sendMessageToClientWithPillHeader((Component)component);
    }

    private MutableComponent formatHint(String hint) {
        StyledText styledText = StyledText.EMPTY;
        Matcher matcher = VARIABLE_PATTERN.matcher(hint);
        int lastEnd = 0;
        while (matcher.find()) {
            MutableComponent actionComponent;
            String actionStr;
            HintAction hintAction;
            if (matcher.start() > lastEnd) {
                styledText = styledText.append(StyledText.fromComponent((Component)Component.literal((String)hint.substring(lastEnd, matcher.start()))));
            }
            if ((hintAction = HintAction.fromString(actionStr = matcher.group("action"))) == null) {
                WynntilsMod.warn("Unknown hint action " + actionStr);
                return Component.empty();
            }
            String value = matcher.group("value");
            switch (hintAction) {
                default: {
                    throw new MatchException(null, null);
                }
                case KEYBIND: {
                    MutableComponent mutableComponent = this.createKeybindPart(value);
                    break;
                }
                case TOGGLE_COMMAND: 
                case WYNNTILS_COMMAND: {
                    MutableComponent mutableComponent = actionComponent = this.createCommandPart(hintAction.name().toLowerCase(Locale.ROOT).replace("_command", ""), value);
                }
            }
            if (actionComponent.equals((Object)Component.empty())) {
                return Component.empty();
            }
            styledText = styledText.append(StyledText.fromComponent((Component)actionComponent));
            lastEnd = matcher.end();
        }
        if (lastEnd < hint.length()) {
            styledText = styledText.append(StyledText.fromComponent((Component)Component.literal((String)hint.substring(lastEnd))));
        }
        return styledText.getComponent().withStyle(ChatFormatting.LIGHT_PURPLE);
    }

    private MutableComponent createKeybindPart(String keybindName) {
        for (KeyMapping keyMapping : McUtils.options().keyMappings) {
            if (!keyMapping.getName().equals(keybindName)) continue;
            String translated = keyMapping.getTranslatedKeyMessage().getString();
            if (translated.equals(I18n.get((String)UNBOUND_KEY, (Object[])new Object[0]))) {
                WynntilsMod.info("Skipping hint due to unbound key");
                return Component.empty();
            }
            return Component.literal((String)translated).withStyle(ChatFormatting.YELLOW);
        }
        WynntilsMod.info("Skipping hint due to unknown keybind " + keybindName);
        return Component.empty();
    }

    private MutableComponent createCommandPart(String command, String argument) {
        String fullCommand = "/" + command + " " + argument;
        return Component.literal((String)fullCommand).withStyle(style -> style.withColor(ChatFormatting.GOLD).withUnderlined(Boolean.valueOf(true)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, fullCommand)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)("Click to run " + fullCommand)))));
    }
}

