/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.itemrecord.type;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.encoding.type.EncodingSettings;
import com.wynntils.utils.EncodedByteBuffer;
import com.wynntils.utils.type.ErrorOr;
import java.lang.reflect.Type;
import java.util.Set;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.Unit;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.level.ItemLike;

public record SavedItem(String base64, Set<String> categories, ItemStack itemStack) implements Comparable<SavedItem>
{
    private static final EncodingSettings SAVED_ITEM_ENCODING_SETTINGS = new EncodingSettings(true, true);

    public static SavedItem create(WynnItem wynnItem, Set<String> categories, ItemStack itemStack) {
        ErrorOr<EncodedByteBuffer> errorOrEncodedByteBuffer = Models.ItemEncoding.encodeItem(wynnItem, SAVED_ITEM_ENCODING_SETTINGS);
        if (errorOrEncodedByteBuffer.hasError()) {
            throw new IllegalArgumentException("Tried to construct a SavedItem with unencodable WynnItem: " + errorOrEncodedByteBuffer.getError());
        }
        return new SavedItem(errorOrEncodedByteBuffer.getValue().toBase64String(), categories, itemStack);
    }

    public WynnItem wynnItem() {
        ErrorOr<WynnItem> errorOrWynnItem = Models.ItemEncoding.decodeItem(EncodedByteBuffer.fromBase64String(this.base64), null);
        if (errorOrWynnItem.hasError()) {
            throw new IllegalStateException("Tried to decode a SavedItem with unencodable WynnItem: " + errorOrWynnItem.getError());
        }
        return errorOrWynnItem.getValue();
    }

    @Override
    public int compareTo(SavedItem other) {
        return this.base64.compareTo(other.base64);
    }

    private record ItemStackInfo(int itemId, int damage, int color) {
    }

    public static class SavedItemSerializer
    implements JsonSerializer<SavedItem>,
    JsonDeserializer<SavedItem> {
        public SavedItem deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ItemStack itemStack;
            JsonObject jsonObject = json.getAsJsonObject();
            String base64 = jsonObject.get("base64").getAsString();
            Set categories = (Set)context.deserialize(jsonObject.get("categories"), Set.class);
            if (jsonObject.has("itemStack")) {
                JsonElement itemStackJson = jsonObject.get("itemStack");
                itemStack = ItemStack.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)itemStackJson).result().orElse(ItemStack.EMPTY);
            } else if (jsonObject.has("itemStackInfo")) {
                ItemStackInfo info = (ItemStackInfo)context.deserialize(jsonObject.get("itemStackInfo"), ItemStackInfo.class);
                itemStack = new ItemStack((ItemLike)Item.byId((int)info.itemId()), 1);
                DataComponentMap.Builder componentsBuilder = DataComponentMap.builder().set(DataComponents.DAMAGE, (Object)info.damage()).set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(false)).set(DataComponents.HIDE_ADDITIONAL_TOOLTIP, (Object)Unit.INSTANCE);
                if (info.color() != -1) {
                    componentsBuilder.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(info.color(), false));
                }
                itemStack.applyComponents(componentsBuilder.build());
                itemStack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)((ItemAttributeModifiers)itemStack.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY)).withTooltip(false));
            } else {
                WynntilsMod.error("SavedItem has no itemStack or itemStackInfo");
                itemStack = ItemStack.EMPTY;
            }
            return new SavedItem(base64, categories, itemStack);
        }

        public JsonElement serialize(SavedItem src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("base64", src.base64());
            jsonObject.add("categories", context.serialize(src.categories()));
            JsonElement itemStackJson = (JsonElement)ItemStack.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)src.itemStack()).result().orElseThrow(() -> new JsonParseException("Failed to encode ItemStack"));
            jsonObject.add("itemStack", itemStackJson);
            return jsonObject;
        }
    }
}

