/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.lootrunpaths;

import com.wynntils.core.components.Managers;
import com.wynntils.features.LootrunFeature;
import com.wynntils.services.lootrunpaths.LootrunPathInstance;
import com.wynntils.services.lootrunpaths.UncompiledLootrunPath;
import com.wynntils.services.lootrunpaths.type.ColoredPath;
import com.wynntils.services.lootrunpaths.type.ColoredPosition;
import com.wynntils.services.lootrunpaths.type.LootrunNote;
import com.wynntils.services.lootrunpaths.type.LootrunPath;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.PosUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.util.ARGB;
import net.minecraft.util.CubicSpline;
import net.minecraft.util.ToFloatFunction;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector2d;
import org.joml.Vector2dc;

public final class LootrunCompiler {
    private static final List<Integer> COLORS = List.of(ChatFormatting.RED.getColor(), ChatFormatting.GOLD.getColor(), ChatFormatting.YELLOW.getColor(), ChatFormatting.GREEN.getColor(), ChatFormatting.BLUE.getColor(), Integer.valueOf(0x3F00FF), ChatFormatting.DARK_PURPLE.getColor());

    public static LootrunPathInstance compile(UncompiledLootrunPath uncompiled, boolean recording) {
        Long2ObjectMap<List<ColoredPath>> points = LootrunCompiler.generatePointsByChunk(uncompiled.path(), recording);
        Long2ObjectMap<Set<BlockPos>> chests = LootrunCompiler.getChests(uncompiled.chests());
        Long2ObjectMap<List<LootrunNote>> notes = LootrunCompiler.getNotes(uncompiled.notes());
        String lootrunName = LootrunCompiler.getLootrunName(uncompiled, recording);
        return new LootrunPathInstance(lootrunName, uncompiled.path(), LootrunCompiler.generateSimplifiedPoints(uncompiled.path(), 0.5), points, chests, notes);
    }

    private static String getLootrunName(UncompiledLootrunPath uncompiled, boolean recording) {
        if (recording) {
            return "recorded_lootrun";
        }
        if (uncompiled.file() == null) {
            return "lootrun";
        }
        return uncompiled.file().getName().replace(".json", "");
    }

    private static List<LootrunPath> sample(LootrunPath raw, float sampleRate) {
        ArrayList<LootrunPath> positions = new ArrayList<LootrunPath>();
        LootrunPath currentPositions = new LootrunPath(new ArrayList<Vec3>());
        positions.add(currentPositions);
        for (Vec3 element : raw.points()) {
            if (!currentPositions.points().isEmpty() && currentPositions.points().getLast().distanceTo(element) >= 32.0) {
                currentPositions = new LootrunPath(new ArrayList<Vec3>());
                positions.add(currentPositions);
            }
            currentPositions.points().add(element);
        }
        ArrayList<LootrunPath> result = new ArrayList<LootrunPath>();
        for (LootrunPath current : positions) {
            float distance = 0.0f;
            CubicSpline.Builder builderX = CubicSpline.builder((ToFloatFunction)ToFloatFunction.IDENTITY);
            CubicSpline.Builder builderY = CubicSpline.builder((ToFloatFunction)ToFloatFunction.IDENTITY);
            CubicSpline.Builder builderZ = CubicSpline.builder((ToFloatFunction)ToFloatFunction.IDENTITY);
            for (int i = 0; i < current.points().size(); ++i) {
                Vec3 position = current.points().get(i);
                if (i > 0) {
                    distance = (float)((double)distance + current.points().get(i - 1).distanceTo(position));
                }
                float slopeX = 0.0f;
                float slopeY = 0.0f;
                float slopeZ = 0.0f;
                if (i < current.points().size() - 1) {
                    Vec3 next = current.points().get(i + 1);
                    slopeX = (float)((next.x - position.x) / position.distanceTo(next));
                    slopeY = (float)((next.y - position.y) / position.distanceTo(next));
                    slopeZ = (float)((next.z - position.z) / position.distanceTo(next));
                }
                builderX.addPoint(distance, (float)position.x, slopeX);
                builderY.addPoint(distance, (float)position.y, slopeY);
                builderZ.addPoint(distance, (float)position.z, slopeZ);
            }
            CubicSpline splineX = builderX.build();
            CubicSpline splineY = builderY.build();
            CubicSpline splineZ = builderZ.build();
            LootrunPath newResult = new LootrunPath(new ArrayList<Vec3>());
            for (float i = 0.0f; i < distance; i += 1.0f / sampleRate) {
                newResult.points().add(new Vec3((double)splineX.apply((Object)Float.valueOf(i)), (double)splineY.apply((Object)Float.valueOf(i)), (double)splineZ.apply((Object)Float.valueOf(i))));
            }
            result.add(newResult);
        }
        return result;
    }

    private static Long2ObjectMap<List<ColoredPath>> generatePointsByChunk(LootrunPath raw, boolean recording) {
        Integer nextColor;
        float sampleRate = 10.0f;
        List<List> sampled = LootrunCompiler.sample(raw, sampleRate).stream().map(LootrunPath::points).toList();
        List positions = sampled.stream().flatMap(Collection::stream).toList();
        ColoredPath locationsList = new ColoredPath(new ArrayList<ColoredPosition>());
        Iterator<Integer> colorIterator = COLORS.iterator();
        Integer currentColor = nextColor = colorIterator.next();
        float differenceRed = 0.0f;
        float differenceGreen = 0.0f;
        float differenceBlue = 0.0f;
        for (int i = 0; i < positions.size(); ++i) {
            Vec3 position = (Vec3)positions.get(i);
            if (((Boolean)Managers.Feature.getFeatureInstance(LootrunFeature.class).rainbowLootRun.get()).booleanValue() && !recording) {
                int usedColor;
                int cycleDistance = (Integer)Managers.Feature.getFeatureInstance(LootrunFeature.class).cycleDistance.get();
                int cycle = 10 * cycleDistance;
                int parts = i % cycle;
                float done = (float)parts / (float)cycle;
                if (parts == 0) {
                    currentColor = nextColor;
                    if (!colorIterator.hasNext()) {
                        colorIterator = COLORS.iterator();
                    }
                    nextColor = colorIterator.next();
                    differenceRed = ARGB.red((int)nextColor) - ARGB.red((int)currentColor);
                    differenceGreen = ARGB.green((int)nextColor) - ARGB.green((int)currentColor);
                    differenceBlue = ARGB.blue((int)nextColor) - ARGB.blue((int)currentColor);
                    usedColor = currentColor;
                } else {
                    usedColor = currentColor;
                    usedColor += 65536 * (int)(differenceRed * done);
                    usedColor += 256 * (int)(differenceGreen * done);
                    usedColor += (int)(differenceBlue * done);
                }
                locationsList.points().add(new ColoredPosition(position, usedColor | 0xFF000000));
                continue;
            }
            locationsList.points().add(new ColoredPosition(position, recording ? ((CustomColor)Managers.Feature.getFeatureInstance(LootrunFeature.class).recordingPathColor.get()).asInt() : ((CustomColor)Managers.Feature.getFeatureInstance(LootrunFeature.class).activePathColor.get()).asInt()));
        }
        ColoredPath lastLocationList = null;
        Long2ObjectOpenHashMap sampleByChunk = new Long2ObjectOpenHashMap();
        ChunkPos lastChunkPos = null;
        for (int i = 0; i < locationsList.points().size(); ++i) {
            Vec3 position = locationsList.points().get(i).position();
            ChunkPos currentChunkPos = new ChunkPos(MathUtils.floor(position.x()) >> 4, MathUtils.floor(position.z()) >> 4);
            if (!currentChunkPos.equals(lastChunkPos)) {
                if (lastChunkPos != null && position.distanceTo(locationsList.points().get(i - 1).position()) < 32.0) {
                    lastLocationList.points().add(locationsList.points().get(i));
                }
                lastChunkPos = currentChunkPos;
                sampleByChunk.putIfAbsent(ChunkPos.asLong((int)currentChunkPos.x, (int)currentChunkPos.z), new ArrayList());
                lastLocationList = new ColoredPath(new ArrayList<ColoredPosition>());
                ((List)sampleByChunk.get(ChunkPos.asLong((int)currentChunkPos.x, (int)currentChunkPos.z))).add(lastLocationList);
            }
            lastLocationList.points().add(locationsList.points().get(i));
        }
        return sampleByChunk;
    }

    private static List<Vector2d> generateSimplifiedPoints(LootrunPath raw, double tolerance) {
        ArrayList<Vector2d> points = new ArrayList<Vector2d>();
        for (Vec3 point : raw.points()) {
            points.add(new Vector2d(point.x, point.z));
        }
        return LootrunCompiler.simplify(points, tolerance);
    }

    private static List<Vector2d> simplify(List<Vector2d> points, double epsilon) {
        if (points.size() < 3) {
            return points;
        }
        int end = points.size() - 1;
        int index = -1;
        double dist = 0.0;
        for (int i = 1; i < end; ++i) {
            double d = LootrunCompiler.pointLineDistance(points.get(i), points.getFirst(), points.get(end));
            if (!(d > dist)) continue;
            dist = d;
            index = i;
        }
        ArrayList<Vector2d> simplified = new ArrayList<Vector2d>();
        if (dist > epsilon) {
            List<Vector2d> left = LootrunCompiler.simplify(points.subList(0, index + 1), epsilon);
            List<Vector2d> right = LootrunCompiler.simplify(points.subList(index, end + 1), epsilon);
            simplified.addAll(left.subList(0, left.size() - 1));
            simplified.addAll(right);
        } else {
            simplified.add(points.getFirst());
            simplified.add(points.get(end));
        }
        return simplified;
    }

    private static double pointLineDistance(Vector2d point, Vector2d lineStart, Vector2d lineEnd) {
        Vector2d lineDelta;
        Vector2d delta = new Vector2d((Vector2dc)point).sub((Vector2dc)lineStart);
        double param = delta.dot((Vector2dc)(lineDelta = new Vector2d((Vector2dc)lineEnd).sub((Vector2dc)lineStart))) / lineDelta.lengthSquared();
        Vector2d closestPoint = param < 0.0 ? new Vector2d((Vector2dc)lineStart) : (param > 1.0 ? new Vector2d((Vector2dc)lineEnd) : new Vector2d((Vector2dc)lineStart).add((Vector2dc)lineDelta.mul(param)));
        return closestPoint.distance((Vector2dc)point);
    }

    private static Long2ObjectMap<Set<BlockPos>> getChests(Set<BlockPos> chests) {
        Long2ObjectOpenHashMap result = new Long2ObjectOpenHashMap();
        for (BlockPos pos : chests) {
            Set addTo = (Set)result.computeIfAbsent(new ChunkPos(pos).toLong(), chunk -> new HashSet());
            addTo.add(pos);
        }
        return result;
    }

    private static Long2ObjectMap<List<LootrunNote>> getNotes(List<LootrunNote> notes) {
        Long2ObjectOpenHashMap result = new Long2ObjectOpenHashMap();
        for (LootrunNote note : notes) {
            ChunkPos chunk = new ChunkPos(PosUtils.newBlockPos(note.position()));
            List notesChunk = (List)result.computeIfAbsent(chunk.toLong(), chunkPos -> new ArrayList());
            notesChunk.add(note);
        }
        return result;
    }
}

