/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.map.pois;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Managers;
import com.wynntils.core.text.StyledText;
import com.wynntils.features.map.MainMapFeature;
import com.wynntils.services.map.pois.Poi;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.buffered.BufferedRenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import net.minecraft.client.renderer.MultiBufferSource;

public abstract class IconPoi
implements Poi {
    @Override
    public int getWidth(float mapZoom, float scale) {
        return (int)((float)this.getIcon().width() * scale);
    }

    @Override
    public int getHeight(float mapZoom, float scale) {
        return (int)((float)this.getIcon().height() * scale);
    }

    public abstract Texture getIcon();

    protected abstract float getMinZoomForRender();

    private float getIconAlpha(float zoom) {
        float minZoom = this.getMinZoomForRender();
        if (minZoom <= -1.0f) {
            return 1.0f;
        }
        return MathUtils.clamp(MathUtils.map(zoom, minZoom * (1.0f - ((Float)Managers.Feature.getFeatureInstance(MainMapFeature.class).poiFadeAdjustment.get()).floatValue()), minZoom, 0.0f, 1.0f), 0.0f, 1.0f);
    }

    protected CustomColor getIconColor() {
        return CommonColors.WHITE;
    }

    @Override
    public void renderAt(PoseStack poseStack, MultiBufferSource bufferSource, float renderX, float renderY, boolean hovered, float scale, float zoomRenderScale, float zoomLevel, boolean showLabels) {
        float modifier = scale;
        if (hovered) {
            modifier = (float)((double)modifier * 1.05);
        }
        Texture icon = this.getIcon();
        float width = (float)icon.width() * modifier;
        float height = (float)icon.height() * modifier;
        BufferedRenderUtils.drawColoredTexturedRect(poseStack, bufferSource, icon.resource(), this.getIconColor(), this.getIconAlpha(zoomRenderScale), renderX - width / 2.0f, renderY - height / 2.0f, this.getDisplayPriority().ordinal(), width, height);
        if (hovered) {
            poseStack.pushPose();
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(this.getName()), renderX, 15.0f + renderY, CommonColors.GREEN, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.OUTLINE);
            poseStack.popPose();
        }
    }

    @Override
    public boolean isVisible(float zoomRenderScale, float zoomLevel) {
        return this.getIconAlpha(zoomRenderScale) >= 0.1f;
    }
}

