/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.resourcepack;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Service;
import com.wynntils.core.mod.ConnectionManager;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.storage.Storage;
import com.wynntils.mc.event.ConnectionEvent;
import com.wynntils.mc.event.ServerResourcePackEvent;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.type.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

public final class ResourcePackService
extends Service {
    private static final String PRELOADED_PACK_PREFIX = "wynntils_preloaded/";
    @Persisted
    private final Storage<Pair<UUID, String>> resourcePackIdHash = new Storage<Pair<Object, String>>(Pair.of(null, ""));
    private boolean serverHasResourcePack = false;

    public ResourcePackService() {
        super(List.of());
    }

    public void setRequestedPreloadHash(UUID id, String hash) {
        this.resourcePackIdHash.store(Pair.of(id, hash));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onServerResourcePackLoad(ServerResourcePackEvent.Load event) {
        Pack preloadedPack = this.getPreloadedPack();
        if (preloadedPack == null) {
            WynntilsMod.info("No preloaded pack, letting Minecraft handle the resource pack.");
            this.serverHasResourcePack = true;
            return;
        }
        if (preloadedPack.getId().equals(PRELOADED_PACK_PREFIX + event.getHash())) {
            WynntilsMod.info("Preloaded pack is up-to-date, cancelling server pack loading.");
            event.setCanceled(true);
            this.serverHasResourcePack = false;
            return;
        }
        WynntilsMod.info("Preloaded pack is outdated or wrong, clearing server pack.");
        WynntilsMod.info("Preloaded pack: " + preloadedPack.getId() + ", expected: " + this.getExpectedPackId());
        PackRepository resourcePackRepository = McUtils.mc().getResourcePackRepository();
        ArrayList selectedIds = new ArrayList(resourcePackRepository.getSelectedIds());
        selectedIds.remove(preloadedPack.getId());
        resourcePackRepository.setSelected(selectedIds);
        this.serverHasResourcePack = true;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onServerResourcePackClear(ServerResourcePackEvent.Clear event) {
        PackRepository resourcePackRepository = McUtils.mc().getResourcePackRepository();
        Pack preloadedPack = this.getPreloadedPack();
        if (this.isResourcePackInfoMissing()) {
            WynntilsMod.info("No preloaded pack, or it was disabled, clearing server pack, checking if a reload should trigger.");
        } else if (preloadedPack == null) {
            WynntilsMod.info("No preloaded pack, clearing server pack, trying to preload a new pack.");
        } else if (!preloadedPack.getId().equals(this.getExpectedPackId())) {
            WynntilsMod.info("Preloaded pack is outdated, clearing server pack, trying to preload a new pack.");
        } else {
            WynntilsMod.info("Preloaded pack is up-to-date, no-op.");
            return;
        }
        resourcePackRepository.reload();
        boolean changeMade = this.preloadResourcePack();
        if (!changeMade) {
            WynntilsMod.info("No changes to preloaded packs, clearing server pack, no reload needed.");
            return;
        }
        if (this.serverHasResourcePack) {
            WynntilsMod.info("Preloaded pack updated, reloading resource packs is done by Minecraft.");
            return;
        }
        WynntilsMod.info("Triggering a resource pack reload, as the server had no resource packs, and a change was made.");
        McUtils.mc().reloadResourcePacks();
    }

    @SubscribeEvent
    public void onConnect(ConnectionEvent.ConnectingEvent event) {
        this.serverHasResourcePack = false;
        if (Managers.Connection.getConnectionState() != ConnectionManager.ConnectionState.DISCONNECTED) {
            return;
        }
        WynntilsMod.info("Joined a non-Wynncraft server, clearing preloaded pack.");
        PackRepository resourcePackRepository = McUtils.mc().getResourcePackRepository();
        ArrayList<String> selectedIds = new ArrayList<String>(resourcePackRepository.getSelectedIds());
        boolean anyRemoved = selectedIds.removeIf(id -> id.startsWith(PRELOADED_PACK_PREFIX));
        resourcePackRepository.setSelected(selectedIds);
        if (anyRemoved) {
            WynntilsMod.info("Preloaded pack removed, reloading resource packs.");
            McUtils.mc().reloadResourcePacks();
        }
    }

    public boolean preloadResourcePack() {
        PackRepository resourcePackRepository = McUtils.mc().getResourcePackRepository();
        ArrayList<String> selectedIds = new ArrayList<String>(resourcePackRepository.getSelectedIds());
        boolean anyRemoved = selectedIds.removeIf(id -> id.startsWith(PRELOADED_PACK_PREFIX));
        if (this.isResourcePackInfoMissing()) {
            resourcePackRepository.setSelected(selectedIds);
            return anyRemoved;
        }
        Pack lastRequiredPack = selectedIds.stream().map(arg_0 -> ((PackRepository)resourcePackRepository).getPack(arg_0)).filter(Objects::nonNull).filter(Pack::isRequired).reduce((first, second) -> second).orElse(null);
        int positionToInject = lastRequiredPack == null ? 0 : selectedIds.indexOf(lastRequiredPack.getId()) + 1;
        for (Pack pack : resourcePackRepository.getAvailablePacks()) {
            if (!pack.getId().equals(this.getExpectedPackId())) continue;
            if (selectedIds.contains(pack.getId())) break;
            selectedIds.add(positionToInject, pack.getId());
            resourcePackRepository.setSelected(selectedIds);
            return true;
        }
        WynntilsMod.warn("Could not find the preload target pack to select it.");
        resourcePackRepository.setSelected(selectedIds);
        return anyRemoved;
    }

    public boolean isPreloadedPackSelected() {
        return McUtils.mc().getResourcePackRepository().getSelectedIds().contains(this.getExpectedPackId());
    }

    private Pack getPreloadedPack() {
        if (this.isResourcePackInfoMissing()) {
            return null;
        }
        PackRepository resourcePackRepository = McUtils.mc().getResourcePackRepository();
        for (Pack pack : resourcePackRepository.getSelectedPacks()) {
            if (!pack.getId().equals(this.getExpectedPackId())) continue;
            return pack;
        }
        return null;
    }

    private boolean isResourcePackInfoMissing() {
        Pair resourceInfo = (Pair)this.resourcePackIdHash.get();
        return resourceInfo.key() == null || resourceInfo.value() == null || ((String)resourceInfo.value()).isEmpty();
    }

    private String getExpectedPackId() {
        return PRELOADED_PACK_PREFIX + (String)((Pair)this.resourcePackIdHash.get()).value();
    }
}

