/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.statistics;

import com.wynntils.services.statistics.type.StatFormatter;
import com.wynntils.utils.StringUtils;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.Util;

public final class CustomStatFormatters {
    private static final DecimalFormat DECIMAL_FORMAT = (DecimalFormat)Util.make((Object)new DecimalFormat("########0.00"), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    public static final StatFormatter TIME = seconds -> {
        double minutes = (double)seconds / 60.0;
        double hours = minutes / 60.0;
        double days = hours / 24.0;
        double years = days / 365.0;
        if (years >= 1.0) {
            return DECIMAL_FORMAT.format(years) + " y";
        }
        if (days >= 1.0) {
            return DECIMAL_FORMAT.format(days) + " d";
        }
        if (hours >= 1.0) {
            return DECIMAL_FORMAT.format(hours) + " h";
        }
        return minutes >= 1.0 ? DECIMAL_FORMAT.format(minutes) + " m" : seconds + " s";
    };
    public static final StatFormatter FORMATTED_NUMBER = number -> NumberFormat.getIntegerInstance(Locale.US).format(number).replace(',', '.') + " (" + StringUtils.integerToShortString(number) + ")";
}

