/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils.mc.type;

import java.util.Comparator;
import java.util.Objects;
import net.minecraft.core.Position;
import net.minecraft.world.phys.Vec3;

public class PreciseLocation
implements Position,
Comparable<PreciseLocation> {
    private static final Comparator<PreciseLocation> LOCATION_COMPARATOR = Comparator.comparing(PreciseLocation::x, Double::compareTo).thenComparing(PreciseLocation::z, Double::compareTo).thenComparing(PreciseLocation::y, Double::compareTo);
    private final double x;
    private final double y;
    private final double z;

    public PreciseLocation(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static PreciseLocation fromVec(Vec3 vec3) {
        return new PreciseLocation(vec3.x, vec3.y, vec3.z);
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PreciseLocation that = (PreciseLocation)o;
        return Double.compare(this.x, that.x) == 0 && Double.compare(this.y, that.y) == 0 && Double.compare(this.z, that.z) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z);
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + "]";
    }

    @Override
    public int compareTo(PreciseLocation preciseLocation) {
        return LOCATION_COMPARATOR.compare(this, preciseLocation);
    }
}

