/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils.render;

import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.mixin.accessors.MinecraftAccessor;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.ComponentUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.TextRenderTask;
import com.wynntils.utils.render.buffered.BufferedFontRenderer;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;

public final class FontRenderer {
    private static final MultiBufferSource.BufferSource BUFFER_SOURCE = MultiBufferSource.immediate((ByteBufferBuilder)new ByteBufferBuilder(256));
    private static final FontRenderer INSTANCE = new FontRenderer();
    private final Font font = ((MinecraftAccessor)McUtils.mc()).getFont();
    private static final double HALF_PI = 1.5707963267948966;
    private static final double TWO_PI = Math.PI * 2;
    private static final int NEWLINE_OFFSET = 10;

    private FontRenderer() {
    }

    public static FontRenderer getInstance() {
        return INSTANCE;
    }

    public Font getFont() {
        return this.font;
    }

    public void renderText(PoseStack poseStack, StyledText text, float x, float y, CustomColor customColor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, TextShadow shadow, float textScale, Font.DisplayMode displayMode) {
        BufferedFontRenderer.getInstance().renderText(poseStack, (MultiBufferSource)BUFFER_SOURCE, text, x, y, customColor, horizontalAlignment, verticalAlignment, shadow, textScale, displayMode);
        BUFFER_SOURCE.endBatch();
    }

    public void renderText(PoseStack poseStack, StyledText text, float x, float y, CustomColor customColor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, TextShadow shadow, float textScale) {
        this.renderText(poseStack, text, x, y, customColor, horizontalAlignment, verticalAlignment, shadow, textScale, Font.DisplayMode.SEE_THROUGH);
    }

    public void renderText(PoseStack poseStack, StyledText text, float x, float y, CustomColor customColor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, TextShadow shadow) {
        this.renderText(poseStack, text, x, y, customColor, horizontalAlignment, verticalAlignment, shadow, 1.0f);
    }

    public void renderAlignedTextInBox(PoseStack poseStack, StyledText[] lines, float x1, float x2, float y1, float y2, float maxWidth, CustomColor customColor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, TextShadow textShadow, float textScale) {
        Objects.requireNonNull(this.font);
        int lineHeight = 9;
        ArrayList<StyledText> adjustedLines = new ArrayList<StyledText>();
        for (StyledText line : lines) {
            if (maxWidth == 0.0f || (float)this.font.width((FormattedText)line.getComponent()) < maxWidth / textScale) {
                adjustedLines.add(line);
                continue;
            }
            List parts = this.font.getSplitter().splitLines((FormattedText)line.getComponent(), (int)(maxWidth / textScale), Style.EMPTY);
            StyledText lastPart = StyledText.EMPTY;
            for (FormattedText part : parts) {
                StyledText text;
                Style lastStyle = ComponentUtils.getLastPartCodes(lastPart);
                lastPart = text = StyledText.fromComponent((Component)Component.literal((String)"").withStyle(lastStyle)).append(StyledText.fromComponent(ComponentUtils.formattedTextToComponent(part)));
                adjustedLines.add(text);
            }
        }
        float calculatedTextHeight = (float)((adjustedLines.size() - 1) * lineHeight) * textScale;
        float renderX = switch (horizontalAlignment) {
            default -> throw new MatchException(null, null);
            case HorizontalAlignment.LEFT -> x1;
            case HorizontalAlignment.CENTER -> (x1 + x2) / 2.0f;
            case HorizontalAlignment.RIGHT -> x2;
        };
        float renderY = switch (verticalAlignment) {
            default -> throw new MatchException(null, null);
            case VerticalAlignment.TOP -> y1;
            case VerticalAlignment.MIDDLE -> (y1 + y2) / 2.0f - calculatedTextHeight / 2.0f;
            case VerticalAlignment.BOTTOM -> y2 - calculatedTextHeight;
        };
        float lineOffset = 0.0f;
        for (StyledText text : adjustedLines) {
            this.renderText(poseStack, text, renderX, renderY + lineOffset, customColor, horizontalAlignment, verticalAlignment, textShadow, textScale);
            lineOffset += (float)lineHeight * textScale;
        }
    }

    public void renderAlignedTextInBox(PoseStack poseStack, StyledText text, float x1, float x2, float y1, float y2, float maxWidth, CustomColor customColor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, TextShadow textShadow, float textScale) {
        this.renderAlignedTextInBox(poseStack, new StyledText[]{text}, x1, x2, y1, y2, maxWidth, customColor, horizontalAlignment, verticalAlignment, textShadow, textScale);
    }

    public void renderAlignedTextInBox(PoseStack poseStack, StyledText text, float x1, float x2, float y1, float y2, float maxWidth, CustomColor customColor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, TextShadow textShadow) {
        this.renderAlignedTextInBox(poseStack, new StyledText[]{text}, x1, x2, y1, y2, maxWidth, customColor, horizontalAlignment, verticalAlignment, textShadow, 1.0f);
    }

    public void renderAlignedHighlightedTextInBox(PoseStack poseStack, StyledText text, float x1, float x2, float y1, float y2, float maxWidth, CustomColor textColor, CustomColor backgroundColor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) {
        float renderX = switch (horizontalAlignment) {
            default -> throw new MatchException(null, null);
            case HorizontalAlignment.LEFT -> x1;
            case HorizontalAlignment.CENTER -> (x1 + x2) / 2.0f;
            case HorizontalAlignment.RIGHT -> x2;
        };
        float renderY = switch (verticalAlignment) {
            default -> throw new MatchException(null, null);
            case VerticalAlignment.TOP -> y1;
            case VerticalAlignment.MIDDLE -> (y1 + y2) / 2.0f;
            case VerticalAlignment.BOTTOM -> y2;
        };
        float cursorRenderY = switch (verticalAlignment) {
            default -> throw new MatchException(null, null);
            case VerticalAlignment.TOP -> renderY - 2.0f;
            case VerticalAlignment.MIDDLE -> {
                Objects.requireNonNull(this.font);
                yield renderY - 9.0f / 2.0f - 2.0f;
            }
            case VerticalAlignment.BOTTOM -> {
                Objects.requireNonNull(this.font);
                yield renderY - 9.0f + 2.0f;
            }
        };
        float f = this.font.width((FormattedText)text.getComponent());
        Objects.requireNonNull(this.font);
        RenderUtils.drawRect(poseStack, backgroundColor, renderX, cursorRenderY, 0.0f, f, 9 + 2);
        this.renderAlignedTextInBox(poseStack, new StyledText[]{text}, x1, x2, y1, y2, maxWidth, textColor, horizontalAlignment, verticalAlignment, TextShadow.NONE, 1.0f);
    }

    public void renderAlignedTextInBox(PoseStack poseStack, StyledText text, float x1, float x2, float y, float maxWidth, CustomColor customColor, HorizontalAlignment horizontalAlignment, TextShadow textShadow) {
        this.renderAlignedTextInBox(poseStack, new StyledText[]{text}, x1, x2, y, y, maxWidth, customColor, horizontalAlignment, VerticalAlignment.TOP, textShadow, 1.0f);
    }

    public void renderAlignedTextInBox(PoseStack poseStack, StyledText text, float x, float y1, float y2, float maxWidth, CustomColor customColor, VerticalAlignment verticalAlignment, TextShadow textShadow) {
        this.renderAlignedTextInBox(poseStack, new StyledText[]{text}, x, x, y1, y2, maxWidth, customColor, HorizontalAlignment.LEFT, verticalAlignment, textShadow, 1.0f);
    }

    private void renderText(PoseStack poseStack, StyledText text, float x, float y, float maxWidth, CustomColor customColor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, TextShadow shadow, float textScale, Font.DisplayMode displayMode) {
        if (text == null) {
            return;
        }
        if (maxWidth == 0.0f || (float)this.font.width((FormattedText)text.getComponent()) / textScale < maxWidth) {
            this.renderText(poseStack, text, x, y, customColor, horizontalAlignment, verticalAlignment, shadow, textScale, displayMode);
            return;
        }
        List parts = this.font.getSplitter().splitLines((FormattedText)text.getComponent(), (int)(maxWidth / textScale), Style.EMPTY);
        StyledText lastPart = StyledText.EMPTY;
        for (int i = 0; i < parts.size(); ++i) {
            StyledText part;
            Style lastStyle = ComponentUtils.getLastPartCodes(lastPart);
            lastPart = part = StyledText.fromComponent((Component)Component.literal((String)"").withStyle(lastStyle)).append(StyledText.fromComponent(ComponentUtils.formattedTextToComponent((FormattedText)parts.get(i))));
            Objects.requireNonNull(this.font);
            this.renderText(poseStack, part, x, y + (float)(i * 9) * textScale, customColor, horizontalAlignment, verticalAlignment, shadow, textScale, displayMode);
        }
    }

    public void renderText(PoseStack poseStack, StyledText text, float x, float y, float maxWidth, CustomColor customColor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, TextShadow shadow, float textScale) {
        this.renderText(poseStack, text, x, y, maxWidth, customColor, horizontalAlignment, verticalAlignment, shadow, textScale, Font.DisplayMode.SEE_THROUGH);
    }

    public void renderText(PoseStack poseStack, StyledText text, float x, float y, float maxWidth, CustomColor customColor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, TextShadow shadow, Font.DisplayMode displayMode) {
        this.renderText(poseStack, text, x, y, maxWidth, customColor, horizontalAlignment, verticalAlignment, shadow, 1.0f, displayMode);
    }

    public void renderText(PoseStack poseStack, StyledText text, float x, float y, float maxWidth, CustomColor customColor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, TextShadow shadow) {
        this.renderText(poseStack, text, x, y, maxWidth, customColor, horizontalAlignment, verticalAlignment, shadow, Font.DisplayMode.SEE_THROUGH);
    }

    public void renderScrollingText(PoseStack poseStack, StyledText styledText, float x, float y, float renderWidth, CustomColor customColor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, TextShadow shadow, float textScale) {
        int textLength = (int)((float)(this.font.width((FormattedText)styledText.getComponent()) + 1) * textScale);
        if ((float)textLength > renderWidth) {
            float maxScrollOffset = switch (horizontalAlignment) {
                case HorizontalAlignment.CENTER -> -((float)textLength / 2.0f) + renderWidth / 2.0f;
                case HorizontalAlignment.RIGHT -> 0.0f;
                default -> (float)textLength - renderWidth;
            };
            double currentTimeInSeconds = (double)Util.getMillis() / 1000.0;
            double scrollFactor = Math.max((double)maxScrollOffset * 0.5, 3.0);
            double scrollPosition = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * currentTimeInSeconds / scrollFactor)) / 2.0 + 0.5;
            float startOffset = switch (horizontalAlignment) {
                case HorizontalAlignment.CENTER -> (float)textLength / 2.0f - renderWidth / 2.0f;
                case HorizontalAlignment.RIGHT -> renderWidth - (float)textLength;
                default -> 0.0f;
            };
            double scrollOffset = Mth.lerp((double)scrollPosition, (double)startOffset, (double)maxScrollOffset);
            float scissorX = switch (horizontalAlignment) {
                default -> throw new MatchException(null, null);
                case HorizontalAlignment.LEFT -> x;
                case HorizontalAlignment.CENTER -> x - renderWidth / 2.0f;
                case HorizontalAlignment.RIGHT -> x - renderWidth;
            };
            float scissorY = switch (verticalAlignment) {
                default -> throw new MatchException(null, null);
                case VerticalAlignment.TOP -> y;
                case VerticalAlignment.MIDDLE -> {
                    Objects.requireNonNull(this.font);
                    yield y - 9.0f / 2.0f - 1.0f;
                }
                case VerticalAlignment.BOTTOM -> {
                    Objects.requireNonNull(this.font);
                    yield y - 9.0f - 1.0f;
                }
            };
            float f = (int)scissorX;
            float f2 = (int)scissorY;
            float f3 = (int)renderWidth;
            Objects.requireNonNull(this.font);
            RenderUtils.createRectMask(poseStack, f, f2, f3, (int)((float)(9 + 1) * textScale));
            this.renderText(poseStack, styledText, x - (float)((int)scrollOffset), y, customColor, horizontalAlignment, verticalAlignment, shadow, textScale);
            RenderUtils.clearMask();
        } else {
            this.renderText(poseStack, styledText, x, y, customColor, horizontalAlignment, verticalAlignment, shadow, textScale);
        }
    }

    public void renderScrollingText(PoseStack poseStack, StyledText styledText, float x, float y, float renderWidth, CustomColor customColor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, TextShadow shadow) {
        this.renderScrollingText(poseStack, styledText, x, y, renderWidth, customColor, horizontalAlignment, verticalAlignment, shadow, 1.0f);
    }

    public void renderScrollingAlignedTextInBox(PoseStack poseStack, StyledText text, float x1, float x2, float y1, float y2, float renderWidth, CustomColor customColor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, TextShadow textShadow, float textScale) {
        float renderX = switch (horizontalAlignment) {
            default -> throw new MatchException(null, null);
            case HorizontalAlignment.LEFT -> x1;
            case HorizontalAlignment.CENTER -> (x1 + x2) / 2.0f;
            case HorizontalAlignment.RIGHT -> x2;
        };
        float renderY = switch (verticalAlignment) {
            default -> throw new MatchException(null, null);
            case VerticalAlignment.TOP -> y1;
            case VerticalAlignment.MIDDLE -> (y1 + y2) / 2.0f;
            case VerticalAlignment.BOTTOM -> y2;
        };
        this.renderScrollingText(poseStack, text, renderX, renderY, renderWidth, customColor, horizontalAlignment, verticalAlignment, textShadow, textScale);
    }

    public void renderScrollingAlignedTextInBox(PoseStack poseStack, StyledText text, float x1, float x2, float y1, float y2, float renderWidth, CustomColor customColor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, TextShadow textShadow) {
        this.renderScrollingAlignedTextInBox(poseStack, text, x1, x2, y1, y2, renderWidth, customColor, horizontalAlignment, verticalAlignment, textShadow, 1.0f);
    }

    public void renderText(PoseStack poseStack, float x, float y, TextRenderTask line, Font.DisplayMode displayMode) {
        this.renderText(poseStack, line.getText(), x, y, line.getSetting().maxWidth(), line.getSetting().customColor(), line.getSetting().horizontalAlignment(), line.getSetting().verticalAlignment(), line.getSetting().shadow(), displayMode);
    }

    public void renderText(PoseStack poseStack, float x, float y, TextRenderTask line) {
        this.renderText(poseStack, x, y, line, Font.DisplayMode.SEE_THROUGH);
    }

    public void renderTexts(PoseStack poseStack, float x, float y, List<TextRenderTask> lines) {
        float currentY = y;
        for (TextRenderTask line : lines) {
            this.renderText(poseStack, x, currentY, line);
            currentY += this.calculateRenderHeight(line.getText(), line.getSetting().maxWidth());
        }
    }

    public void renderTextsWithAlignment(PoseStack poseStack, float x, float y, List<TextRenderTask> toRender, float width, float height, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) {
        float renderX = switch (horizontalAlignment) {
            default -> throw new MatchException(null, null);
            case HorizontalAlignment.LEFT -> x;
            case HorizontalAlignment.CENTER -> x + width / 2.0f;
            case HorizontalAlignment.RIGHT -> x + width;
        };
        float renderY = switch (verticalAlignment) {
            default -> throw new MatchException(null, null);
            case VerticalAlignment.TOP -> y;
            case VerticalAlignment.MIDDLE -> y + (height - this.calculateRenderHeight(toRender)) / 2.0f;
            case VerticalAlignment.BOTTOM -> y + (height - this.calculateRenderHeight(toRender));
        };
        this.renderTexts(poseStack, renderX, renderY, toRender);
    }

    public void renderTextWithAlignment(PoseStack poseStack, float renderX, float renderY, TextRenderTask toRender, float width, float height, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) {
        this.renderTextsWithAlignment(poseStack, renderX, renderY, List.of(toRender), width, height, horizontalAlignment, verticalAlignment);
    }

    public float calculateRenderHeight(List<TextRenderTask> toRender) {
        if (toRender.isEmpty()) {
            return 0.0f;
        }
        float height = 0.0f;
        int totalLineCount = 0;
        for (TextRenderTask textRenderTask : toRender) {
            if (textRenderTask.getSetting().maxWidth() == 0.0f) {
                Objects.requireNonNull(this.font);
                height += 9.0f;
            } else {
                height += this.calculateRenderHeight(textRenderTask.getText(), textRenderTask.getSetting().maxWidth());
            }
            ++totalLineCount;
        }
        Objects.requireNonNull(this.font);
        return height += (float)((totalLineCount - 1) * (10 - 9));
    }

    public float calculateRenderHeight(List<StyledText> lines, float maxWidth) {
        return (float)lines.stream().mapToDouble(line -> this.calculateRenderHeight((StyledText)line, maxWidth)).sum();
    }

    public float calculateRenderHeight(String line, float maxWidth) {
        return this.calculateRenderHeight(StyledText.fromString(line), maxWidth);
    }

    public float calculateRenderHeight(StyledText line, float maxWidth) {
        return this.font.wordWrapHeight((FormattedText)(line.isEmpty() ? Component.literal((String)" ") : line.getComponent()), maxWidth == 0.0f ? Integer.MAX_VALUE : (int)maxWidth);
    }
}

