/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.wynntils.services.lootrunpaths.LootrunPathInstance;
import com.wynntils.services.map.MapTexture;
import com.wynntils.services.map.pois.Poi;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.VectorUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.buffered.BufferedRenderUtils;
import com.wynntils.utils.render.buffered.CustomRenderType;
import com.wynntils.utils.render.type.PointerType;
import com.wynntils.utils.type.BoundingBox;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.client.renderer.CoreShaders;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.ShaderProgram;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import org.joml.Matrix4f;
import org.joml.Vector2d;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public final class MapRenderer {
    public static final int ZOOM_LEVELS = 100;
    public static final float DEFAULT_ZOOM_LEVEL = 60.0f;
    private static final float MIN_ZOOM = 0.2f;
    private static final float MAX_ZOOM = 10.0f;
    private static final double MIN_ZOOM_LOG = Math.log(0.2f);
    private static final double MAX_ZOOM_LOG = Math.log(10.0);
    private static final float CHUNK_LINE_WIDTH = 1.0f;

    public static float getZoomRenderScaleFromLevel(float zoomLevel) {
        double guiScale = McUtils.guiScale();
        double logGuiScale = Math.log(guiScale);
        double logMinZoomGuiScale = MIN_ZOOM_LOG - logGuiScale;
        double logMaxZoomGuiScale = MAX_ZOOM_LOG - logGuiScale;
        return (float)Math.exp(logMinZoomGuiScale + (logMaxZoomGuiScale - logMinZoomGuiScale) * (double)(zoomLevel - 1.0f) / 99.0);
    }

    public static void renderMapQuad(MapTexture map, PoseStack poseStack, MultiBufferSource bufferSource, float centerX, float centerZ, float textureX, float textureZ, float width, float height, float scale) {
        VertexConsumer buffer = bufferSource.getBuffer(CustomRenderType.getMapPositionTextureQuad(map.resource()));
        MapRenderer.renderMap(map, poseStack, buffer, centerX, centerZ, textureX, textureZ, width, height, scale);
    }

    public static void renderMapQuad(MapTexture map, PoseStack poseStack, float centerX, float centerZ, float textureX, float textureZ, float width, float height, float scale) {
        RenderSystem.disableBlend();
        RenderSystem.setShader((ShaderProgram)CoreShaders.POSITION_TEX);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)map.resource());
        RenderSystem.texParameter((int)3553, (int)10240, (int)9728);
        RenderSystem.texParameter((int)3553, (int)10241, (int)9728);
        RenderSystem.texParameter((int)3553, (int)10243, (int)33069);
        RenderSystem.texParameter((int)3553, (int)10242, (int)33069);
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        MapRenderer.renderMap(map, poseStack, (VertexConsumer)builder, centerX, centerZ, textureX, textureZ, width, height, scale);
        BufferUploader.drawWithShader((MeshData)builder.build());
    }

    private static void renderMap(MapTexture map, PoseStack poseStack, VertexConsumer buffer, float centerX, float centerZ, float textureX, float textureZ, float width, float height, float scale) {
        float uScale = 1.0f / (float)map.getTextureWidth();
        float vScale = 1.0f / (float)map.getTextureHeight();
        float halfRenderedWidth = width / 2.0f;
        float halfRenderedHeight = height / 2.0f;
        float halfTextureWidth = halfRenderedWidth * scale;
        float halfTextureHeight = halfRenderedHeight * scale;
        Matrix4f matrix = poseStack.last().pose();
        buffer.addVertex(matrix, centerX - halfRenderedWidth, centerZ + halfRenderedHeight, 0.0f).setUv((textureX - halfTextureWidth) * uScale, (textureZ + halfTextureHeight) * vScale);
        buffer.addVertex(matrix, centerX + halfRenderedWidth, centerZ + halfRenderedHeight, 0.0f).setUv((textureX + halfTextureWidth) * uScale, (textureZ + halfTextureHeight) * vScale);
        buffer.addVertex(matrix, centerX + halfRenderedWidth, centerZ - halfRenderedHeight, 0.0f).setUv((textureX + halfTextureWidth) * uScale, (textureZ - halfTextureHeight) * vScale);
        buffer.addVertex(matrix, centerX - halfRenderedWidth, centerZ - halfRenderedHeight, 0.0f).setUv((textureX - halfTextureWidth) * uScale, (textureZ - halfTextureHeight) * vScale);
    }

    public static void renderCursor(PoseStack poseStack, float renderX, float renderY, float pointerScale, CustomColor pointerColor, PointerType pointerType, boolean followPlayerRotation) {
        float rotationAngle = followPlayerRotation ? McUtils.player().getYRot() - McUtils.mc().gameRenderer.getMainCamera().getYRot() : 180.0f + McUtils.player().getYRot();
        poseStack.pushPose();
        RenderUtils.rotatePose(poseStack, renderX, renderY, rotationAngle);
        float renderedWidth = (float)pointerType.width * pointerScale;
        float renderedHeight = (float)pointerType.height * pointerScale;
        RenderUtils.drawTexturedRectWithColor(poseStack, Texture.MAP_POINTERS.resource(), pointerColor, renderX - renderedWidth / 2.0f, renderY - renderedHeight / 2.0f, 0.0f, renderedWidth, renderedHeight, 0, pointerType.textureY, pointerType.width, pointerType.height, Texture.MAP_POINTERS.width(), Texture.MAP_POINTERS.height());
        poseStack.popPose();
    }

    public static void renderChunks(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, BoundingBox renderedWorldBoundingBox, Set<Long> mappedChunks, float mapCenterX, float centerX, float mapCenterZ, float centerZ, float zoomRenderScale) {
        ChunkPos topLeft = new ChunkPos(new BlockPos((int)renderedWorldBoundingBox.x1(), 0, (int)renderedWorldBoundingBox.z1()));
        ChunkPos bottomRight = new ChunkPos(new BlockPos((int)renderedWorldBoundingBox.x2(), 0, (int)renderedWorldBoundingBox.z2()));
        for (int x = topLeft.x; x <= bottomRight.x; ++x) {
            for (int z = topLeft.z; z <= bottomRight.z; ++z) {
                ChunkPos chunkPos = new ChunkPos(x, z);
                float worldX1 = chunkPos.getMinBlockX() - 1;
                float worldX2 = chunkPos.getMaxBlockX() + 1;
                float worldZ1 = chunkPos.getMinBlockZ() - 1;
                float worldZ2 = chunkPos.getMaxBlockZ() + 1;
                float x1 = MapRenderer.getRenderX((int)worldX1, mapCenterX, centerX, zoomRenderScale);
                float x2 = MapRenderer.getRenderX((int)worldX2, mapCenterX, centerX, zoomRenderScale);
                float z1 = MapRenderer.getRenderZ((int)worldZ1, mapCenterZ, centerZ, zoomRenderScale);
                float z2 = MapRenderer.getRenderZ((int)worldZ2, mapCenterZ, centerZ, zoomRenderScale);
                CustomColor renderColor = mappedChunks.contains(chunkPos.toLong()) ? CommonColors.GREEN : CommonColors.RED;
                CustomColor topRenderColor = mappedChunks.contains(new ChunkPos(x, z - 1).toLong()) ? CommonColors.GREEN : renderColor;
                CustomColor leftRenderColor = mappedChunks.contains(new ChunkPos(x - 1, z).toLong()) ? CommonColors.GREEN : renderColor;
                BufferedRenderUtils.drawLine(poseStack, (MultiBufferSource)bufferSource, topRenderColor, x1, z1, x2, z1, 0.0f, 1.0f);
                BufferedRenderUtils.drawLine(poseStack, (MultiBufferSource)bufferSource, leftRenderColor, x1, z1, x1, z2, 0.0f, 1.0f);
                if (x == bottomRight.x) {
                    CustomColor rightRenderColor = mappedChunks.contains(new ChunkPos(x + 1, z).toLong()) ? CommonColors.GREEN : renderColor;
                    BufferedRenderUtils.drawLine(poseStack, (MultiBufferSource)bufferSource, rightRenderColor, x2, z1, x2, z2, 0.0f, 1.0f);
                }
                if (z != bottomRight.z) continue;
                CustomColor bottomRenderColor = mappedChunks.contains(new ChunkPos(x, z + 1).toLong()) ? CommonColors.GREEN : renderColor;
                BufferedRenderUtils.drawLine(poseStack, (MultiBufferSource)bufferSource, bottomRenderColor, x1, z2, x2, z2, 0.0f, 1.0f);
            }
        }
    }

    public static void renderLootrunLine(LootrunPathInstance lootrun, float lootrunWidth, float outlineWidth, PoseStack poseStack, float centerX, float centerZ, float mapTextureX, float mapTextureZ, float currentZoom, int lootrunColor, int outlineColor) {
        int i;
        if (lootrun.simplifiedPath().size() < 3) {
            return;
        }
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_COLOR);
        RenderSystem.setShader((ShaderProgram)CoreShaders.POSITION_COLOR);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableCull();
        ArrayList<Vector2f> points = new ArrayList<Vector2f>();
        ArrayList<Vector2f> middlePoints = new ArrayList<Vector2f>();
        Vector2f last = null;
        for (Vector2d point : lootrun.simplifiedPath()) {
            Vector2f screenPos = new Vector2f(MapRenderer.getRenderX((int)point.x(), mapTextureX, centerX, currentZoom), MapRenderer.getRenderZ((int)point.y(), mapTextureZ, centerZ, currentZoom));
            if (last == null) {
                last = screenPos;
                points.add(screenPos);
                continue;
            }
            Vector2f vector2f = new Vector2f((Vector2fc)last);
            if (!(vector2f.sub((Vector2fc)screenPos).length() > 2.0f)) continue;
            last = screenPos;
            points.add(screenPos);
        }
        for (i = 0; i < points.size() - 1; ++i) {
            if (i == 0) {
                middlePoints.add((Vector2f)points.getFirst());
                continue;
            }
            if (i == points.size() - 2) {
                middlePoints.add((Vector2f)points.getLast());
                continue;
            }
            middlePoints.add(new Vector2f((Vector2fc)points.get(i)).add((Vector2fc)points.get(i + 1)).mul(0.5f));
        }
        for (i = 1; i < middlePoints.size(); ++i) {
            MapRenderer.drawTriangles(bufferBuilder, poseStack, (Vector2f)middlePoints.get(i - 1), (Vector2f)points.get(i), (Vector2f)middlePoints.get(i), outlineColor, outlineWidth);
            MapRenderer.drawTriangles(bufferBuilder, poseStack, (Vector2f)middlePoints.get(i - 1), (Vector2f)points.get(i), (Vector2f)middlePoints.get(i), lootrunColor, lootrunWidth);
        }
        BufferUploader.drawWithShader((MeshData)bufferBuilder.build());
        RenderSystem.enableCull();
    }

    private static void drawTriangles(BufferBuilder bufferBuilder, PoseStack poseStack, Vector2f p0, Vector2f p1, Vector2f p2, int color, float lineWidth) {
        Vector2f t0 = new Vector2f();
        Vector2f t2 = new Vector2f();
        p1.sub((Vector2fc)p0, t0);
        p2.sub((Vector2fc)p1, t2);
        t0 = new Vector2f(-t0.y(), t0.x());
        t2 = new Vector2f(-t2.y(), t2.x());
        if (MathUtils.signedArea(p0, p1, p2) > 0.0f) {
            t0.mul(-1.0f);
            t2.mul(-1.0f);
        }
        t0.normalize();
        t2.normalize();
        t0.mul(lineWidth);
        t2.mul(lineWidth);
        Vector2f lineIntersection = VectorUtils.lineIntersection(new Vector2f((Vector2fc)p0).add((Vector2fc)t0), new Vector2f((Vector2fc)p1).add((Vector2fc)t0), new Vector2f((Vector2fc)p2).add((Vector2fc)t2), new Vector2f((Vector2fc)p1).add((Vector2fc)t2));
        Vector2f anchor = new Vector2f();
        float anchorLength = Float.MAX_VALUE;
        if (lineIntersection != null) {
            lineIntersection.sub((Vector2fc)p1, anchor);
            anchorLength = lineIntersection.length();
        }
        Vector2f p0p1 = new Vector2f((Vector2fc)p0).sub((Vector2fc)p1);
        Vector2f p1p2 = new Vector2f((Vector2fc)p1).sub((Vector2fc)p2);
        if (anchorLength > p0p1.length() || anchorLength > p1p2.length()) {
            MapRenderer.addVertex(bufferBuilder, new Vector2f((Vector2fc)p0).add((Vector2fc)t0), color, poseStack);
            MapRenderer.addVertex(bufferBuilder, new Vector2f((Vector2fc)p0).sub((Vector2fc)t0), color, poseStack);
            MapRenderer.addVertex(bufferBuilder, new Vector2f((Vector2fc)p1).add((Vector2fc)t0), color, poseStack);
            MapRenderer.addVertex(bufferBuilder, new Vector2f((Vector2fc)p0).sub((Vector2fc)t0), color, poseStack);
            MapRenderer.addVertex(bufferBuilder, new Vector2f((Vector2fc)p1).add((Vector2fc)t0), color, poseStack);
            MapRenderer.addVertex(bufferBuilder, new Vector2f((Vector2fc)p1).sub((Vector2fc)t0), color, poseStack);
            MapRenderer.drawRoundJoint(p1, new Vector2f((Vector2fc)p1).add((Vector2fc)t0), new Vector2f((Vector2fc)p1).add((Vector2fc)t2), p2, bufferBuilder, color, poseStack);
            MapRenderer.addVertex(bufferBuilder, new Vector2f((Vector2fc)p2).add((Vector2fc)t2), color, poseStack);
            MapRenderer.addVertex(bufferBuilder, new Vector2f((Vector2fc)p1).sub((Vector2fc)t2), color, poseStack);
            MapRenderer.addVertex(bufferBuilder, new Vector2f((Vector2fc)p1).add((Vector2fc)t2), color, poseStack);
            MapRenderer.addVertex(bufferBuilder, new Vector2f((Vector2fc)p2).add((Vector2fc)t2), color, poseStack);
            MapRenderer.addVertex(bufferBuilder, new Vector2f((Vector2fc)p1).sub((Vector2fc)t2), color, poseStack);
            MapRenderer.addVertex(bufferBuilder, new Vector2f((Vector2fc)p2).sub((Vector2fc)t2), color, poseStack);
        } else {
            MapRenderer.addVertex(bufferBuilder, new Vector2f((Vector2fc)p0).add((Vector2fc)t0), color, poseStack);
            MapRenderer.addVertex(bufferBuilder, new Vector2f((Vector2fc)p0).sub((Vector2fc)t0), color, poseStack);
            MapRenderer.addVertex(bufferBuilder, new Vector2f((Vector2fc)p1).sub((Vector2fc)anchor), color, poseStack);
            MapRenderer.addVertex(bufferBuilder, new Vector2f((Vector2fc)p0).add((Vector2fc)t0), color, poseStack);
            MapRenderer.addVertex(bufferBuilder, new Vector2f((Vector2fc)p1).sub((Vector2fc)anchor), color, poseStack);
            MapRenderer.addVertex(bufferBuilder, new Vector2f((Vector2fc)p1).add((Vector2fc)t0), color, poseStack);
            Vector2f rP0 = new Vector2f((Vector2fc)p1).add((Vector2fc)t0);
            Vector2f rP1 = new Vector2f((Vector2fc)p1).add((Vector2fc)t2);
            Vector2f rP2 = new Vector2f((Vector2fc)p1).sub((Vector2fc)anchor);
            MapRenderer.addVertex(bufferBuilder, rP0, color, poseStack);
            MapRenderer.addVertex(bufferBuilder, p1, color, poseStack);
            MapRenderer.addVertex(bufferBuilder, rP2, color, poseStack);
            MapRenderer.drawRoundJoint(p1, rP0, rP1, rP2, bufferBuilder, color, poseStack);
            MapRenderer.addVertex(bufferBuilder, p1, color, poseStack);
            MapRenderer.addVertex(bufferBuilder, rP1, color, poseStack);
            MapRenderer.addVertex(bufferBuilder, rP2, color, poseStack);
            MapRenderer.addVertex(bufferBuilder, new Vector2f((Vector2fc)p2).add((Vector2fc)t2), color, poseStack);
            MapRenderer.addVertex(bufferBuilder, new Vector2f((Vector2fc)p1).sub((Vector2fc)anchor), color, poseStack);
            MapRenderer.addVertex(bufferBuilder, new Vector2f((Vector2fc)p1).add((Vector2fc)t2), color, poseStack);
            MapRenderer.addVertex(bufferBuilder, new Vector2f((Vector2fc)p2).add((Vector2fc)t2), color, poseStack);
            MapRenderer.addVertex(bufferBuilder, new Vector2f((Vector2fc)p1).sub((Vector2fc)anchor), color, poseStack);
            MapRenderer.addVertex(bufferBuilder, new Vector2f((Vector2fc)p2).sub((Vector2fc)t2), color, poseStack);
        }
    }

    private static void drawRoundJoint(Vector2f center, Vector2f p0, Vector2f p1, Vector2f nextPointInLine, BufferBuilder bufferBuilder, int color, PoseStack poseStack) {
        float angleDiff;
        float radius = new Vector2f((Vector2fc)center).sub((Vector2fc)p0).length();
        float angle0 = (float)Math.atan2(p1.y() - center.y(), p1.x() - center.x());
        float angle1 = (float)Math.atan2(p0.y() - center.y(), p0.x() - center.x());
        float orgAngle0 = angle0;
        if (angle1 > angle0) {
            while ((double)(angle1 - angle0) >= 3.1405926535422957) {
                angle1 = (float)((double)angle1 - Math.PI * 2);
            }
        } else {
            while ((double)(angle0 - angle1) >= 3.1405926535422957) {
                angle0 = (float)((double)angle0 - Math.PI * 2);
            }
        }
        if ((double)Math.abs(angleDiff = angle1 - angle0) >= 3.1405926535422957 && (double)Math.abs(angleDiff) <= 3.1425926536372906) {
            Vector2f r1 = new Vector2f((Vector2fc)center).sub((Vector2fc)nextPointInLine);
            if (r1.x() == 0.0f) {
                if (r1.y() > 0.0f) {
                    angleDiff = -angleDiff;
                }
            } else if (r1.x() >= -0.001f) {
                angleDiff = -angleDiff;
            }
        }
        int nSegments = (int)Math.abs(angleDiff * radius / 2.0f);
        float angleInc = angleDiff / (float)(++nSegments);
        for (int i = 0; i < nSegments; ++i) {
            MapRenderer.addVertex(bufferBuilder, center, color, poseStack);
            MapRenderer.addVertex(bufferBuilder, new Vector2f((float)((double)center.x() + (double)radius * Math.cos(orgAngle0 + angleInc * (float)i)), (float)((double)center.y() + (double)radius * Math.sin(orgAngle0 + angleInc * (float)i))), color, poseStack);
            MapRenderer.addVertex(bufferBuilder, new Vector2f((float)((double)center.x() + (double)radius * Math.cos(orgAngle0 + angleInc * (float)(1 + i))), (float)((double)center.y() + (double)radius * Math.sin(orgAngle0 + angleInc * (float)(1 + i)))), color, poseStack);
        }
    }

    private static void addVertex(BufferBuilder bufferBuilder, Vector2f pos, int color, PoseStack poseStack) {
        bufferBuilder.addVertex(poseStack.last().pose(), pos.x(), pos.y(), 0.0f).setColor(color);
    }

    public static float getRenderX(Poi poi, float mapCenterX, float centerX, float currentZoom) {
        double distanceX = (float)poi.getLocation().getX() - mapCenterX;
        return (float)((double)centerX + distanceX * (double)currentZoom);
    }

    public static float getRenderX(int worldX, float mapCenterX, float centerX, float currentZoom) {
        double distanceX = (float)worldX - mapCenterX;
        return (float)((double)centerX + distanceX * (double)currentZoom);
    }

    public static float getRenderZ(Poi poi, float mapCenterZ, float centerZ, float currentZoom) {
        double distanceZ = (float)poi.getLocation().getZ() - mapCenterZ;
        return (float)((double)centerZ + distanceZ * (double)currentZoom);
    }

    public static float getRenderZ(int worldZ, float mapCenterZ, float centerZ, float currentZoom) {
        double distanceZ = (float)worldZ - mapCenterZ;
        return (float)((double)centerZ + distanceZ * (double)currentZoom);
    }
}

