/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils.type;

import com.google.common.collect.ComparisonChain;

public record CappedValue(int current, int max) implements Comparable<CappedValue>
{
    public static final CappedValue EMPTY = new CappedValue(0, 0);

    public static CappedValue fromProgress(float progress, int max) {
        if (max <= 0) {
            return EMPTY;
        }
        int current = Math.round(progress * (float)max);
        return new CappedValue(current, max);
    }

    public CappedValue withCurrent(int newCurrent) {
        return new CappedValue(newCurrent, this.max);
    }

    public boolean isAtCap() {
        return this.current == this.max;
    }

    public int getRemaining() {
        return this.max - this.current;
    }

    public int getPercentageInt() {
        return Math.round((float)this.getPercentage());
    }

    public double getPercentage() {
        return this.getProgress() * 100.0;
    }

    public double getProgress() {
        if (this.max == 0) {
            return 1.0;
        }
        return (double)this.current / (double)this.max;
    }

    @Override
    public String toString() {
        return this.current + "/" + this.max;
    }

    @Override
    public int compareTo(CappedValue other) {
        return ComparisonChain.start().compare(this.current, other.current).compare(this.max, other.max).result();
    }
}

