/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils.wynn;

import com.wynntils.utils.MathUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;

public final class ColorScaleUtils {
    public static MutableComponent getPercentageTextComponent(NavigableMap<Float, TextColor> colorMap, float percentage, boolean colorLerp, int decimalPlaces) {
        Style color = Style.EMPTY.withColor(colorLerp ? ColorScaleUtils.getPercentageColor(colorMap, percentage) : ColorScaleUtils.getFlatPercentageColor(colorMap, percentage)).withItalic(Boolean.valueOf(false));
        String percentString = new BigDecimal(percentage).setScale(decimalPlaces, RoundingMode.DOWN).toPlainString();
        return Component.literal((String)(" [" + percentString + "%]")).withStyle(color);
    }

    private static TextColor getPercentageColor(NavigableMap<Float, TextColor> colorMap, float percentage) {
        Map.Entry<Float, TextColor> lowerEntry = colorMap.floorEntry(Float.valueOf(percentage));
        Map.Entry<Float, TextColor> higherEntry = colorMap.ceilingEntry(Float.valueOf(percentage));
        if (lowerEntry == null) {
            return higherEntry.getValue();
        }
        if (higherEntry == null) {
            return lowerEntry.getValue();
        }
        if (Objects.equals(lowerEntry.getKey(), higherEntry.getKey())) {
            return lowerEntry.getValue();
        }
        float t = MathUtils.inverseLerp(lowerEntry.getKey().floatValue(), higherEntry.getKey().floatValue(), percentage);
        int lowerColor = lowerEntry.getValue().getValue();
        int higherColor = higherEntry.getValue().getValue();
        int r = (int)MathUtils.lerp(lowerColor >> 16 & 0xFF, higherColor >> 16 & 0xFF, t);
        int g = (int)MathUtils.lerp(lowerColor >> 8 & 0xFF, higherColor >> 8 & 0xFF, t);
        int b = (int)MathUtils.lerp(lowerColor & 0xFF, higherColor & 0xFF, t);
        return TextColor.fromRgb((int)(r << 16 | g << 8 | b));
    }

    private static TextColor getFlatPercentageColor(NavigableMap<Float, TextColor> colorMap, float percentage) {
        return colorMap.higherEntry(Float.valueOf(percentage)).getValue();
    }
}

