/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.commands.Command;
import com.wynntils.models.activities.quests.QuestInfo;
import com.wynntils.models.activities.type.ActivitySortOrder;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.mc.McUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.phys.Vec3;

public class QuestCommand
extends Command {
    private static final SuggestionProvider<CommandSourceStack> QUEST_SUGGESTION_PROVIDER = (context, builder) -> SharedSuggestionProvider.suggest(Models.Quest.getQuests(ActivitySortOrder.ALPHABETIC).stream().map(QuestInfo::name), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSourceStack> SORT_SUGGESTION_PROVIDER = (context, builder) -> SharedSuggestionProvider.suggest(Arrays.stream(ActivitySortOrder.values()).map(order -> order.name().toLowerCase(Locale.ROOT)), (SuggestionsBuilder)builder);

    @Override
    public String getCommandName() {
        return "quest";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> getCommandBuilder(LiteralArgumentBuilder<CommandSourceStack> base, CommandBuildContext context) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)base.then(((LiteralArgumentBuilder)Commands.literal((String)"list").executes(ctxt -> this.listQuests((CommandContext<CommandSourceStack>)ctxt, "distance"))).then(Commands.argument((String)"sort", (ArgumentType)StringArgumentType.word()).suggests(SORT_SUGGESTION_PROVIDER).executes(ctxt -> this.listQuests((CommandContext<CommandSourceStack>)ctxt, (String)ctxt.getArgument("sort", String.class)))))).then(Commands.literal((String)"search").then(Commands.argument((String)"text", (ArgumentType)StringArgumentType.greedyString()).executes(this::searchQuests)))).then(Commands.literal((String)"info").then(Commands.argument((String)"quest", (ArgumentType)StringArgumentType.greedyString()).suggests(QUEST_SUGGESTION_PROVIDER).executes(this::questInfo)))).then(Commands.literal((String)"track").then(Commands.argument((String)"quest", (ArgumentType)StringArgumentType.greedyString()).suggests(QUEST_SUGGESTION_PROVIDER).executes(this::trackQuest)))).then(Commands.literal((String)"untrack").executes(this::untrackQuest))).then(Commands.literal((String)"wiki").then(Commands.argument((String)"quest", (ArgumentType)StringArgumentType.greedyString()).suggests(QUEST_SUGGESTION_PROVIDER).executes(this::lookupOnWiki)))).executes(this::syntaxError);
    }

    private int listQuests(CommandContext<CommandSourceStack> context, String sort) {
        List<QuestInfo> quests;
        ActivitySortOrder order = ActivitySortOrder.fromString(sort);
        Models.Quest.rescanQuestBook(true, false);
        if (Models.Quest.getQuestsRaw().isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Quest Book was not scanned. You might have to retry this command.").withStyle(ChatFormatting.YELLOW), false);
        }
        if ((quests = Models.Quest.getQuests(order).stream().filter(QuestInfo::trackable).toList()).isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"No active quests found!").withStyle(ChatFormatting.RED));
            return 1;
        }
        MutableComponent response = Component.literal((String)"Active quests:").withStyle(ChatFormatting.AQUA);
        this.generateQuestList(quests, response);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> response, false);
        return 1;
    }

    private int searchQuests(CommandContext<CommandSourceStack> context) {
        List<QuestInfo> quests;
        String searchText = (String)context.getArgument("text", String.class);
        Models.Quest.rescanQuestBook(true, false);
        if (Models.Quest.getQuestsRaw().isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Quest Book was not scanned. You might have to retry this command.").withStyle(ChatFormatting.YELLOW), false);
        }
        if ((quests = Models.Quest.getQuestsRaw().stream().filter(quest -> StringUtils.initialMatch(quest.name(), searchText) || StringUtils.initialMatch(quest.nextTask().getStringWithoutFormatting(), searchText)).toList()).isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"No matching quests found!").withStyle(ChatFormatting.RED));
            return 1;
        }
        MutableComponent response = Component.literal((String)"Matching quests:").withStyle(ChatFormatting.AQUA);
        this.generateQuestList(quests, response);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> response, false);
        return 1;
    }

    private void generateQuestList(List<QuestInfo> quests, MutableComponent response) {
        Vec3 playerLocation = McUtils.player().position();
        for (QuestInfo quest : quests) {
            double distance = quest.nextLocation().isEmpty() ? 0.0 : playerLocation.distanceTo(quest.nextLocation().get().toVec3());
            response.append((Component)Component.literal((String)"\n - ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)quest.name()).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/quest info " + quest.name()))).withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click for info")))).withStyle(ChatFormatting.WHITE));
            if (distance > 0.0) {
                response.append((Component)Component.literal((String)(" (" + (int)Math.round(distance) + " m)")).withStyle(ChatFormatting.DARK_GREEN));
            }
            if (!quest.equals(Models.Activity.getTrackedQuestInfo())) continue;
            response.append((Component)Component.literal((String)" [Tracked]").withStyle(ChatFormatting.DARK_AQUA).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/quest untrack"))).withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to stop tracking")))));
        }
    }

    private int questInfo(CommandContext<CommandSourceStack> context) {
        String questName = (String)context.getArgument("quest", String.class);
        QuestInfo quest = this.getQuestInfo(context, questName);
        if (quest == null) {
            return 0;
        }
        MutableComponent response = Component.literal((String)("Info for quest: " + quest.name())).withStyle(ChatFormatting.AQUA);
        response.append((Component)Component.literal((String)"\n - Status: ").withStyle(ChatFormatting.WHITE)).append(quest.status().getQuestStateComponent()).append((Component)Component.literal((String)"\n - Level: ").withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)Integer.toString(quest.level())).withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)"\n - Length: ").withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)StringUtils.capitalized(quest.length().toString())).withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)"\n - Next task: ").withStyle(ChatFormatting.WHITE)).append((Component)quest.nextTask().getComponent().withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)"\n")).append((Component)Component.literal((String)"[Track quest]").withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/quest track " + quest.name())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to track quest")))).withStyle(ChatFormatting.DARK_AQUA)).append((Component)Component.literal((String)" ")).append((Component)Component.literal((String)"[Lookup on wiki]").withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/quest wiki " + quest.name())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to lookup quest on wiki")))).withStyle(ChatFormatting.DARK_AQUA));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> response, false);
        return 1;
    }

    private int trackQuest(CommandContext<CommandSourceStack> context) {
        String questName = (String)context.getArgument("quest", String.class);
        QuestInfo quest = this.getQuestInfo(context, questName);
        if (quest == null) {
            return 0;
        }
        Models.Quest.startTracking(quest);
        MutableComponent response = Component.literal((String)("Now tracking quest " + quest.name())).withStyle(ChatFormatting.AQUA);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> response, false);
        return 1;
    }

    private int untrackQuest(CommandContext<CommandSourceStack> context) {
        QuestInfo trackedQuest = Models.Activity.getTrackedQuestInfo();
        if (trackedQuest == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"No quest currently tracked").withStyle(ChatFormatting.RED));
            return 0;
        }
        Models.Quest.stopTracking();
        MutableComponent response = Component.literal((String)("Stopped tracking quest " + trackedQuest.name())).withStyle(ChatFormatting.AQUA);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> response, false);
        return 1;
    }

    private int lookupOnWiki(CommandContext<CommandSourceStack> context) {
        String questName = (String)context.getArgument("quest", String.class);
        QuestInfo quest = this.getQuestInfo(context, questName);
        if (quest == null) {
            return 0;
        }
        Models.Quest.openQuestOnWiki(quest);
        MutableComponent response = Component.literal((String)("Quest opened on wiki " + quest.name())).withStyle(ChatFormatting.AQUA);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> response, false);
        return 1;
    }

    private int syntaxError(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Missing argument").withStyle(ChatFormatting.RED));
        return 0;
    }

    private QuestInfo getQuestInfo(CommandContext<CommandSourceStack> context, String questName) {
        String questNameLowerCase = questName.toLowerCase(Locale.ROOT);
        List<QuestInfo> matchingQuests = Models.Quest.getQuestsRaw().stream().filter(questInfo -> questInfo.name().toLowerCase(Locale.ROOT).contains(questNameLowerCase)).toList();
        if (matchingQuests.isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Quest '" + questName + "' not found")).withStyle(ChatFormatting.RED));
            return null;
        }
        if (matchingQuests.size() > 1) {
            MutableComponent error = Component.literal((String)("Quest '" + questName + "' match several quests:")).withStyle(ChatFormatting.RED);
            for (QuestInfo quest : matchingQuests) {
                error.append((Component)Component.literal((String)"\n - ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)quest.name()).withStyle(ChatFormatting.WHITE));
            }
            ((CommandSourceStack)context.getSource()).sendFailure((Component)error);
            return null;
        }
        return matchingQuests.getFirst();
    }
}

