/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.consumers.overlays;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OverlaySize {
    private static final Pattern SIZE_REGEX = Pattern.compile("OverlaySize\\{width=(.+),height=(.+)}");
    private static final float MINIMUM_HEIGHT = 3.0f;
    private static final float MINIMUM_WIDTH = 3.0f;
    private float width;
    private float height;

    public OverlaySize() {
    }

    public OverlaySize(float width, float height) {
        this.width = width;
        this.height = height;
    }

    public OverlaySize(String string) {
        Matcher matcher = SIZE_REGEX.matcher(string.replace(" ", ""));
        if (!matcher.matches()) {
            throw new RuntimeException("Failed to parse OverlaySize");
        }
        try {
            this.width = Float.parseFloat(matcher.group(1));
            this.height = Float.parseFloat(matcher.group(2));
        }
        catch (NumberFormatException exception) {
            throw new RuntimeException("Failed to parse OverlaySize", exception);
        }
    }

    public OverlaySize copy() {
        return new OverlaySize(this.getWidth(), this.getHeight());
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public void setWidth(float newWidth) {
        this.width = Math.max(newWidth, 3.0f);
    }

    public void setHeight(float newHeight) {
        this.height = Math.max(newHeight, 3.0f);
    }

    public String toString() {
        return "OverlaySize{width=" + this.width + ", height=" + this.height + "}";
    }
}

