/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.mod;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Manager;
import com.wynntils.core.mod.event.WynncraftConnectionEvent;
import com.wynntils.mc.event.ConnectionEvent;
import com.wynntils.mc.event.ScreenOpenedEvent;
import com.wynntils.screens.loading.LoadingScreen;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.DisconnectedScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

public final class ConnectionManager
extends Manager {
    private static final String TRANSFER_REASON = "disconnect.transfer";
    private static final Pattern WYNNCRAFT_SERVER_PATTERN = Pattern.compile("^(?:(.*)\\.)?wynncraft\\.(?:com|net|org)$");
    private ConnectionState connectionState = ConnectionState.DISCONNECTED;
    private String connectedHost = null;

    public ConnectionManager() {
        super(List.of());
    }

    public boolean onServer() {
        return this.connectionState == ConnectionState.CONNECTED;
    }

    public ConnectionState getConnectionState() {
        return this.connectionState;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onConnecting(ConnectionEvent.ConnectingEvent e) {
        String host;
        Matcher matcher;
        if (this.connectionState != ConnectionState.DISCONNECTED) {
            WynntilsMod.error("Got connecting event while already connected to server: " + String.valueOf((Object)e));
            this.doDisconnect();
        }
        if ((matcher = WYNNCRAFT_SERVER_PATTERN.matcher(host = e.getHost().toLowerCase(Locale.ROOT))).matches()) {
            String rawHostName = matcher.group(1);
            String hostName = rawHostName == null ? "play" : rawHostName.toLowerCase(Locale.ROOT);
            this.doConnecting(hostName);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onConnected(ConnectionEvent.ConnectedEvent e) {
        if (this.connectionState != ConnectionState.CONNECTING) {
            return;
        }
        if (this.connectedHost == null) {
            return;
        }
        this.doConnected();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onDisconnected(ConnectionEvent.DisconnectedEvent e) {
        if (e.getReason().equals(TRANSFER_REASON)) {
            return;
        }
        this.doDisconnect();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onScreenOpened(ScreenOpenedEvent.Pre e) {
        String reason;
        Screen screen;
        if ((e.getOldScreen() instanceof ConnectScreen || e.getOldScreen() instanceof LoadingScreen) && (e.getScreen() instanceof JoinMultiplayerScreen || e.getScreen() instanceof TitleScreen)) {
            this.doDisconnect();
        }
        if (!((screen = e.getScreen()) instanceof DisconnectedScreen)) {
            return;
        }
        DisconnectedScreen disconnectedScreen = (DisconnectedScreen)screen;
        ComponentContents componentContents = disconnectedScreen.details.reason().getContents();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents tc = (TranslatableContents)componentContents;
            v0 = tc.getKey();
        } else {
            v0 = reason = "unknown";
        }
        if (reason.equals(TRANSFER_REASON)) {
            return;
        }
        this.doDisconnect();
    }

    private void doConnecting(String hostName) {
        this.connectionState = ConnectionState.CONNECTING;
        this.connectedHost = hostName;
        WynntilsMod.postEvent(new WynncraftConnectionEvent.Connecting(this.connectedHost));
    }

    private void doConnected() {
        this.connectionState = ConnectionState.CONNECTED;
        WynntilsMod.postEvent(new WynncraftConnectionEvent.Connected(this.connectedHost));
    }

    private void doDisconnect() {
        ConnectionState oldState = this.connectionState;
        String oldHostName = this.connectedHost;
        this.connectionState = ConnectionState.DISCONNECTED;
        this.connectedHost = null;
        if (oldState == ConnectionState.CONNECTED) {
            WynntilsMod.postEvent(new WynncraftConnectionEvent.Disconnected(oldHostName));
        } else if (oldState == ConnectionState.CONNECTING) {
            WynntilsMod.postEvent(new WynncraftConnectionEvent.ConnectingAborted(oldHostName));
        }
    }

    public static enum ConnectionState {
        DISCONNECTED,
        CONNECTING,
        CONNECTED;

    }
}

