/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.persisted;

import com.wynntils.core.components.Managers;
import java.lang.reflect.Type;

public abstract class PersistedValue<T>
implements Comparable<PersistedValue<T>> {
    private T value;

    protected PersistedValue(T value) {
        this.value = value;
    }

    public T get() {
        return this.value;
    }

    public abstract void touched();

    public void store(T value) {
        this.value = value;
        this.touched();
    }

    public String getJsonName() {
        return Managers.Persisted.getMetadata(this).jsonName();
    }

    public Type getType() {
        return Managers.Persisted.getMetadata(this).valueType();
    }

    protected void setWithoutTouch(T value) {
        this.value = value;
    }

    @Override
    public int compareTo(PersistedValue<T> other) {
        return this.getJsonName().compareTo(other.getJsonName());
    }
}

