/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.persisted.config;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Managers;
import com.wynntils.core.consumers.features.Configurable;
import com.wynntils.core.persisted.PersistedValue;
import com.wynntils.core.persisted.type.PersistedMetadata;
import com.wynntils.utils.EnumUtils;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.client.resources.language.I18n;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class Config<T>
extends PersistedValue<T> {
    private boolean userEdited = false;

    public Config(T value) {
        super(value);
    }

    @Override
    public void touched() {
        Managers.Config.saveConfig();
    }

    @Override
    public void store(T value) {
        this.setWithoutTouch(value);
    }

    public void setValue(T value) {
        if (value == null && !this.getMetadata().allowNull()) {
            WynntilsMod.warn("Trying to set null to config " + this.getJsonName() + ". Will be replaced by default.");
            this.reset();
            return;
        }
        this.setWithoutTouch(value);
        ((Configurable)this.getMetadata().owner()).updateConfigOption(this);
        this.userEdited = true;
    }

    void restoreValue(Object value) {
        this.setValue(value);
    }

    public void reset() {
        T defaultValue = this.getMetadata().defaultValue();
        this.setValue(Managers.Json.deepCopy(defaultValue, this.getMetadata().valueType()));
        this.userEdited = false;
    }

    public boolean isVisible() {
        return true;
    }

    public boolean valueChanged() {
        if (this.userEdited) {
            return true;
        }
        T defaultValue = this.getMetadata().defaultValue();
        boolean deepEquals = Objects.deepEquals(this.get(), defaultValue);
        if (deepEquals) {
            return false;
        }
        try {
            return !EqualsBuilder.reflectionEquals(this.get(), defaultValue, (String[])new String[0]);
        }
        catch (RuntimeException ignored) {
            return true;
        }
    }

    public String getFieldName() {
        return this.getMetadata().fieldName();
    }

    public boolean isEnum() {
        Class clazz;
        Type type = this.getMetadata().valueType();
        return type instanceof Class && (clazz = (Class)type).isEnum();
    }

    public T getDefaultValue() {
        return this.getMetadata().defaultValue();
    }

    public String getDisplayName() {
        return this.getI18n(".name");
    }

    public String getDescription() {
        return this.getI18n(".description");
    }

    public Stream<String> getValidLiterals() {
        if (this.isEnum()) {
            return EnumUtils.getEnumConstants((Class)this.getType()).stream().map(EnumUtils::toJsonFormat);
        }
        if (this.getType().equals(Boolean.class)) {
            return Stream.of("true", "false");
        }
        return Stream.of(new String[0]);
    }

    public String getValueString() {
        if (this.get() == null) {
            return "(null)";
        }
        if (this.isEnum()) {
            return EnumUtils.toNiceString((Enum)this.get());
        }
        return this.get().toString();
    }

    public <E extends Enum<E>> T tryParseStringValue(String value) {
        if (this.isEnum()) {
            return (T)EnumUtils.fromJsonFormat((Class)this.getType(), value);
        }
        try {
            Class wrapped = ClassUtils.primitiveToWrapper((Class)((Class)this.getType()));
            return wrapped.getConstructor(String.class).newInstance(value);
        }
        catch (Exception ignored) {
            WynntilsMod.error("Error in Config while parsing value for type " + String.valueOf(this.getType()) + " with value " + value);
            return null;
        }
    }

    private String getI18n(String suffix) {
        if (!this.getMetadata().i18nKeyOverride().isEmpty()) {
            return I18n.get((String)(this.getMetadata().i18nKeyOverride() + suffix), (Object[])new Object[0]);
        }
        return this.getMetadata().owner().getTranslation(this.getFieldName() + suffix, new Object[0]);
    }

    private PersistedMetadata<T> getMetadata() {
        return Managers.Persisted.getMetadata(this);
    }
}

