/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.text;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;

public class FontLookup {
    private static final Map<ResourceLocation, String> FONT_TO_CODE_MAP = new HashMap<ResourceLocation, String>();
    private static final Map<String, ResourceLocation> CODE_TO_FONT_MAP = new HashMap<String, ResourceLocation>();

    public static void registerFontCode(ResourceLocation font, String code) {
        FONT_TO_CODE_MAP.put(font, code);
        CODE_TO_FONT_MAP.put(code, font);
    }

    public static String getFontCodeFromFont(ResourceLocation font) {
        return FONT_TO_CODE_MAP.computeIfAbsent(font, ResourceLocation::toString);
    }

    public static ResourceLocation getFontFromFromFontCode(String fontCode) {
        return CODE_TO_FONT_MAP.computeIfAbsent(fontCode, fc -> Optional.ofNullable(ResourceLocation.tryParse((String)fc)).orElseGet(() -> ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"default")));
    }
}

