/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.chat;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.RegisterKeyBind;
import com.wynntils.core.keybinds.KeyBind;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.PartStyle;
import com.wynntils.core.text.StyledText;
import com.wynntils.core.text.StyledTextPart;
import com.wynntils.core.text.type.StyleType;
import com.wynntils.handlers.chat.event.ChatMessageEvent;
import com.wynntils.mc.event.KeyInputEvent;
import com.wynntils.mc.mixin.accessors.ChatScreenAccessor;
import com.wynntils.mc.mixin.accessors.ItemStackInfoAccessor;
import com.wynntils.models.items.FakeItemStack;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.encoding.type.EncodingSettings;
import com.wynntils.models.items.items.game.GearItem;
import com.wynntils.models.items.properties.GearTierItemProperty;
import com.wynntils.models.items.properties.IdentifiableItemProperty;
import com.wynntils.models.items.properties.NamedItemProperty;
import com.wynntils.models.items.properties.ShinyItemProperty;
import com.wynntils.screens.itemsharing.ItemSharingScreen;
import com.wynntils.screens.itemsharing.SavedItemsScreen;
import com.wynntils.utils.EncodedByteBuffer;
import com.wynntils.utils.mc.ComponentUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.StyledTextUtils;
import com.wynntils.utils.type.ErrorOr;
import com.wynntils.utils.type.IterationDecision;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.CHAT)
public class ChatItemFeature
extends Feature {
    @RegisterKeyBind
    private final KeyBind shareItemKeybind = new KeyBind("Share Item", 292, true, null, slot -> this.shareItem((Slot)slot, true));
    @RegisterKeyBind
    private final KeyBind saveItemKeybind = new KeyBind("Save Item to Item Record", 295, true, null, slot -> this.shareItem((Slot)slot, false));
    @RegisterKeyBind
    private final KeyBind itemRecordKeybind = new KeyBind("Open Item Record", -1, true, () -> McUtils.setScreen(SavedItemsScreen.create()));
    @Persisted
    private final Config<Boolean> showSharingScreen = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> showPerfectOrDefective = new Config<Boolean>(true);
    private final Map<String, String> chatItems = new HashMap<String, String>();

    @SubscribeEvent
    public void onKeyTyped(KeyInputEvent e) {
        if (!Models.WorldState.onWorld()) {
            return;
        }
        Screen screen = McUtils.screen();
        if (!(screen instanceof ChatScreen)) {
            return;
        }
        ChatScreen chatScreen = (ChatScreen)screen;
        EditBox chatInput = ((ChatScreenAccessor)chatScreen).getChatInput();
        if (!(this.chatItems.isEmpty() || e.getKey() != 257 && e.getKey() != 335)) {
            for (Map.Entry<String, String> item : this.chatItems.entrySet()) {
                chatInput.setValue(chatInput.getValue().replace("<" + item.getKey() + ">", item.getValue()));
            }
            this.chatItems.clear();
            return;
        }
        Matcher matcher = Models.ItemEncoding.getEncodedDataPattern().matcher(chatInput.getValue());
        while (matcher.find()) {
            String itemName = matcher.group("name");
            EncodedByteBuffer encodedByteBuffer = EncodedByteBuffer.fromUtf16String(matcher.group("data"));
            ErrorOr<WynnItem> errorOrDecodedItem = Models.ItemEncoding.decodeItem(encodedByteBuffer, itemName);
            String name = this.getItemName(errorOrDecodedItem);
            chatInput.setValue(chatInput.getValue().replace(matcher.group(), "<" + name + ">"));
            this.chatItems.put(name, matcher.group());
        }
    }

    private String getItemName(ErrorOr<WynnItem> errorOrDecodedItem) {
        Object name;
        if (errorOrDecodedItem.hasError()) {
            name = "encoding_error";
        } else {
            WynnItem decodedItem = errorOrDecodedItem.getValue();
            name = decodedItem.getClass().getSimpleName();
            if (decodedItem instanceof NamedItemProperty) {
                NamedItemProperty namedItemProperty = (NamedItemProperty)((Object)decodedItem);
                name = namedItemProperty.getName();
            }
        }
        while (this.chatItems.containsKey(name)) {
            name = (String)name + "_";
        }
        return name;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onChatReceived(ChatMessageEvent.Edit e) {
        if (!Models.WorldState.onWorld()) {
            return;
        }
        StyledText message = e.getMessage();
        StyledText unwrapped = StyledTextUtils.unwrap(message);
        StyledText modified = unwrapped.iterate((part, changes) -> {
            this.decodeChatEncoding((List<StyledTextPart>)changes, (StyledTextPart)part);
            return IterationDecision.CONTINUE;
        });
        if (modified.equals(unwrapped)) {
            return;
        }
        e.setMessage(modified);
    }

    private void shareItem(Slot hoveredSlot, boolean share) {
        if (hoveredSlot == null) {
            return;
        }
        Optional<GearItem> gearItemOpt = Models.Item.asWynnItem(hoveredSlot.getItem(), GearItem.class);
        if (gearItemOpt.isPresent() && gearItemOpt.get().isUnidentified()) {
            WynntilsMod.warn("Cannot make chat link of unidentified gear");
            McUtils.sendErrorToClient(I18n.get((String)"feature.wynntils.chatItem.chatItemUnidentifiedError", (Object[])new Object[0]));
            return;
        }
        Optional<WynnItem> wynnItemOpt = Models.Item.getWynnItem(hoveredSlot.getItem());
        if (wynnItemOpt.isEmpty()) {
            return;
        }
        if (!Models.ItemEncoding.canEncodeItem(wynnItemOpt.get())) {
            return;
        }
        if (share) {
            if (((Boolean)this.showSharingScreen.get()).booleanValue()) {
                McUtils.setScreen(ItemSharingScreen.create(wynnItemOpt.get(), hoveredSlot.getItem()));
            } else {
                this.makeChatPrompt(wynnItemOpt.get());
            }
        } else {
            ItemStack itemStackToSave = hoveredSlot.getItem();
            WynnItem wynnItem = wynnItemOpt.get();
            if (wynnItem instanceof GearItem) {
                GearItem gearItem = (GearItem)wynnItem;
                itemStackToSave = new FakeItemStack(gearItem, "From " + McUtils.playerName() + "'s Item Record");
            }
            Services.ItemRecord.saveItem(wynnItemOpt.get(), itemStackToSave, hoveredSlot.getItem().getHoverName());
        }
    }

    private void decodeChatEncoding(List<StyledTextPart> changes, StyledTextPart partToReplace) {
        Matcher matcher = Models.ItemEncoding.getEncodedDataPattern().matcher(partToReplace.getString(null, StyleType.NONE));
        while (matcher.find()) {
            String itemName = matcher.group("name");
            EncodedByteBuffer encodedByteBuffer = EncodedByteBuffer.fromUtf16String(matcher.group("data"));
            ErrorOr<WynnItem> errorOrDecodedItem = Models.ItemEncoding.decodeItem(encodedByteBuffer, itemName);
            String unformattedString = partToReplace.getString(null, StyleType.NONE);
            String firstPart = unformattedString.substring(0, matcher.start());
            String lastPart = unformattedString.substring(matcher.end());
            PartStyle partStyle = partToReplace.getPartStyle();
            StyledTextPart first = new StyledTextPart(firstPart, partStyle.getStyle(), null, Style.EMPTY);
            List<StyledTextPart> replacedParts = errorOrDecodedItem.hasError() ? List.of(this.createErrorPart(matcher.group(), errorOrDecodedItem.getError())) : this.createItemPart(errorOrDecodedItem.getValue());
            StyledTextPart last = new StyledTextPart(lastPart, partStyle.getStyle(), null, Style.EMPTY);
            changes.remove(partToReplace);
            changes.add(first);
            changes.addAll(replacedParts);
            changes.add(last);
            partToReplace = last;
            matcher = Models.ItemEncoding.getEncodedDataPattern().matcher(lastPart);
        }
    }

    private StyledTextPart createErrorPart(String originalString, String error) {
        Style style = Style.EMPTY.applyFormat(ChatFormatting.UNDERLINE).withColor(ChatFormatting.RED);
        HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)error).withStyle(ChatFormatting.RED));
        style = style.withHoverEvent(hoverEvent);
        return new StyledTextPart(originalString, style, null, Style.EMPTY);
    }

    private List<StyledTextPart> createItemPart(WynnItem wynnItem) {
        ShinyItemProperty shinyItemProperty;
        ArrayList<StyledTextPart> parts = new ArrayList<StyledTextPart>();
        StyledText nameText = StyledText.fromString(wynnItem.getClass().getSimpleName());
        if (wynnItem instanceof NamedItemProperty) {
            NamedItemProperty namedItemProperty = (NamedItemProperty)((Object)wynnItem);
            nameText = StyledText.fromString(namedItemProperty.getName());
            if (((Boolean)this.showPerfectOrDefective.get()).booleanValue() && wynnItem instanceof IdentifiableItemProperty) {
                IdentifiableItemProperty identifiableItemProperty = (IdentifiableItemProperty)((Object)wynnItem);
                if (identifiableItemProperty.isPerfect()) {
                    nameText = StyledText.fromComponent((Component)ComponentUtils.makeRainbowStyle("Perfect " + nameText.getString(), true));
                } else if (identifiableItemProperty.isDefective()) {
                    nameText = StyledText.fromComponent((Component)ComponentUtils.makeObfuscated("Defective " + nameText.getString(), 0.0f, 0.0f));
                }
            }
        }
        if (wynnItem instanceof ShinyItemProperty && (shinyItemProperty = (ShinyItemProperty)((Object)wynnItem)).getShinyStat().isPresent()) {
            parts.add(new StyledTextPart("\u2b21 ", Style.EMPTY.withColor(ChatFormatting.WHITE), null, Style.EMPTY));
        }
        Style style = Style.EMPTY.applyFormat(ChatFormatting.UNDERLINE).withColor(ChatFormatting.GOLD);
        if (wynnItem instanceof GearTierItemProperty) {
            GearTierItemProperty tierItemProperty = (GearTierItemProperty)((Object)wynnItem);
            style = style.withColor(tierItemProperty.getGearTier().getChatFormatting());
        }
        FakeItemStack itemStack = new FakeItemStack(wynnItem, "From chat");
        HoverEvent.ItemStackInfo itemHoverEvent = new HoverEvent.ItemStackInfo((ItemStack)itemStack);
        ((ItemStackInfoAccessor)itemHoverEvent).setItemStack(itemStack);
        style = style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ITEM, (Object)itemHoverEvent));
        StyledText appenedNameText = StyledText.fromComponent((Component)Component.empty().withStyle(style).append((Component)nameText.getComponent()));
        parts.addAll(Arrays.stream(appenedNameText.getPartsAsTextArray()).map(StyledText::getFirstPart).map(part -> part.withStyle(part.getPartStyle().withUnderlined(true))).toList());
        return parts;
    }

    private void makeChatPrompt(WynnItem wynnItem) {
        EncodingSettings encodingSettings = new EncodingSettings((Boolean)Models.ItemEncoding.extendedIdentificationEncoding.get(), false);
        ErrorOr<EncodedByteBuffer> errorOrEncodedByteBuffer = Models.ItemEncoding.encodeItem(wynnItem, encodingSettings);
        if (errorOrEncodedByteBuffer.hasError()) {
            WynntilsMod.error("Failed to encode item: " + errorOrEncodedByteBuffer.getError());
            McUtils.sendErrorToClient(I18n.get((String)"feature.wynntils.chatItem.chatItemErrorEncode", (Object[])new Object[]{errorOrEncodedByteBuffer.getError()}));
            return;
        }
        if (WynntilsMod.isDevelopmentEnvironment()) {
            WynntilsMod.info("Encoded item: " + String.valueOf(errorOrEncodedByteBuffer.getValue()));
            WynntilsMod.info("Encoded item UTF-16: " + errorOrEncodedByteBuffer.getValue().toUtf16String());
        }
        McUtils.sendMessageToClient((Component)Component.translatable((String)"feature.wynntils.chatItem.chatItemMessage").withStyle(ChatFormatting.DARK_GREEN).withStyle(ChatFormatting.UNDERLINE).withStyle(s -> s.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, Models.ItemEncoding.makeItemString(wynnItem, (EncodedByteBuffer)errorOrEncodedByteBuffer.getValue())))).withStyle(s -> s.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"feature.wynntils.chatItem.chatItemTooltip").withStyle(ChatFormatting.DARK_AQUA)))));
    }
}

