/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.combat;

import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.mc.event.ContainerClickEvent;
import com.wynntils.mc.event.ContainerCloseEvent;
import com.wynntils.models.containers.containers.reward.RewardContainer;
import com.wynntils.models.gear.type.GearTier;
import com.wynntils.models.items.items.game.EmeraldPouchItem;
import com.wynntils.models.items.items.gui.IngredientPouchItem;
import com.wynntils.models.items.properties.GearTierItemProperty;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.wynn.ContainerUtils;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.COMBAT)
public class ChestBlockerFeature
extends Feature {
    @Persisted
    private final Config<Boolean> preventPouchClick = new Config<Boolean>(true);
    @Persisted
    private final Config<EmeraldPouchTier> emeraldPouchTier = new Config<EmeraldPouchTier>(EmeraldPouchTier.EIGHT);

    @SubscribeEvent
    public void onChestCloseAttempt(ContainerCloseEvent.Pre e) {
        if (!Models.WorldState.onWorld()) {
            return;
        }
        if (!(Models.Container.getCurrentContainer() instanceof RewardContainer)) {
            return;
        }
        NonNullList<ItemStack> items = ContainerUtils.getItems(McUtils.screen());
        int i = 0;
        while (true) {
            Optional<EmeraldPouchItem> emeraldPouchItem;
            if (i >= 27) break;
            ItemStack itemStack = (ItemStack)items.get(i);
            Optional<GearTierItemProperty> tieredItem = Models.Item.asWynnItemProperty(itemStack, GearTierItemProperty.class);
            if (tieredItem.isPresent() && tieredItem.get().getGearTier() == GearTier.MYTHIC) {
                McUtils.sendMessageToClient((Component)Component.translatable((String)"feature.wynntils.chestBlocker.closingBlocked").withStyle(ChatFormatting.RED));
                e.setCanceled(true);
                return;
            }
            if (this.emeraldPouchTier.get() != EmeraldPouchTier.NONE && (emeraldPouchItem = Models.Item.asWynnItem(itemStack, EmeraldPouchItem.class)).isPresent() && emeraldPouchItem.get().getTier() >= ((EmeraldPouchTier)((Object)this.emeraldPouchTier.get())).getTier()) {
                McUtils.sendMessageToClient((Component)Component.translatable((String)"feature.wynntils.chestBlocker.closingBlockedPouch", (Object[])new Object[]{emeraldPouchItem.get().getTier()}).withStyle(ChatFormatting.RED));
                e.setCanceled(true);
                return;
            }
            ++i;
        }
    }

    @SubscribeEvent
    public void onIngredientPouchClick(ContainerClickEvent event) {
        if (!Models.WorldState.onWorld()) {
            return;
        }
        if (!((Boolean)this.preventPouchClick.get()).booleanValue()) {
            return;
        }
        if (!(Models.Container.getCurrentContainer() instanceof RewardContainer)) {
            return;
        }
        Optional<IngredientPouchItem> ingredientPouchItem = Models.Item.asWynnItem(event.getItemStack(), IngredientPouchItem.class);
        Optional<EmeraldPouchItem> emeraldPouchItem = Models.Item.asWynnItem(event.getItemStack(), EmeraldPouchItem.class);
        if (ingredientPouchItem.isEmpty() && emeraldPouchItem.isEmpty()) {
            return;
        }
        if (emeraldPouchItem.isPresent()) {
            if (event.getSlotNum() < 27) {
                return;
            }
        }
        McUtils.sendMessageToClient((Component)Component.translatable((String)"feature.wynntils.chestBlocker.pouchBlocked").withStyle(ChatFormatting.RED));
        event.setCanceled(true);
    }

    private static enum EmeraldPouchTier {
        NONE(-1),
        SEVEN(7),
        EIGHT(8),
        NINE(9),
        TEN(10);

        private final int tier;

        private EmeraldPouchTier(int tier) {
            this.tier = tier;
        }

        public int getTier() {
            return this.tier;
        }
    }
}

