/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.inventory;

import com.wynntils.core.components.Handlers;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.RegisterKeyBind;
import com.wynntils.core.keybinds.KeyBind;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.event.MenuEvent;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.wynn.ContainerUtils;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.INVENTORY)
public class GuildBankHotkeyFeature
extends Feature {
    private static final Pattern MANAGE_TITLE_PATTERN = Pattern.compile(".+: Manage");
    private static final int GUILD_BANK_SLOT = 15;
    @RegisterKeyBind
    private final KeyBind guildBankKeybind = new KeyBind("Open Guild Bank", 80, true, this::onOpenGuildBankKeyPress);
    private boolean openGuildBank = false;

    @SubscribeEvent
    public void onMenuOpenPre(MenuEvent.MenuOpenedEvent.Pre event) {
        if (!this.openGuildBank) {
            return;
        }
        this.openGuildBank = false;
        StyledText title = StyledText.fromComponent(event.getTitle());
        if (title.matches(MANAGE_TITLE_PATTERN)) {
            event.setCanceled(true);
            AbstractContainerMenu container = event.getMenuType().create(event.getContainerId(), McUtils.inventory());
            ContainerUtils.clickOnSlot(15, event.getContainerId(), 0, (List<ItemStack>)container.getItems());
        }
    }

    private void onOpenGuildBankKeyPress() {
        this.openGuildBank = true;
        Handlers.Command.sendCommandImmediately("guild manage");
    }
}

