/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.ui;

import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.wrappedscreen.event.WrappedScreenOpenEvent;
import com.wynntils.mc.event.ContainerClickEvent;
import com.wynntils.mc.event.ItemTooltipRenderEvent;
import com.wynntils.screens.trademarket.TradeMarketSearchResultScreen;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.type.ShiftBehavior;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.UI)
public class CustomTradeMarketResultScreenFeature
extends Feature {
    private static final String SEARCH_ITEM_TITLE = "\u00a7a\u00a7lSearch";
    @Persisted
    private final Config<ShiftBehavior> shiftBehaviorConfig = new Config<ShiftBehavior>(ShiftBehavior.DISABLED_IF_SHIFT_HELD);
    private boolean shiftClickedSearchItem = false;

    @SubscribeEvent
    public void onWrappedScreenOpen(WrappedScreenOpenEvent event) {
        if (event.getWrappedScreenClass() != TradeMarketSearchResultScreen.class) {
            return;
        }
        boolean shouldOpen = false;
        switch ((ShiftBehavior)((Object)this.shiftBehaviorConfig.get())) {
            case NONE: {
                shouldOpen = true;
                break;
            }
            case ENABLED_IF_SHIFT_HELD: {
                if (!this.shiftClickedSearchItem) break;
                shouldOpen = true;
                break;
            }
            case DISABLED_IF_SHIFT_HELD: {
                if (this.shiftClickedSearchItem) break;
                shouldOpen = true;
            }
        }
        if (shouldOpen) {
            event.setOpenScreen(true);
        }
    }

    @SubscribeEvent
    public void onContainerClick(ContainerClickEvent event) {
        if (!StyledText.fromComponent(event.getItemStack().getHoverName()).equalsString(SEARCH_ITEM_TITLE)) {
            return;
        }
        this.shiftClickedSearchItem = KeyboardUtils.isShiftDown();
    }

    @SubscribeEvent
    public void onRenderTooltip(ItemTooltipRenderEvent.Pre event) {
        if (this.shiftBehaviorConfig.get() == ShiftBehavior.NONE) {
            return;
        }
        if (McUtils.screen() == null) {
            return;
        }
        if (!Models.TradeMarket.isFilterScreen(McUtils.screen().getTitle())) {
            return;
        }
        if (!StyledText.fromComponent(event.getItemStack().getHoverName()).equalsString(SEARCH_ITEM_TITLE)) {
            return;
        }
        ItemStack itemStack = event.getItemStack();
        ArrayList<Component> tooltips = new ArrayList<Component>(event.getTooltips());
        MutableComponent component = switch ((ShiftBehavior)((Object)this.shiftBehaviorConfig.get())) {
            default -> throw new MatchException(null, null);
            case ShiftBehavior.NONE -> Component.empty();
            case ShiftBehavior.ENABLED_IF_SHIFT_HELD -> Component.translatable((String)"feature.wynntils.customTradeMarketResultScreen.shiftToEnable");
            case ShiftBehavior.DISABLED_IF_SHIFT_HELD -> Component.translatable((String)"feature.wynntils.customTradeMarketResultScreen.shiftToDisable");
        };
        tooltips.add((Component)Component.empty());
        tooltips.add((Component)component.withStyle(ChatFormatting.GREEN));
        event.setTooltips(tooltips);
    }
}

