/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.ui;

import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.persisted.storage.Storage;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.event.ScreenInitEvent;
import com.wynntils.mc.event.ScreenOpenedEvent;
import com.wynntils.mc.event.TitleScreenInitEvent;
import com.wynntils.models.worlds.type.ServerRegion;
import com.wynntils.screens.downloads.DownloadScreen;
import com.wynntils.screens.update.UpdateScreen;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.buffered.BufferedRenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerStatusPinger;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import org.apache.commons.lang3.Validate;

@ConfigCategory(value=Category.UI)
public class WynncraftButtonFeature
extends Feature {
    private static final String WYNNCRAFT_DOMAIN = ".wynncraft.com";
    private boolean firstTitleScreenInit = true;
    private boolean hasUsedButton = false;
    @Persisted
    private final Config<ServerType> serverType = new Config<ServerType>(ServerType.GAME);
    @Persisted
    private final Config<ServerRegion> serverRegionOverride = new Config<ServerRegion>(ServerRegion.WC);
    @Persisted
    private final Config<Boolean> autoConnect = new Config<Boolean>(false);
    @Persisted
    private final Config<Boolean> loadResourcePack = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> cancelAutoJoin = new Config<Boolean>(true);
    @Persisted
    public final Storage<Boolean> ignoreFailedDownloads = new Storage<Boolean>(false);
    @Persisted
    private final Config<Boolean> returnToTitle = new Config<Boolean>(true);

    @SubscribeEvent
    public void onTitleScreenInit(TitleScreenInitEvent.Post event) {
        TitleScreen titleScreen = event.getTitleScreen();
        this.addWynncraftButton(titleScreen);
    }

    @SubscribeEvent
    public void onScreenOpen(ScreenOpenedEvent.Pre event) {
        if (!this.hasUsedButton) {
            return;
        }
        if (event.getScreen() instanceof TitleScreen) {
            this.hasUsedButton = false;
            return;
        }
        if (event.getScreen() instanceof JoinMultiplayerScreen) {
            this.hasUsedButton = false;
            if (((Boolean)this.returnToTitle.get()).booleanValue()) {
                event.setCanceled(true);
                McUtils.setScreen((Screen)new TitleScreen());
            }
        }
    }

    @SubscribeEvent
    public void onScreenInit(ScreenInitEvent.Pre event) {
        Screen screen = event.getScreen();
        if (!(screen instanceof TitleScreen)) {
            return;
        }
        TitleScreen titleScreen = (TitleScreen)screen;
        if (this.firstTitleScreenInit && ((Boolean)this.autoConnect.get()).booleanValue()) {
            this.firstTitleScreenInit = false;
            if (Managers.Download.graphState().error() && ((Boolean)this.cancelAutoJoin.get()).booleanValue() && !((Boolean)this.ignoreFailedDownloads.get()).booleanValue()) {
                WynntilsMod.warn("Downloads have failed, auto join is cancelled.");
                return;
            }
            if (Services.Update.shouldPromptUpdate()) {
                WynntilsMod.info("Cancelling auto join, update available");
                return;
            }
            ServerData wynncraftServer = this.getWynncraftServer();
            this.connectToServer(wynncraftServer);
            return;
        }
        this.addWynncraftButton(titleScreen);
    }

    private void addWynncraftButton(TitleScreen titleScreen) {
        if (titleScreen.children.stream().anyMatch(child -> child instanceof WynncraftButton)) {
            return;
        }
        ServerData wynncraftServer = this.getWynncraftServer();
        WarningType warningType = WarningType.NONE;
        if (Managers.Download.graphState().error()) {
            warningType = WarningType.DOWNLOADS;
        } else if (Services.Update.shouldPromptUpdate()) {
            warningType = WarningType.UPDATE;
        }
        WynncraftButton wynncraftButton = new WynncraftButton((Screen)titleScreen, wynncraftServer, titleScreen.width / 2 + 104, titleScreen.height / 4 + 48 + 24, warningType, (Boolean)this.ignoreFailedDownloads.get(), this::onPress);
        titleScreen.addRenderableWidget((GuiEventListener)wynncraftButton);
    }

    private ServerData getWynncraftServer() {
        String ip = (this.serverType.get() == ServerType.GAME && this.serverRegionOverride.get() != ServerRegion.WC ? ((ServerRegion)((Object)this.serverRegionOverride.get())).name().toLowerCase(Locale.ROOT) : ((ServerType)((Object)this.serverType.get())).serverAddressPrefix) + WYNNCRAFT_DOMAIN;
        ServerData wynncraftServer = new ServerData("Wynncraft", ip, ServerData.Type.OTHER);
        wynncraftServer.setResourcePackStatus((Boolean)this.loadResourcePack.get() != false ? ServerData.ServerPackStatus.ENABLED : ServerData.ServerPackStatus.DISABLED);
        return wynncraftServer;
    }

    private void connectToServer(ServerData serverData) {
        this.hasUsedButton = true;
        ConnectScreen.startConnecting((Screen)McUtils.screen(), (Minecraft)McUtils.mc(), (ServerAddress)ServerAddress.parseString((String)serverData.ip), (ServerData)serverData, (boolean)false, null);
    }

    private void onPress(Button button) {
        if (!(button instanceof WynncraftButton)) {
            return;
        }
        WynncraftButton wynncraftButton = (WynncraftButton)button;
        if (!Managers.Download.graphState().finished()) {
            return;
        }
        if (wynncraftButton.warningType == WarningType.UPDATE) {
            McUtils.setScreen(UpdateScreen.create(wynncraftButton.serverData, wynncraftButton.titleScreen));
        } else if (wynncraftButton.warningType == WarningType.DOWNLOADS && !wynncraftButton.ignoreFailedDownloads) {
            McUtils.setScreen(DownloadScreen.create(McUtils.screen(), wynncraftButton.serverData));
        } else {
            this.connectToServer(wynncraftButton.serverData);
        }
    }

    private static enum ServerType {
        LOBBY("lobby"),
        GAME("play"),
        MEDIA("media"),
        BETA("beta");

        private final String serverAddressPrefix;

        private ServerType(String serverAddressPrefix) {
            this.serverAddressPrefix = serverAddressPrefix;
        }
    }

    private static enum WarningType {
        NONE,
        DOWNLOADS,
        UPDATE;

    }

    private static class WynncraftButton
    extends Button {
        private static final List<Component> CONNECT_TOOLTIP = List.of(Component.translatable((String)"feature.wynntils.wynncraftButton.connect"));
        private static final List<Component> DOWNLOAD_TOOLTIP = List.of(Component.translatable((String)"feature.wynntils.wynncraftButton.download1"), Component.translatable((String)"feature.wynntils.wynncraftButton.download2"));
        private static final List<Component> UPDATE_TOOLTIP = List.of(Component.translatable((String)"feature.wynntils.wynncraftButton.update"));
        private final Screen titleScreen;
        private final ServerData serverData;
        private final ServerIcon serverIcon;
        private final WarningType warningType;
        private final boolean ignoreFailedDownloads;
        private final List<Component> tooltip;

        WynncraftButton(Screen titleScreen, ServerData serverData, int x, int y, WarningType warningType, boolean ignoreFailedDownloads, Button.OnPress onPress) {
            super(x, y, 20, 20, (Component)Component.literal((String)""), onPress, Button.DEFAULT_NARRATION);
            this.serverData = serverData;
            this.titleScreen = titleScreen;
            this.serverIcon = new ServerIcon(serverData);
            this.serverIcon.loadResource(false);
            this.warningType = warningType;
            this.ignoreFailedDownloads = ignoreFailedDownloads;
            this.tooltip = warningType == WarningType.DOWNLOADS ? DOWNLOAD_TOOLTIP : (warningType == WarningType.UPDATE ? UPDATE_TOOLTIP : CONNECT_TOOLTIP);
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
            if (this.serverIcon == null || this.serverIcon.getServerIconLocation() == null) {
                return;
            }
            BufferedRenderUtils.drawScalingTexturedRect(guiGraphics.pose(), (MultiBufferSource)guiGraphics.bufferSource, this.serverIcon.getServerIconLocation(), this.getX() + 3, this.getY() + 3, 0.0f, this.width - 6, this.height - 6, 64, 64);
            if (this.warningType == WarningType.DOWNLOADS) {
                FontRenderer.getInstance().renderText(guiGraphics.pose(), StyledText.fromString("\u26a0"), this.getX() + 20, this.getY(), CommonColors.RED, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.OUTLINE);
            } else if (this.warningType == WarningType.UPDATE) {
                FontRenderer.getInstance().renderText(guiGraphics.pose(), StyledText.fromString("\u27f3"), (float)(this.getX() + 2), (float)this.getY(), CommonColors.YELLOW, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.OUTLINE, 1.5f);
            }
            if (this.isHovered) {
                McUtils.screen().setTooltipForNextRenderPass(Lists.transform(this.tooltip, Component::getVisualOrderText));
            }
        }
    }

    private static final class ServerIcon {
        private static final ResourceLocation FALLBACK = Texture.WYNNCRAFT_ICON.resource();
        private final ServerData server;
        private ResourceLocation serverIconLocation;
        private final Consumer<ServerIcon> onDone;

        private ServerIcon(ServerData server, Consumer<ServerIcon> onDone) {
            this.server = server;
            this.onDone = onDone;
            this.serverIconLocation = FALLBACK;
        }

        private void loadResource(boolean allowStale) {
            ResourceLocation destination = ResourceLocation.withDefaultNamespace((String)("servers/" + String.valueOf(Hashing.sha1().hashUnencodedChars((CharSequence)this.server.ip)) + "/icon"));
            if (allowStale && McUtils.mc().getTextureManager().getTexture(destination) != null) {
                this.serverIconLocation = destination;
                this.onDone();
                return;
            }
            try {
                ServerStatusPinger pinger = new ServerStatusPinger();
                pinger.pingServer(this.server, () -> {}, this::onDone);
            }
            catch (Exception e) {
                WynntilsMod.warn("Failed to ping server", e);
                this.onDone();
            }
        }

        private ServerIcon(ServerData server) {
            this(server, null);
        }

        public boolean isSuccess() {
            return !FALLBACK.equals((Object)this.serverIconLocation);
        }

        public ServerData getServer() {
            return this.server;
        }

        private synchronized ResourceLocation getServerIconLocation() {
            return this.serverIconLocation;
        }

        private void onDone() {
            if (this.onDone != null) {
                this.onDone.accept(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void loadServerIcon(ResourceLocation destination) {
            byte[] iconBytes = this.server.getIconBytes();
            if (iconBytes == null) {
                WynntilsMod.warn("Unable to load icon");
                this.serverIconLocation = FALLBACK;
                return;
            }
            ByteBuffer iconBytesBuffer = ByteBuffer.wrap(iconBytes);
            try (NativeImage nativeImage = NativeImage.read((ByteBuffer)iconBytesBuffer);){
                Validate.validState((nativeImage.getWidth() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((nativeImage.getHeight() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                ServerIcon serverIcon = this;
                synchronized (serverIcon) {
                    RenderSystem.recordRenderCall(() -> {
                        McUtils.mc().getTextureManager().register(destination, (AbstractTexture)new DynamicTexture(nativeImage));
                        this.serverIconLocation = destination;
                    });
                }
            }
            catch (IOException e) {
                WynntilsMod.error("Unable to read server image: " + this.server.name, e);
                this.serverIconLocation = FALLBACK;
            }
        }
    }
}

