/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.utilities;

import com.mojang.blaze3d.systems.RenderSystem;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.event.ContainerClickEvent;
import com.wynntils.mc.event.ContainerCloseEvent;
import com.wynntils.mc.event.SetSlotEvent;
import com.wynntils.mc.event.SlotRenderEvent;
import com.wynntils.mc.event.TickEvent;
import com.wynntils.models.containers.Container;
import com.wynntils.models.containers.containers.BlacksmithContainer;
import com.wynntils.models.containers.containers.ItemIdentifierAugmentsContainer;
import com.wynntils.models.containers.containers.ItemIdentifierContainer;
import com.wynntils.models.containers.containers.trademarket.TradeMarketSellContainer;
import com.wynntils.models.containers.type.BoundedContainerProperty;
import com.wynntils.models.gear.type.GearTier;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.items.game.TomeItem;
import com.wynntils.models.items.properties.GearTierItemProperty;
import com.wynntils.models.items.properties.IdentifiableItemProperty;
import com.wynntils.models.items.properties.LeveledItemProperty;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.UTILITIES)
public class ValuablesProtectionFeature
extends Feature {
    @Persisted
    private final Config<Float> tradeMarketPriceThreshold = new Config<Float>(Float.valueOf(90.0f));
    @Persisted
    private final Config<ProtectableNPCs> mythicWarningNPCs = new Config<ProtectableNPCs>(ProtectableNPCs.BLACKSMITH_AND_TRADE_MARKET);
    @Persisted
    private final Config<ProtectableNPCs> highRollWarningNPCs = new Config<ProtectableNPCs>(ProtectableNPCs.ALL);
    @Persisted
    private final Config<Float> highRollThreshold = new Config<Float>(Float.valueOf(80.0f));
    @Persisted
    private final Config<Boolean> tomesWarning = new Config<Boolean>(false);
    @Persisted
    private final Config<Integer> craftedBlacksmithLevel = new Config<Integer>(0);
    @Persisted
    private final Config<Boolean> requireCtrlToSell = new Config<Boolean>(false);
    private static final ResourceLocation CIRCLE_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/wynn/gui/tutorial.png");
    private static final int BLACKSMITH_IDENTIFIER_CONFIRM_BUTTON_SLOT = 17;
    private static final int TM_ITEM_SLOT = 22;
    private static final int TM_PRICE_SLOT = 28;
    private static final int TM_CONFIRM_BUTTON_SLOT = 34;
    private static final StyledText WITHDRAW_STATE = StyledText.fromString("\u00a7a\u00a7lWithdraw Items");
    private Class<? extends BoundedContainerProperty> currentContainerType;
    private List<Integer> slotsToWarn = new ArrayList<Integer>();
    private HintTextWidget ctrlHintTextWidget;
    private final List<HintTextWidget> tmHintTextWidgets = new ArrayList<HintTextWidget>();
    private int emphasizeAnimationFrame = 0;
    private int emphasizeAnimationDelay = 0;
    private int emphasizeDirection = 1;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderSlot(SlotRenderEvent.Pre e) {
        Container currentContainer = Models.Container.getCurrentContainer();
        if (this.currentContainerType != null && !this.currentContainerType.isInstance(currentContainer)) {
            return;
        }
        if (!this.slotsToWarn.contains(e.getSlot().index)) {
            return;
        }
        RenderSystem.enableDepthTest();
        RenderUtils.drawTexturedRectWithColor(e.getPoseStack(), CIRCLE_TEXTURE, CommonColors.RED, e.getSlot().x - 16, e.getSlot().y - 16, 200.0f, 48.0f, 48.0f, 0, this.emphasizeAnimationFrame * 48, 48, 48, 48, 192);
        RenderSystem.disableDepthTest();
    }

    @SubscribeEvent
    public void onSetSlot(SetSlotEvent.Post e) {
        Screen screen = McUtils.screen();
        if (!(screen instanceof ContainerScreen)) {
            return;
        }
        ContainerScreen cs = (ContainerScreen)screen;
        Container currentContainer = Models.Container.getCurrentContainer();
        if (currentContainer == null) {
            return;
        }
        boolean isIdentifier = ProtectableNPCs.IDENTIFIER.getContainers().stream().anyMatch(container -> container.equals(currentContainer.getClass()));
        if (isIdentifier && StyledText.fromComponent(((ChestMenu)cs.getMenu()).getSlot(17).getItem().getHoverName()).equals(WITHDRAW_STATE)) {
            this.resetAll();
            return;
        }
        this.resetAll();
        this.doBlacksmithIdentifierChecks(currentContainer, cs);
        this.doTradeMarketChecks(currentContainer, cs);
    }

    private void doBlacksmithIdentifierChecks(Container currentContainer, ContainerScreen cs) {
        for (Class<? extends BoundedContainerProperty> container : ProtectableNPCs.BLACKSMITH_AND_IDENTIFIER.getContainers()) {
            if (!currentContainer.getClass().equals(container)) continue;
            this.currentContainerType = container;
            for (int i : ((BoundedContainerProperty)((Object)currentContainer)).getBounds().getSlots()) {
                IdentifiableItemProperty identifiableItemProperty;
                boolean shouldWarn;
                WynnItem item;
                Optional<WynnItem> itemOpt = Models.Item.getWynnItem((ItemStack)((ChestMenu)cs.getMenu()).getItems().get(i));
                if (itemOpt.isEmpty() || (item = itemOpt.get()) instanceof TomeItem && !((Boolean)this.tomesWarning.get()).booleanValue()) continue;
                boolean bl = shouldWarn = ((ProtectableNPCs)((Object)this.highRollWarningNPCs.get())).getContainers().contains(container) && item instanceof IdentifiableItemProperty && (identifiableItemProperty = (IdentifiableItemProperty)((Object)item)).getOverallPercentage() >= ((Float)this.highRollThreshold.get()).floatValue();
                if (item instanceof GearTierItemProperty) {
                    LeveledItemProperty lip;
                    GearTierItemProperty gtip = (GearTierItemProperty)((Object)item);
                    if (((ProtectableNPCs)((Object)this.mythicWarningNPCs.get())).getContainers().contains(container) && gtip.getGearTier() == GearTier.MYTHIC) {
                        shouldWarn = true;
                    }
                    if ((Integer)this.craftedBlacksmithLevel.get() > 0 && gtip.getGearTier() == GearTier.CRAFTED && item instanceof LeveledItemProperty && (lip = (LeveledItemProperty)((Object)item)).getLevel() >= (Integer)this.craftedBlacksmithLevel.get()) {
                        shouldWarn = true;
                    }
                }
                if (!shouldWarn) continue;
                this.slotsToWarn.add(i);
            }
        }
        if (!this.slotsToWarn.isEmpty() && ((Boolean)this.requireCtrlToSell.get()).booleanValue()) {
            this.ctrlHintTextWidget = new HintTextWidget(cs.width / 2, cs.topPos - 6, cs.width, 11, I18n.get((String)"feature.wynntils.valuablesProtection.ctrlClick", (Object[])new Object[]{I18n.get((String)("feature.wynntils.valuablesProtection." + (ProtectableNPCs.IDENTIFIER.getContainers().contains(this.currentContainerType) ? "identifying" : "selling")), (Object[])new Object[0])}), HorizontalAlignment.CENTER, CommonColors.WHITE);
            cs.addRenderableOnly((Renderable)this.ctrlHintTextWidget);
        }
    }

    private void doTradeMarketChecks(Container currentContainer, ContainerScreen cs) {
        if (currentContainer instanceof TradeMarketSellContainer) {
            IdentifiableItemProperty identifiableItemProperty;
            boolean warnableItem;
            Optional<WynnItem> optItem = Models.Item.getWynnItem((ItemStack)((ChestMenu)cs.getMenu()).getItems().get(22));
            if (optItem.isEmpty()) {
                return;
            }
            WynnItem item = optItem.get();
            boolean bl = warnableItem = ((ProtectableNPCs)((Object)this.highRollWarningNPCs.get())).getContainers().contains(TradeMarketSellContainer.class) && item instanceof IdentifiableItemProperty && (identifiableItemProperty = (IdentifiableItemProperty)((Object)item)).getOverallPercentage() >= ((Float)this.highRollThreshold.get()).floatValue();
            if (item instanceof GearTierItemProperty) {
                GearTierItemProperty gtip = (GearTierItemProperty)((Object)item);
                if (((ProtectableNPCs)((Object)this.mythicWarningNPCs.get())).getContainers().contains(TradeMarketSellContainer.class) && gtip.getGearTier() == GearTier.MYTHIC) {
                    warnableItem = true;
                }
            }
            if (!warnableItem) {
                return;
            }
            int salePrice = Models.TradeMarket.getUnitPrice();
            int lowestPrice = Models.TradeMarket.getPriceCheckInfo().ask();
            if (salePrice == -1 || lowestPrice == -1) {
                return;
            }
            this.slotsToWarn.add(28);
            if ((double)salePrice < (double)lowestPrice * ((double)((Float)this.tradeMarketPriceThreshold.get()).floatValue() / 100.0)) {
                this.ctrlHintTextWidget = new HintTextWidget(cs.width - cs.leftPos + 2, cs.height / 2, cs.leftPos, 11, I18n.get((String)"feature.wynntils.valuablesProtection.ctrlClick", (Object[])new Object[]{I18n.get((String)"feature.wynntils.valuablesProtection.selling", (Object[])new Object[0])}), HorizontalAlignment.LEFT, CommonColors.WHITE);
                cs.addRenderableOnly((Renderable)this.ctrlHintTextWidget);
                this.tmHintTextWidgets.add(new HintTextWidget(cs.width - cs.leftPos + 2, cs.height / 2 + 20, cs.leftPos, 11, I18n.get((String)"feature.wynntils.valuablesProtection.tmWarning", (Object[])new Object[]{salePrice + " " + String.valueOf(ChatFormatting.DARK_GRAY) + "(" + Models.Emerald.getFormattedString(salePrice, false) + ")" + String.valueOf(ChatFormatting.RESET), this.tradeMarketPriceThreshold.get(), lowestPrice + " " + String.valueOf(ChatFormatting.DARK_GRAY) + "(" + Models.Emerald.getFormattedString(lowestPrice, false) + ")" + String.valueOf(ChatFormatting.RESET)}), HorizontalAlignment.LEFT, CommonColors.LIGHT_GRAY));
                this.tmHintTextWidgets.add(new HintTextWidget(cs.width - cs.leftPos + 2, cs.height / 2 + 56, cs.leftPos, 11, I18n.get((String)"feature.wynntils.valuablesProtection.settingsHint", (Object[])new Object[0]), HorizontalAlignment.LEFT, CommonColors.GRAY));
                this.tmHintTextWidgets.forEach(arg_0 -> ((ContainerScreen)cs).addRenderableOnly(arg_0));
            } else {
                this.resetAll();
            }
        }
    }

    @SubscribeEvent
    public void onSlotClicked(ContainerClickEvent e) {
        if (this.slotsToWarn.isEmpty() || KeyboardUtils.isControlDown() || !((Boolean)this.requireCtrlToSell.get()).booleanValue()) {
            return;
        }
        if (e.getSlotNum() != 17 && e.getSlotNum() != 34) {
            return;
        }
        e.setCanceled(true);
        for (int i = 0; i < 12; i += 6) {
            Managers.TickScheduler.scheduleLater(() -> {
                if (this.ctrlHintTextWidget != null) {
                    this.ctrlHintTextWidget.setTextColor(CommonColors.RED);
                }
            }, i);
            Managers.TickScheduler.scheduleLater(() -> {
                if (this.ctrlHintTextWidget != null) {
                    this.ctrlHintTextWidget.setTextColor(CommonColors.WHITE);
                }
            }, i + 3);
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent e) {
        if (!(McUtils.screen() instanceof ContainerScreen)) {
            return;
        }
        ++this.emphasizeAnimationDelay;
        if (this.emphasizeAnimationDelay % 4 == 0) {
            this.emphasizeAnimationFrame += this.emphasizeDirection;
            if (this.emphasizeAnimationFrame == 4 || this.emphasizeAnimationFrame == -1) {
                this.emphasizeDirection *= -1;
                this.emphasizeAnimationFrame = Math.max(0, Math.min(3, this.emphasizeAnimationFrame));
            }
        }
    }

    @SubscribeEvent
    public void onContainerClose(ContainerCloseEvent.Post e) {
        this.resetAll();
    }

    private void resetAll() {
        Screen screen = McUtils.screen();
        if (screen instanceof ContainerScreen) {
            ContainerScreen cs = (ContainerScreen)screen;
            cs.removeWidget((GuiEventListener)this.ctrlHintTextWidget);
            this.tmHintTextWidgets.forEach(arg_0 -> ((ContainerScreen)cs).removeWidget(arg_0));
        }
        this.ctrlHintTextWidget = null;
        this.tmHintTextWidgets.clear();
        this.slotsToWarn = new ArrayList<Integer>();
        this.currentContainerType = null;
    }

    private static enum ProtectableNPCs {
        NONE(List.of()),
        BLACKSMITH(List.of(BlacksmithContainer.class)),
        TRADE_MARKET(List.of(TradeMarketSellContainer.class)),
        IDENTIFIER(List.of(ItemIdentifierContainer.class, ItemIdentifierAugmentsContainer.class)),
        BLACKSMITH_AND_TRADE_MARKET(List.of(BlacksmithContainer.class, TradeMarketSellContainer.class)),
        BLACKSMITH_AND_IDENTIFIER(List.of(BlacksmithContainer.class, ItemIdentifierContainer.class, ItemIdentifierAugmentsContainer.class)),
        TRADE_MARKET_AND_IDENTIFIER(List.of(TradeMarketSellContainer.class, ItemIdentifierContainer.class, ItemIdentifierAugmentsContainer.class)),
        ALL(List.of(BlacksmithContainer.class, TradeMarketSellContainer.class, ItemIdentifierContainer.class, ItemIdentifierAugmentsContainer.class));

        private final List<Class<? extends BoundedContainerProperty>> containers;

        private ProtectableNPCs(List<Class<? extends BoundedContainerProperty>> containers) {
            this.containers = containers;
        }

        public List<Class<? extends BoundedContainerProperty>> getContainers() {
            return this.containers;
        }
    }

    private static final class HintTextWidget
    extends AbstractWidget {
        private final String text;
        private final HorizontalAlignment horizontalAlignment;
        private CustomColor textColor;

        private HintTextWidget(int x, int y, int width, int height, String text, HorizontalAlignment horizontalAlignment, CustomColor defaultColor) {
            super(x, y, width, height, (Component)Component.literal((String)text));
            this.text = text;
            this.horizontalAlignment = horizontalAlignment;
            this.textColor = defaultColor;
        }

        protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            FontRenderer.getInstance().renderText(guiGraphics.pose(), StyledText.fromString(this.text), (float)this.getX(), (float)this.getY(), (float)this.getWidth(), this.textColor, this.horizontalAlignment, VerticalAlignment.BOTTOM, TextShadow.NORMAL, Font.DisplayMode.NORMAL);
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }

        protected void setTextColor(CustomColor textColor) {
            this.textColor = textColor;
        }
    }
}

