/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.handlers.tooltip.impl.crafted.components;

import com.wynntils.core.components.Models;
import com.wynntils.handlers.tooltip.impl.crafted.CraftedTooltipComponent;
import com.wynntils.models.activities.quests.QuestInfo;
import com.wynntils.models.activities.type.ActivityStatus;
import com.wynntils.models.character.type.ClassType;
import com.wynntils.models.elements.type.Element;
import com.wynntils.models.elements.type.Powder;
import com.wynntils.models.elements.type.Skill;
import com.wynntils.models.gear.type.GearRequirements;
import com.wynntils.models.items.items.game.CraftedGearItem;
import com.wynntils.models.stats.type.DamageType;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.type.Pair;
import com.wynntils.utils.type.RangedValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public class CraftedGearTooltipComponent
extends CraftedTooltipComponent<CraftedGearItem> {
    @Override
    public List<Component> buildHeaderTooltip(CraftedGearItem craftedItem) {
        int n;
        int health;
        ArrayList<Component> header = new ArrayList<Component>();
        header.add((Component)Component.literal((String)craftedItem.getName()).withStyle(ChatFormatting.DARK_AQUA).append((Component)Component.literal((String)(" [" + craftedItem.getEffectStrength() + "%]")).withStyle(ChatFormatting.AQUA)));
        if (craftedItem.getAttackSpeed().isPresent()) {
            header.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + craftedItem.getAttackSpeed().get().getName())));
        }
        header.add((Component)Component.literal((String)""));
        if (!craftedItem.getDamages().isEmpty()) {
            List<Pair<DamageType, RangedValue>> damages = craftedItem.getDamages();
            for (Pair<DamageType, RangedValue> damageStat : damages) {
                DamageType damageType = damageStat.key();
                String elementSymbol = damageType.getElement().isPresent() ? damageType.getElement().get().getSymbol() : damageType.getSymbol();
                MutableComponent damage = Component.empty().withStyle(damageType.getColorCode()).append((Component)Component.literal((String)elementSymbol).withStyle(Style.EMPTY.withFont(ResourceLocation.withDefaultNamespace((String)"common")))).append((Component)Component.literal((String)(" " + damageType.getDisplayName())));
                damage.append((Component)Component.literal((String)("Damage: " + ((RangedValue)damageStat.value()).asString())).withStyle(damageType == DamageType.NEUTRAL ? damageType.getColorCode() : ChatFormatting.GRAY));
                header.add((Component)damage);
            }
            header.add((Component)Component.literal((String)""));
        }
        if ((health = craftedItem.getHealth()) != 0) {
            MutableComponent healthComp = Component.literal((String)("\u2764 Health: " + StringUtils.toSignedString(health))).withStyle(ChatFormatting.DARK_RED);
            header.add((Component)healthComp);
        }
        if (!craftedItem.getDefences().isEmpty()) {
            List<Pair<Element, Integer>> defenses = craftedItem.getDefences();
            for (Pair pair : defenses) {
                Element element = (Element)((Object)pair.key());
                MutableComponent defense = Component.empty().withStyle(element.getColorCode()).append((Component)Component.literal((String)element.getSymbol()).withStyle(Style.EMPTY.withFont(ResourceLocation.withDefaultNamespace((String)"common")))).append((Component)Component.literal((String)(" " + element.getDisplayName())));
                defense.append((Component)Component.literal((String)(" Defence: " + StringUtils.toSignedString((Integer)pair.value()))).withStyle(ChatFormatting.GRAY));
                header.add((Component)defense);
            }
        }
        if (health != 0 || !craftedItem.getDefences().isEmpty()) {
            header.add((Component)Component.literal((String)""));
        }
        int requirementsCount = 0;
        GearRequirements requirements = craftedItem.getRequirements();
        if (requirements.classType().isPresent()) {
            ClassType classType = requirements.classType().get();
            boolean fulfilled = Models.Character.getClassType() == classType;
            header.add((Component)this.buildRequirementLine("Class Req: " + classType.getFullName(), fulfilled));
            ++requirementsCount;
        }
        if (requirements.quest().isPresent()) {
            String string = requirements.quest().get();
            Optional<QuestInfo> quest = Models.Quest.getQuestFromName(string);
            boolean fulfilled = quest.isPresent() && quest.get().status() == ActivityStatus.COMPLETED;
            header.add((Component)this.buildRequirementLine("Quest Req: " + string, fulfilled));
            ++requirementsCount;
        }
        if ((n = requirements.level()) != 0) {
            boolean fulfilled = Models.CombatXp.getCombatLevel().current() >= n;
            header.add((Component)this.buildRequirementLine("Combat Lv. Min: " + n, fulfilled));
            ++requirementsCount;
        }
        if (!requirements.skills().isEmpty()) {
            for (Pair<Skill, Integer> skillRequirement : requirements.skills()) {
                header.add((Component)this.buildRequirementLine(skillRequirement.key().getDisplayName() + " Min: " + String.valueOf(skillRequirement.value()), false));
                ++requirementsCount;
            }
        }
        if (requirementsCount > 0) {
            header.add((Component)Component.literal((String)""));
        }
        return header;
    }

    @Override
    public List<Component> buildFooterTooltip(CraftedGearItem craftedItem) {
        ArrayList<Component> footer = new ArrayList<Component>();
        footer.add((Component)Component.empty());
        if (!craftedItem.getPowders().isEmpty()) {
            MutableComponent powderLine = Component.literal((String)("[" + craftedItem.getPowders().size() + "/" + craftedItem.getPowderSlots() + "] Powder Slots ")).withStyle(ChatFormatting.GRAY);
            if (!craftedItem.getPowders().isEmpty()) {
                MutableComponent powderList = Component.literal((String)"[");
                for (Powder p : craftedItem.getPowders()) {
                    String symbol = String.valueOf(p.getSymbol());
                    if (!powderList.getSiblings().isEmpty()) {
                        powderList.append((Component)Component.empty().withStyle(Style.EMPTY.withColor(p.getLightColor())).append((Component)Component.literal((String)" ")).append((Component)Component.literal((String)symbol).withStyle(Style.EMPTY.withFont(ResourceLocation.withDefaultNamespace((String)"common")))));
                        continue;
                    }
                    powderList.append((Component)Component.literal((String)symbol).withStyle(Style.EMPTY.withFont(ResourceLocation.withDefaultNamespace((String)"common")).withColor(p.getLightColor())));
                }
                powderList.append((Component)Component.literal((String)"]"));
                powderLine.append((Component)powderList);
            }
            footer.add((Component)powderLine);
        }
        footer.add((Component)Component.literal((String)("Crafted " + StringUtils.capitalizeFirst(craftedItem.getGearType().name().toLowerCase(Locale.ROOT)))).withStyle(ChatFormatting.DARK_AQUA).append((Component)Component.literal((String)(" [" + craftedItem.getDurability().current() + "/" + craftedItem.getDurability().max() + " Durability]")).withStyle(ChatFormatting.DARK_GRAY)));
        return footer;
    }
}

