/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.handlers.tooltip.impl.identifiable;

import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Services;
import com.wynntils.features.tooltips.ItemStatInfoFeature;
import com.wynntils.handlers.tooltip.TooltipBuilder;
import com.wynntils.handlers.tooltip.impl.identifiable.IdentifiableTooltipComponent;
import com.wynntils.handlers.tooltip.impl.identifiable.TooltipIdentifications;
import com.wynntils.handlers.tooltip.type.TooltipIdentificationDecorator;
import com.wynntils.handlers.tooltip.type.TooltipStyle;
import com.wynntils.models.character.type.ClassType;
import com.wynntils.models.gear.type.GearInfo;
import com.wynntils.models.gear.type.ItemWeightSource;
import com.wynntils.models.items.properties.IdentifiableItemProperty;
import com.wynntils.services.itemweight.ItemWeightService;
import com.wynntils.services.itemweight.type.ItemWeighting;
import com.wynntils.utils.mc.LoreUtils;
import com.wynntils.utils.type.Pair;
import com.wynntils.utils.wynn.ColorScaleUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public final class IdentifiableTooltipBuilder<T, U>
extends TooltipBuilder {
    private final IdentifiableItemProperty<T, U> itemInfo;

    private IdentifiableTooltipBuilder(IdentifiableItemProperty<T, U> itemInfo, List<Component> header, List<Component> footer, String source) {
        super(header, footer, source);
        this.itemInfo = itemInfo;
    }

    private IdentifiableTooltipBuilder(IdentifiableItemProperty<T, U> itemInfo, List<Component> header, List<Component> footer) {
        this(itemInfo, header, footer, "");
    }

    public static <T, U> IdentifiableTooltipBuilder<T, U> buildNewItem(IdentifiableItemProperty<T, U> identifiableItem, IdentifiableTooltipComponent<T, U> tooltipComponent, boolean hideUnidentified, boolean showItemType, String source) {
        T itemInfo = identifiableItem.getItemInfo();
        Object itemInstance = identifiableItem.getItemInstance().orElse(null);
        List<Component> header = tooltipComponent.buildHeaderTooltip(itemInfo, itemInstance, hideUnidentified);
        List<Component> footer = tooltipComponent.buildFooterTooltip(itemInfo, itemInstance, showItemType);
        return new IdentifiableTooltipBuilder<T, U>(identifiableItem, header, footer, source);
    }

    public static IdentifiableTooltipBuilder fromParsedItemStack(ItemStack itemStack, IdentifiableItemProperty itemInfo) {
        List<Component> tooltips = LoreUtils.getTooltipLines(itemStack);
        Pair<List<Component>, List<Component>> splitLore = IdentifiableTooltipBuilder.extractHeaderAndFooter(tooltips);
        List<Component> header = splitLore.a();
        List<Component> footer = splitLore.b();
        return new IdentifiableTooltipBuilder(itemInfo, header, footer);
    }

    @Override
    protected List<Component> getWeightedHeaderLines(List<Component> originalHeader, TooltipStyle style) {
        T t;
        ItemWeightSource weightSource = style.weightSource();
        if (weightSource == ItemWeightSource.NONE || !this.itemInfo.hasOverallValue() || !((t = this.itemInfo.getItemInfo()) instanceof GearInfo)) {
            return originalHeader;
        }
        GearInfo gearInfo = (GearInfo)t;
        List<ItemWeighting> noriWeightings = Services.ItemWeight.getItemWeighting(gearInfo.name(), ItemWeightSource.NORI);
        List<ItemWeighting> wynnpoolWeightings = Services.ItemWeight.getItemWeighting(gearInfo.name(), ItemWeightSource.WYNNPOOL);
        boolean addNori = (weightSource == ItemWeightSource.NORI || weightSource == ItemWeightSource.ALL) && !noriWeightings.isEmpty();
        boolean addWynnpool = (weightSource == ItemWeightSource.WYNNPOOL || weightSource == ItemWeightSource.ALL) && !wynnpoolWeightings.isEmpty();
        ItemStatInfoFeature isif = Managers.Feature.getFeatureInstance(ItemStatInfoFeature.class);
        int currentIndex = 1;
        ArrayList<Component> weightedHeader = new ArrayList<Component>(originalHeader);
        if (addNori) {
            weightedHeader.add(currentIndex, ItemWeightService.NORI_HEADER);
            ++currentIndex;
            currentIndex = this.addWeightingLine(weightedHeader, noriWeightings, currentIndex, isif);
        }
        if (addWynnpool) {
            weightedHeader.add(currentIndex, ItemWeightService.WYNNPOOL_HEADER);
            ++currentIndex;
            currentIndex = this.addWeightingLine(weightedHeader, wynnpoolWeightings, currentIndex, isif);
        }
        if ((addNori || addWynnpool) && gearInfo.type().isWeapon()) {
            weightedHeader.add(currentIndex, (Component)Component.empty());
        }
        return weightedHeader;
    }

    private int addWeightingLine(List<Component> originalHeader, List<ItemWeighting> weightings, int currentIndex, ItemStatInfoFeature isif) {
        for (ItemWeighting weighting : weightings) {
            MutableComponent weightingComponent = Component.literal((String)" - ").append((Component)Component.literal((String)(weighting.weightName() + " Scale"))).withStyle(ChatFormatting.GRAY);
            float percentage = Services.ItemWeight.calculateWeighting(weighting, this.itemInfo);
            weightingComponent.append((Component)ColorScaleUtils.getPercentageTextComponent(isif.getColorMap(), percentage, (Boolean)isif.colorLerp.get(), (Integer)isif.decimalPlaces.get()));
            originalHeader.add(currentIndex, (Component)weightingComponent);
            ++currentIndex;
        }
        return currentIndex;
    }

    @Override
    protected List<Component> getIdentificationLines(ClassType currentClass, TooltipStyle style, TooltipIdentificationDecorator decorator) {
        return TooltipIdentifications.buildTooltip(this.itemInfo, currentClass, decorator, style);
    }
}

