/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.handlers.wrappedscreen;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Handler;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.wrappedscreen.WrappedScreen;
import com.wynntils.handlers.wrappedscreen.WrappedScreenHolder;
import com.wynntils.handlers.wrappedscreen.event.WrappedScreenOpenEvent;
import com.wynntils.handlers.wrappedscreen.type.WrappedScreenInfo;
import com.wynntils.mc.event.MenuEvent;
import com.wynntils.mc.event.ScreenClosedEvent;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.wynn.ContainerUtils;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.neoforged.bus.api.SubscribeEvent;

public final class WrappedScreenHandler
extends Handler {
    private final Set<WrappedScreenHolder> wrappedScreenHolders = new HashSet<WrappedScreenHolder>();
    private WrappedScreenHolder<?> currentWrappedScreenHolder;
    private Screen currentWrappedScreen;

    @SubscribeEvent
    public void onMenuOpened(MenuEvent.MenuOpenedEvent.Post event) {
        Screen screen = McUtils.screen();
        if (!(screen instanceof AbstractContainerScreen)) {
            return;
        }
        AbstractContainerScreen abstractContainerScreen = (AbstractContainerScreen)screen;
        StyledText titleStyledText = StyledText.fromComponent(abstractContainerScreen.getTitle());
        this.resetWrappedScreen(false);
        Optional<WrappedScreenHolder> holderForScreenOpt = this.wrappedScreenHolders.stream().filter(holder -> titleStyledText.matches(holder.getReplacedScreenTitlePattern())).findFirst();
        if (holderForScreenOpt.isEmpty()) {
            return;
        }
        WrappedScreenHolder holder2 = holderForScreenOpt.get();
        WrappedScreenOpenEvent openEvent = new WrappedScreenOpenEvent(holder2.getWrappedScreenClass());
        WynntilsMod.postEvent(openEvent);
        if (!openEvent.shouldOpenScreen()) {
            return;
        }
        this.currentWrappedScreenHolder = holder2;
        WynntilsMod.registerEventListener(holder2);
        this.currentWrappedScreen = holder2.createWrappedScreen(new WrappedScreenInfo(abstractContainerScreen, McUtils.containerMenu(), McUtils.containerMenu().containerId));
        holder2.setWrappedScreen(this.currentWrappedScreen);
        McUtils.setScreen(this.currentWrappedScreen);
    }

    @SubscribeEvent
    public void onScreenClose(ScreenClosedEvent.Post event) {
        this.resetWrappedScreen(true);
    }

    public void registerWrappedScreen(WrappedScreenHolder holder) {
        this.wrappedScreenHolders.add(holder);
    }

    private void resetWrappedScreen(boolean closeContainer) {
        if (this.currentWrappedScreen == null) {
            return;
        }
        if (closeContainer) {
            ContainerUtils.closeContainer(((WrappedScreen)this.currentWrappedScreen).getWrappedScreenInfo().containerId());
        }
        this.currentWrappedScreen = null;
        this.currentWrappedScreenHolder.reset();
        WynntilsMod.unregisterEventListener(this.currentWrappedScreenHolder);
        this.currentWrappedScreenHolder = null;
    }
}

