/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.mc.event;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.ICancellableEvent;

public abstract class ContainerLabelRenderEvent
extends Event
implements ICancellableEvent {
    private final AbstractContainerScreen<?> screen;
    private final GuiGraphics guiGraphics;
    private final float x;
    private final float y;
    private int color;

    protected ContainerLabelRenderEvent(AbstractContainerScreen<?> screen, GuiGraphics guiGraphics, float x, float y, int color) {
        this.screen = screen;
        this.guiGraphics = guiGraphics;
        this.x = x;
        this.y = y;
        this.color = color;
    }

    public AbstractContainerScreen<?> getScreen() {
        return this.screen;
    }

    public GuiGraphics getGuiGraphics() {
        return this.guiGraphics;
    }

    public PoseStack getPoseStack() {
        return this.guiGraphics.pose();
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public static class InventoryLabel
    extends ContainerLabelRenderEvent {
        private Component inventoryLabel;

        public InventoryLabel(AbstractContainerScreen<?> screen, GuiGraphics guiGraphics, int color, float x, float y, Component inventoryLabel) {
            super(screen, guiGraphics, x, y, color);
            this.inventoryLabel = inventoryLabel;
        }

        public Component getInventoryLabel() {
            return this.inventoryLabel;
        }

        public void setInventoryLabel(Component inventoryLabel) {
            this.inventoryLabel = inventoryLabel;
        }
    }

    public static class ContainerLabel
    extends ContainerLabelRenderEvent {
        private Component containerLabel;

        public ContainerLabel(AbstractContainerScreen<?> screen, GuiGraphics guiGraphics, int color, float x, float y, Component containerLabel) {
            super(screen, guiGraphics, x, y, color);
            this.containerLabel = containerLabel;
        }

        public Component getContainerLabel() {
            return this.containerLabel;
        }

        public void setContainerLabel(Component containerLabel) {
            this.containerLabel = containerLabel;
        }
    }
}

