/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.mc.event;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.ICancellableEvent;

public abstract class ItemTooltipRenderEvent
extends Event {
    private final GuiGraphics guiGraphics;
    protected ItemStack itemStack;
    protected int mouseX;
    protected int mouseY;

    protected ItemTooltipRenderEvent(GuiGraphics guiGraphics, ItemStack itemStack, int mouseX, int mouseY) {
        this.guiGraphics = guiGraphics;
        this.itemStack = itemStack;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
    }

    public GuiGraphics getGuiGraphics() {
        return this.guiGraphics;
    }

    public PoseStack getPoseStack() {
        return this.guiGraphics.pose();
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public int getMouseX() {
        return this.mouseX;
    }

    public int getMouseY() {
        return this.mouseY;
    }

    public static class Post
    extends ItemTooltipRenderEvent {
        public Post(GuiGraphics guiGraphics, ItemStack itemStack, int mouseX, int mouseY) {
            super(guiGraphics, itemStack, mouseX, mouseY);
        }
    }

    public static class Pre
    extends ItemTooltipRenderEvent
    implements ICancellableEvent {
        private List<Component> tooltips;

        public Pre(GuiGraphics guiGraphics, ItemStack itemStack, List<Component> tooltips, int mouseX, int mouseY) {
            super(guiGraphics, itemStack, mouseX, mouseY);
            this.setTooltips(tooltips);
        }

        public List<Component> getTooltips() {
            return this.tooltips;
        }

        public void setTooltips(List<Component> tooltips) {
            this.tooltips = Collections.unmodifiableList(tooltips);
        }

        public void setMouseX(int mouseX) {
            this.mouseX = mouseX;
        }

        public void setMouseY(int mouseY) {
            this.mouseY = mouseY;
        }

        public void setItemStack(ItemStack itemStack) {
            this.itemStack = itemStack;
        }
    }
}

