/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.abilities.event;

import com.wynntils.models.abilities.type.ShamanTotem;
import net.minecraft.core.Position;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.neoforged.bus.api.Event;

public abstract class TotemEvent
extends Event {
    private final int totemNumber;

    protected TotemEvent(int totemNumber) {
        this.totemNumber = totemNumber;
    }

    public int getTotemNumber() {
        return this.totemNumber;
    }

    public static class Summoned
    extends TotemEvent {
        private final ArmorStand totemEntity;

        public Summoned(int totemNumber, ArmorStand totemEntity) {
            super(totemNumber);
            this.totemEntity = totemEntity;
        }

        public ArmorStand getTotemEntity() {
            return this.totemEntity;
        }
    }

    public static class Removed
    extends TotemEvent {
        private final ShamanTotem totem;

        public Removed(int totemNumber, ShamanTotem totem) {
            super(totemNumber);
            this.totem = totem;
        }

        public ShamanTotem getTotem() {
            return this.totem;
        }
    }

    public static class Updated
    extends TotemEvent {
        private final int time;
        private final Position position;

        public Updated(int totemNumber, int time, Position position) {
            super(totemNumber);
            this.time = time;
            this.position = position;
        }

        public int getTime() {
            return this.time;
        }

        public Position getPosition() {
            return this.position;
        }
    }

    public static class Activated
    extends TotemEvent {
        private final Position position;

        public Activated(int totemNumber, Position position) {
            super(totemNumber);
            this.position = position;
        }

        public Position getPosition() {
            return this.position;
        }
    }
}

