/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.abilitytree;

import com.google.common.collect.ImmutableMap;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.container.scriptedquery.QueryStep;
import com.wynntils.handlers.container.scriptedquery.ScriptedContainerQuery;
import com.wynntils.handlers.container.type.ContainerContent;
import com.wynntils.models.abilitytree.AbilityTreeModel;
import com.wynntils.models.abilitytree.parser.UnprocessedAbilityTreeInfo;
import com.wynntils.models.abilitytree.type.AbilityTreeInfo;
import com.wynntils.models.abilitytree.type.AbilityTreeNodeState;
import com.wynntils.models.abilitytree.type.AbilityTreeSkillNode;
import com.wynntils.models.abilitytree.type.ParsedAbilityTree;
import com.wynntils.models.containers.ContainerModel;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.type.Pair;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class AbilityTreeContainerQueries {
    private static final int ABILITY_TREE_SLOT = 9;
    private static final int PREVIOUS_PAGE_SLOT = 57;
    private static final int NEXT_PAGE_SLOT = 59;
    private static final StyledText NEXT_PAGE_ITEM_NAME = StyledText.fromString("\u00a77Next Page");
    private static final StyledText PREVIOUS_PAGE_ITEM_NAME = StyledText.fromString("\u00a77Previous Page");
    private int pageCount;

    public void dumpAbilityTree(Consumer<AbilityTreeInfo> supplier) {
        this.queryAbilityTree(new AbilityPageDumper(supplier));
    }

    public void updateParsedAbilityTree() {
        McUtils.player().closeContainer();
        Managers.TickScheduler.scheduleNextTick(() -> this.queryAbilityTree(new AbilityPageSoftProcessor(Models.AbilityTree::setCurrentAbilityTree)));
    }

    private void queryAbilityTree(AbilityTreeProcessor processor) {
        ScriptedContainerQuery query = ScriptedContainerQuery.builder("Ability Tree Query").onError(msg -> {
            WynntilsMod.warn("Problem querying Ability Tree: " + msg);
            McUtils.sendErrorToClient("Dumping Ability Tree failed");
        }).then(QueryStep.useItemInHotbar(7).expectContainerTitle("\udaff\udfdc\ue003")).then(QueryStep.clickOnSlot(9).expectContainerTitle(ContainerModel.ABILITY_TREE_PATTERN.pattern())).execute(() -> {
            this.pageCount = 0;
        }).repeat(c -> ScriptedContainerQuery.containerHasSlot(c, 57, Items.STONE_AXE, PREVIOUS_PAGE_ITEM_NAME), QueryStep.clickOnSlot(57).processIncomingContainer(c -> ++this.pageCount)).reprocess(processor::processPage).repeat(c -> ScriptedContainerQuery.containerHasSlot(c, 59, Items.STONE_AXE, NEXT_PAGE_ITEM_NAME), QueryStep.clickOnSlot(59).processIncomingContainer(processor::processPage)).repeat(c -> {
            ++this.pageCount;
            return this.pageCount != 7;
        }, QueryStep.clickOnSlot(57)).build();
        query.executeQuery();
    }

    private static class AbilityPageDumper
    extends AbilityTreeProcessor {
        private final Consumer<AbilityTreeInfo> supplier;
        private final UnprocessedAbilityTreeInfo unprocessedTree = new UnprocessedAbilityTreeInfo();

        protected AbilityPageDumper(Consumer<AbilityTreeInfo> supplier) {
            this.supplier = supplier;
        }

        @Override
        protected void processPage(ContainerContent content, int page) {
            List<ItemStack> items = content.items();
            for (int slot = 0; slot < items.size(); ++slot) {
                ItemStack itemStack = items.get(slot);
                this.unprocessedTree.processItem(itemStack, page, slot, true);
            }
            if (page == 7) {
                this.supplier.accept(this.unprocessedTree.getProcesssed());
            }
        }
    }

    private static abstract class AbilityTreeProcessor {
        private int page = 1;

        private AbilityTreeProcessor() {
        }

        protected void processPage(ContainerContent content) {
            this.processPage(content, this.page);
            ++this.page;
        }

        protected abstract void processPage(ContainerContent var1, int var2);
    }

    private static class AbilityPageSoftProcessor
    extends AbilityTreeProcessor {
        private final Map<AbilityTreeSkillNode, AbilityTreeNodeState> collectedInfo = new LinkedHashMap<AbilityTreeSkillNode, AbilityTreeNodeState>();
        private final Consumer<ParsedAbilityTree> callback;

        protected AbilityPageSoftProcessor(Consumer<ParsedAbilityTree> callback) {
            this.callback = callback;
        }

        @Override
        protected void processPage(ContainerContent content, int page) {
            boolean lastPage;
            List<ItemStack> items = content.items();
            for (int slot = 0; slot < items.size(); ++slot) {
                ItemStack itemStack = items.get(slot);
                if (!AbilityTreeModel.ABILITY_TREE_PARSER.isNodeItem(itemStack, slot)) continue;
                Pair<AbilityTreeSkillNode, AbilityTreeNodeState> parsedNode = AbilityTreeModel.ABILITY_TREE_PARSER.parseNodeFromItem(itemStack, page, slot, this.collectedInfo.size() + 1);
                this.collectedInfo.put(parsedNode.key(), parsedNode.value());
            }
            boolean bl = lastPage = page == 7;
            if (lastPage) {
                this.callback.accept(new ParsedAbilityTree((ImmutableMap<AbilityTreeSkillNode, AbilityTreeNodeState>)ImmutableMap.copyOf(this.collectedInfo)));
            }
        }
    }
}

