/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.abilitytree.parser;

import com.wynntils.models.abilitytree.AbilityTreeModel;
import com.wynntils.models.abilitytree.type.AbilityTreeConnectionType;
import com.wynntils.models.abilitytree.type.AbilityTreeInfo;
import com.wynntils.models.abilitytree.type.AbilityTreeLocation;
import com.wynntils.models.abilitytree.type.AbilityTreeSkillNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.ItemStack;

public class UnprocessedAbilityTreeInfo {
    private final List<AbilityTreeSkillNode> nodes = new ArrayList<AbilityTreeSkillNode>();
    private final Map<AbilityTreeLocation, AbilityTreeConnectionType> connectionMap = new HashMap<AbilityTreeLocation, AbilityTreeConnectionType>();
    private final Map<AbilityTreeLocation, AbilityTreeSkillNode> nodeMap = new HashMap<AbilityTreeLocation, AbilityTreeSkillNode>();
    private boolean processed = false;

    private void addNodeFromItem(ItemStack itemStack, int page, int slot) {
        AbilityTreeSkillNode node = AbilityTreeModel.ABILITY_TREE_PARSER.parseNodeFromItem(itemStack, page, slot, this.nodes.size() + 1).key();
        this.nodes.add(node);
        this.nodeMap.put(AbilityTreeLocation.fromSlot(slot, page), node);
    }

    private void addConnectionFromItem(ItemStack itemStack, int page, int slot) {
        this.connectionMap.put(AbilityTreeLocation.fromSlot(slot, page), AbilityTreeConnectionType.fromDamage(itemStack.getDamageValue()));
    }

    public void processItem(ItemStack itemStack, int page, int slot, boolean processConnections) {
        if (AbilityTreeModel.ABILITY_TREE_PARSER.isNodeItem(itemStack, slot)) {
            this.addNodeFromItem(itemStack, page, slot);
            return;
        }
        if (processConnections) {
            if (AbilityTreeModel.ABILITY_TREE_PARSER.isConnectionItem(itemStack)) {
                this.addConnectionFromItem(itemStack, page, slot);
            }
        }
    }

    private void processConnections() {
        AbilityTreeSkillNode firstNode = this.nodes.stream().filter(node -> node.id() == 1).findFirst().orElseThrow(() -> new RuntimeException("No root node found!"));
        LinkedList<AbilityTreeLocation> locationQueue = new LinkedList<AbilityTreeLocation>(this.getAdjacentConnections(firstNode.location(), null));
        HashSet<AbilityTreeLocation> visitedLocations = new HashSet<AbilityTreeLocation>();
        HashMap connectionOverrideMap = new HashMap();
        HashSet<AbilityTreeSkillNode> processedNodes = new HashSet<AbilityTreeSkillNode>();
        AbilityTreeSkillNode currentNode = firstNode;
        while (!locationQueue.isEmpty()) {
            AbilityTreeLocation currentLocation = (AbilityTreeLocation)locationQueue.poll();
            if (visitedLocations.contains(currentLocation)) continue;
            visitedLocations.add(currentLocation);
            AbilityTreeSkillNode nodeAtPosition = this.nodeMap.get(currentLocation);
            if (nodeAtPosition != null) {
                if (processedNodes.contains(nodeAtPosition)) continue;
                currentNode = nodeAtPosition;
                processedNodes.add(currentNode);
                visitedLocations.clear();
                connectionOverrideMap.clear();
            }
            AbilityTreeConnectionType connectionType = connectionOverrideMap.getOrDefault(currentLocation, this.connectionMap.getOrDefault(currentLocation, null));
            List<AbilityTreeLocation> adjacentConnections = this.getAdjacentConnections(currentLocation, connectionType);
            if (connectionType == AbilityTreeConnectionType.VERTICAL) {
                adjacentConnections = adjacentConnections.stream().filter(location -> {
                    AbilityTreeConnectionType type = this.connectionMap.getOrDefault(location, null);
                    return type.isCompatible(AbilityTreeConnectionType.VERTICAL);
                }).toList();
                adjacentConnections.forEach(location -> connectionOverrideMap.put(location, AbilityTreeConnectionType.VERTICAL));
            }
            adjacentConnections.stream().filter(location -> !locationQueue.contains(location)).forEach(locationQueue::addFirst);
            if (connectionType == null) continue;
            int currentNodeId = currentNode.id();
            List<AbilityTreeLocation> adjacentNodes = this.getAdjacentNodes(currentLocation, connectionType).stream().map(this.nodeMap::get).filter(node -> node.id() != currentNodeId).filter(node -> !node.connections().contains(currentNodeId)).map(AbilityTreeSkillNode::location).toList();
            adjacentNodes.stream().filter(location -> !locationQueue.contains(location)).forEach(locationQueue::addLast);
            currentNode.connections().addAll(adjacentNodes.stream().map(this.nodeMap::get).map(AbilityTreeSkillNode::id).toList());
        }
    }

    private List<AbilityTreeLocation> getAdjacentConnections(AbilityTreeLocation location, AbilityTreeConnectionType connectionType) {
        ArrayList<AbilityTreeLocation> locations = new ArrayList<AbilityTreeLocation>();
        AbilityTreeLocation[] adjacent = new AbilityTreeLocation[]{location.right(), location.down(), location.left()};
        if (connectionType == null) {
            for (int i = 0; i < adjacent.length; ++i) {
                AbilityTreeConnectionType connection;
                AbilityTreeLocation adjacentLocation = adjacent[i];
                if (!this.connectionMap.containsKey(adjacentLocation) || !(connection = this.connectionMap.get(adjacentLocation)).getPossibleDirections()[(i + 3) % 4]) continue;
                locations.add(adjacentLocation);
            }
            return locations;
        }
        boolean[] possibleDirections = connectionType.getPossibleDirections();
        for (int i = 0; i < adjacent.length; ++i) {
            AbilityTreeLocation adjacentLocation;
            if (!possibleDirections[i + 1] || !this.connectionMap.containsKey(adjacentLocation = adjacent[i])) continue;
            locations.add(adjacentLocation);
        }
        return locations;
    }

    private List<AbilityTreeLocation> getAdjacentNodes(AbilityTreeLocation location, AbilityTreeConnectionType connectionType) {
        ArrayList<AbilityTreeLocation> locations = new ArrayList<AbilityTreeLocation>();
        AbilityTreeLocation[] adjacent = new AbilityTreeLocation[]{location.right(), location.down(), location.left()};
        boolean[] possibleDirections = connectionType.getPossibleDirections();
        for (int i = 0; i < adjacent.length; ++i) {
            AbilityTreeLocation adjacentLocation;
            if (!possibleDirections[i + 1] || !this.nodeMap.containsKey(adjacentLocation = adjacent[i])) continue;
            locations.add(adjacentLocation);
        }
        return locations;
    }

    public AbilityTreeInfo getProcesssed() {
        if (!this.processed) {
            this.processConnections();
            this.processed = true;
        }
        return new AbilityTreeInfo(this.nodes);
    }
}

