/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.activities;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.notifications.MessageContainer;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.container.ContainerQueryException;
import com.wynntils.handlers.container.scriptedquery.QueryStep;
import com.wynntils.handlers.container.scriptedquery.ScriptedContainerQuery;
import com.wynntils.handlers.container.type.ContainerContent;
import com.wynntils.handlers.container.type.ContainerContentVerification;
import com.wynntils.models.activities.type.ActivityInfo;
import com.wynntils.models.activities.type.ActivityType;
import com.wynntils.models.items.items.gui.ActivityItem;
import com.wynntils.utils.mc.LoreUtils;
import com.wynntils.utils.wynn.ContainerUtils;
import com.wynntils.utils.wynn.ItemUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class ContentBookQueries {
    private static final boolean RESET_FILTERS = false;
    private static final boolean REVERSE_DIRECTION = false;
    private static final int CHANGE_VIEW_SLOT = 66;
    private static final int PROGRESS_SLOT = 68;
    private static final int NEXT_PAGE_SLOT = 69;
    private static final StyledText SCROLL_DOWN_TEXT = StyledText.fromString("Scroll Down");
    private static final String FILTER_ITEM_TITLE = "Filter";
    private static final Pattern ACTIVE_FILTER = Pattern.compile("^\u00a7f- \u00a77(.*)$");
    private static final Pattern INACTIVE_FILTER = Pattern.compile("^\u00a77- \u00a78(.*)$");
    private static final int MAX_FILTERS = 12;
    private String selectedFilter;
    private String activeFilter;
    private int filterChangeDirection;
    private int filterLoopCount;
    private MessageContainer stateMessageContainer;

    protected void queryContentBook(ActivityType activityType, BiConsumer<List<ActivityInfo>, List<StyledText>> processResult, boolean showUpdates, boolean firstPageOnly) {
        ArrayList newActivity = new ArrayList();
        ArrayList progress = new ArrayList();
        ScriptedContainerQuery query = ScriptedContainerQuery.builder("Content Book Query for " + activityType.getDisplayName()).onError(msg -> {
            WynntilsMod.warn("Problem querying Content Book: " + msg);
            if (showUpdates && this.stateMessageContainer != null) {
                Managers.Notification.editMessage(this.stateMessageContainer, StyledText.fromComponent((Component)Component.literal((String)("Error loading " + activityType.getGroupName() + " from content book")).withStyle(ChatFormatting.RED)));
            }
        }).execute(() -> {
            if (showUpdates) {
                this.stateMessageContainer = Managers.Notification.queueMessage((Component)Component.literal((String)("Loading " + activityType.getGroupName() + " from content book...")).withStyle(ChatFormatting.YELLOW));
            }
        }).then(QueryStep.useItemInHotbar(8).expectContainerTitle("\udaff\udfee\ue004")).execute(() -> {
            this.filterLoopCount = 0;
            this.selectedFilter = null;
        }).reprocess(c -> {
            this.filterChangeDirection = this.getFilterChangeDirection(c.items().get(66), activityType.getDisplayName());
        }).repeat(c -> {
            ++this.filterLoopCount;
            if (this.filterLoopCount > 12) {
                throw new ContainerQueryException("Filter setting has exceeded max loops");
            }
            this.activeFilter = this.getActiveFilter(c.items().get(66));
            if (this.activeFilter == null) {
                throw new ContainerQueryException("Cannot determine active filter");
            }
            if (this.selectedFilter == null) {
                this.selectedFilter = this.activeFilter;
            }
            return !this.activeFilter.equals(activityType.getDisplayName());
        }, QueryStep.clickOnSlot(66, () -> this.filterChangeDirection).verifyContentChange(this.getContentBookFilterChangeVerification())).reprocess(c -> {
            this.processContentBookPage(c, newActivity);
            ItemStack itemStack = c.items().get(68);
            progress.add(ItemUtils.getItemName(itemStack));
            progress.addAll(LoreUtils.getLore(itemStack));
        }).repeat(c -> {
            if (firstPageOnly) {
                return false;
            }
            return ScriptedContainerQuery.containerHasSlot(c, 69, Items.POTION, SCROLL_DOWN_TEXT);
        }, QueryStep.clickOnSlot(69).processIncomingContainer(c -> this.processContentBookPage(c, newActivity))).execute(() -> {
            this.filterLoopCount = 0;
        }).execute(() -> {}).repeat(c -> false, QueryStep.clickOnSlot(66, () -> this.filterChangeDirection).verifyContentChange(this.getContentBookFilterChangeVerification())).execute(() -> processResult.accept(newActivity, progress)).execute(() -> {
            if (showUpdates) {
                Managers.Notification.editMessage(this.stateMessageContainer, StyledText.fromComponent((Component)Component.literal((String)("Loaded " + activityType.getGroupName() + " from content book")).withStyle(ChatFormatting.GREEN)));
            }
        }).build();
        query.executeQuery();
    }

    private String getActiveFilter(ItemStack itemStack) {
        StyledText itemName = ItemUtils.getItemName(itemStack);
        if (!itemName.equals(StyledText.fromString(FILTER_ITEM_TITLE))) {
            return null;
        }
        LinkedList<StyledText> lore = LoreUtils.getLore(itemStack);
        for (StyledText line : lore) {
            Matcher m = line.getMatcher(ACTIVE_FILTER);
            if (!m.matches()) continue;
            return m.group(1);
        }
        return null;
    }

    private int getFilterChangeDirection(ItemStack itemStack, String targetFilter) {
        StyledText itemName = ItemUtils.getItemName(itemStack);
        return 0;
    }

    private ContainerContentVerification getContentBookFilterChangeVerification() {
        return (container, changes, changeType) -> {
            if (!changes.containsKey(68)) {
                return false;
            }
            String itemFilter = this.getActiveFilter(container.items().get(66));
            return !Objects.equals(itemFilter, this.activeFilter);
        };
    }

    private void processContentBookPage(ContainerContent container, List<ActivityInfo> newActivities) {
        for (int slot = 0; slot < 54; ++slot) {
            ItemStack itemStack = container.items().get(slot);
            Optional<ActivityItem> activityItemOpt = Models.Item.asWynnItem(itemStack, ActivityItem.class);
            if (activityItemOpt.isEmpty()) continue;
            ActivityInfo activityInfo = activityItemOpt.get().getActivityInfo();
            newActivities.add(activityInfo);
        }
    }

    protected void toggleTracking(String name, ActivityType activityType) {
        ScriptedContainerQuery query = ScriptedContainerQuery.builder("Toggle Activity Tracking Query: " + name).onError(msg -> {
            WynntilsMod.warn("Problem querying Content Book for tracking: " + msg);
            Managers.Notification.queueMessage(StyledText.fromComponent((Component)Component.literal((String)"Setting tracking in Content Book failed").withStyle(ChatFormatting.RED)));
        }).then(QueryStep.useItemInHotbar(8).expectContainerTitle("\udaff\udfee\ue004")).execute(() -> {
            this.filterLoopCount = 0;
            this.selectedFilter = null;
        }).reprocess(c -> {
            this.filterChangeDirection = this.getFilterChangeDirection(c.items().get(66), activityType.getDisplayName());
        }).repeat(c -> {
            ++this.filterLoopCount;
            if (this.filterLoopCount > 12) {
                throw new ContainerQueryException("Filter setting has exceeded max loops");
            }
            this.activeFilter = this.getActiveFilter(c.items().get(66));
            if (this.activeFilter == null) {
                throw new ContainerQueryException("Cannot determine active filter");
            }
            if (this.selectedFilter == null) {
                this.selectedFilter = this.activeFilter;
            }
            return !this.activeFilter.equals(activityType.getDisplayName());
        }, QueryStep.clickOnSlot(66, () -> this.filterChangeDirection).verifyContentChange(this.getContentBookFilterChangeVerification())).repeat(c -> {
            int slot = this.findTrackedActivity(c, name, activityType);
            if (slot == -1) {
                return true;
            }
            ContainerUtils.clickOnSlot(slot, c.containerId(), 0, c.items());
            return false;
        }, QueryStep.clickOnMatchingSlot(69, Items.GOLDEN_SHOVEL, SCROLL_DOWN_TEXT)).execute(() -> {
            this.filterLoopCount = 0;
        }).execute(() -> {
            this.filterChangeDirection = this.filterChangeDirection == 1 ? 0 : 1;
        }).repeat(c -> false, QueryStep.clickOnSlot(66, () -> this.filterChangeDirection).verifyContentChange(this.getContentBookFilterChangeVerification())).build();
        query.executeQuery();
    }

    private int findTrackedActivity(ContainerContent container, String name, ActivityType activityType) {
        for (int slot = 0; slot < 54; ++slot) {
            ActivityInfo activityInfo;
            ItemStack itemStack = container.items().get(slot);
            Optional<ActivityItem> activityItemOpt = Models.Item.asWynnItem(itemStack, ActivityItem.class);
            if (activityItemOpt.isEmpty() || !(activityInfo = activityItemOpt.get().getActivityInfo()).type().matchesTracking(activityType) || !activityInfo.name().equals(name)) continue;
            return slot;
        }
        return -1;
    }
}

