/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.characterstats.actionbar.matchers;

import com.wynntils.core.WynntilsMod;
import com.wynntils.handlers.actionbar.ActionBarSegment;
import com.wynntils.handlers.actionbar.ActionBarSegmentMatcher;
import com.wynntils.models.characterstats.actionbar.segments.LevelSegment;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LevelSegmentMatcher
implements ActionBarSegmentMatcher {
    private static final char SPACER_HIGH_SURROGATE = '\udaff';
    private static final String SEPARATOR = "\udaff\udffe";
    private static final char LEVEL_CHAR_START = '\ue000';
    private static final char LEVEL_CHAR_END = '\ue009';
    private static final Pattern LEVEL_PATTERN = Pattern.compile(".(?<level>([\ue000-\ue009]\udaff\udffe?){1,6}).");

    @Override
    public ActionBarSegment parse(String actionBar) {
        boolean validEnd;
        Matcher matcher = LEVEL_PATTERN.matcher(actionBar);
        if (!matcher.find()) {
            return null;
        }
        String segmentText = matcher.group();
        char startChar = segmentText.charAt(0);
        char endChar = segmentText.charAt(segmentText.length() - 2);
        boolean validStart = startChar == '\udaff';
        boolean bl = validEnd = endChar == '\udaff';
        if (!validStart || !validEnd) {
            return null;
        }
        int level = this.parseLevel(matcher.group("level"));
        return new LevelSegment(matcher.group(), level);
    }

    private int parseLevel(String levelText) {
        try {
            levelText = levelText.replace(SEPARATOR, "");
            StringBuilder levelBuilder = new StringBuilder();
            for (char current : levelText.toCharArray()) {
                if (current >= '\ue000' && current <= '\ue009') {
                    levelBuilder.append(current - 57344);
                    continue;
                }
                WynntilsMod.warn("Found unexpected character in level segment: " + current);
            }
            return Integer.parseInt(levelBuilder.toString());
        }
        catch (NumberFormatException e) {
            WynntilsMod.warn("Failed to parse level from segment: " + levelText);
            return 0;
        }
    }
}

