/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.combat.type;

import com.wynntils.models.elements.type.Element;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public record MobElementals(List<Element> weaknesses, List<Element> damages, List<Element> defenses) {
    public static final MobElementals EMPTY = new MobElementals(List.of(), List.of(), List.of());

    public Component getFormatted() {
        MutableComponent text = Component.empty();
        this.appendElementGroup(text, this.weaknesses, "Weak", !this.damages.isEmpty() || !this.defenses.isEmpty());
        this.appendElementGroup(text, this.damages, "Dam", !this.defenses.isEmpty());
        this.appendElementGroup(text, this.defenses, "Def", false);
        return text;
    }

    private void appendElementGroup(MutableComponent text, List<Element> elements, String label, boolean addSpace) {
        if (elements.isEmpty()) {
            return;
        }
        for (Element element : elements) {
            text.append((Component)Component.literal((String)element.getSymbol()).withStyle(Style.EMPTY.withFont(ResourceLocation.withDefaultNamespace((String)"common")).withColor(element.getColorCode())));
        }
        ChatFormatting lastColor = elements.getLast().getColorCode();
        text.append((Component)Component.literal((String)(label + (addSpace ? " " : ""))).withStyle(Style.EMPTY.withColor(lastColor)));
    }
}

