/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.emeralds.type;

import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public enum EmeraldUnits {
    EMERALD(Items.EMERALD, "\u00b2", 1),
    EMERALD_BLOCK(Items.EMERALD_BLOCK, "\u00b2\u00bd", 64),
    LIQUID_EMERALD(Items.EXPERIENCE_BOTTLE, "\u00bc\u00b2", 4096),
    LIQUID_EMERALD_STX(Items.EXPERIENCE_BOTTLE, "stx", 262144);

    private final Item itemType;
    private final ItemStack itemStack;
    private final String symbol;
    private final int multiplier;

    private EmeraldUnits(Item itemType, String symbol, int multiplier) {
        this.itemType = itemType;
        this.itemStack = new ItemStack((ItemLike)itemType);
        this.symbol = symbol;
        this.multiplier = multiplier;
    }

    public Item getItemType() {
        return this.itemType;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public static EmeraldUnits fromItemType(Item itemType) {
        for (EmeraldUnits unit : EmeraldUnits.values()) {
            if (unit.getItemType() != itemType) continue;
            return unit;
        }
        return null;
    }
}

