/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.guild.label;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.labels.type.LabelInfo;
import com.wynntils.handlers.labels.type.LabelParser;
import com.wynntils.models.guild.label.GuildSeasonLeaderboardLabelInfo;
import com.wynntils.models.guild.type.GuildLeaderboardInfo;
import com.wynntils.utils.mc.type.Location;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.world.entity.Entity;

public class GuildSeasonLeaderboardLabelParser
implements LabelParser {
    private static final Pattern GUILD_SEASON_LEADERBOARD_LABEL = Pattern.compile("\u00a7d\u00a7lSeason (?<season>\\d+) Leaderboard\n\u00a77Season (?:ends in \u00a7b\u00a7l(?<remaining>\\d+) (?<timeunit>(month|week|day|hour|minute|second)s?)|ended at \u00a7b\u00a7l(?<month>\\d{2})/(?<day>\\d{2})/(?<year>\\d{4}))\n\n(?<guilds>.*?)\n\u00a7(?<firstpage>7|a)\u00a7l\u00ab\u00a7e \u2b1f \u00a7(?<lastpage>7|a)\u00a7l\u00bb\n\u00a7eClick for Options", 32);
    private static final Pattern GUILD_LEADERBOARD_POSITION = Pattern.compile("^\u00a7.(?:\u00a7l)?(?<place>\\d+)(?:\u00a77)? - \u00a7b(?<guild>.+)\u00a7d \\((\\d{1,3}(?:,\\d{3})*) SR\\)$");
    private static final String PAGE_END_CHARACTER = "7";

    public LabelInfo getInfo(StyledText label, Location location, Entity entity) {
        Matcher matcher = label.getMatcher(GUILD_SEASON_LEADERBOARD_LABEL);
        if (matcher.matches()) {
            int season = Integer.parseInt(matcher.group("season"));
            String[] guildPositions = matcher.group("guilds").split("\n");
            boolean currentSeason = matcher.group("remaining") != null;
            ArrayList<Integer> endingDate = new ArrayList<Integer>();
            String timeUnit = "";
            if (currentSeason) {
                endingDate.add(Integer.parseInt(matcher.group("remaining")));
                timeUnit = matcher.group("timeunit");
            } else {
                endingDate.add(Integer.parseInt(matcher.group("month")));
                endingDate.add(Integer.parseInt(matcher.group("day")));
                endingDate.add(Integer.parseInt(matcher.group("year")));
            }
            ArrayList<GuildLeaderboardInfo> guildLeaderboardInfo = new ArrayList<GuildLeaderboardInfo>();
            for (String guildStanding : guildPositions) {
                Matcher guildMatcher = GUILD_LEADERBOARD_POSITION.matcher(guildStanding);
                if (guildMatcher.matches()) {
                    int position = Integer.parseInt(guildMatcher.group(1));
                    String name = guildMatcher.group(2);
                    long rating = Long.parseLong(guildMatcher.group(3).replaceAll(",", ""));
                    guildLeaderboardInfo.add(new GuildLeaderboardInfo(position, name, rating));
                    continue;
                }
                WynntilsMod.warn("Guild standing did not match: " + guildStanding);
            }
            boolean firstPage = matcher.group("firstpage").equals(PAGE_END_CHARACTER);
            boolean lastPage = matcher.group("lastpage").equals(PAGE_END_CHARACTER);
            return new GuildSeasonLeaderboardLabelInfo(label, location, entity, season, currentSeason, timeUnit, endingDate, guildLeaderboardInfo, firstPage, lastPage);
        }
        return null;
    }
}

