/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.guild.type;

public enum GuildRank {
    RECRUIT("Recruit", ""),
    RECRUITER("Recruiter", "\u2605"),
    CAPTAIN("Captain", "\u2605\u2605"),
    STRATEGIST("Strategist", "\u2605\u2605\u2605"),
    CHIEF("Chief", "\u2605\u2605\u2605\u2605"),
    OWNER("Owner", "\u2605\u2605\u2605\u2605\u2605");

    private final String name;
    private final String stars;

    private GuildRank(String name, String stars) {
        this.name = name;
        this.stars = stars;
    }

    public String getName() {
        return this.name;
    }

    public String getGuildDescription() {
        if (this == RECRUIT) {
            return this.name;
        }
        return this.name + " (" + this.stars + ")";
    }

    public static GuildRank fromName(String string) {
        for (GuildRank rank : GuildRank.values()) {
            if (!rank.getName().equalsIgnoreCase(string)) continue;
            return rank;
        }
        return null;
    }
}

