/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.annotators.gui;

import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.item.GuiItemAnnotator;
import com.wynntils.handlers.item.ItemAnnotation;
import com.wynntils.models.items.items.gui.SkillCrystalItem;
import com.wynntils.utils.mc.LoreUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.world.item.ItemStack;

public final class SkillCrystalAnnotator
implements GuiItemAnnotator {
    private static final StyledText SKILL_CRYSTAL_NAME = StyledText.fromString("\u00a72\u00a7lSkill Crystal");
    private static final Pattern SKILL_POINTS_PATTERN = Pattern.compile("^\u00a77You have \u00a7a(\\d+)\u00a77 skill points$");

    @Override
    public ItemAnnotation getAnnotation(ItemStack itemStack, StyledText name) {
        if (!name.equals(SKILL_CRYSTAL_NAME)) {
            return null;
        }
        Matcher matcher = LoreUtils.matchLoreLine(itemStack, 1, SKILL_POINTS_PATTERN);
        if (!matcher.matches()) {
            return null;
        }
        int count = Integer.parseInt(matcher.group(1));
        return new SkillCrystalItem(count);
    }
}

