/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.encoding;

import com.wynntils.core.WynntilsMod;
import com.wynntils.models.gear.type.GearInstance;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.encoding.DataTransformerRegistry;
import com.wynntils.models.items.encoding.data.EndData;
import com.wynntils.models.items.encoding.data.NameData;
import com.wynntils.models.items.encoding.data.StartData;
import com.wynntils.models.items.encoding.data.TypeData;
import com.wynntils.models.items.encoding.impl.item.CharmItemTransformer;
import com.wynntils.models.items.encoding.impl.item.CraftedConsumableItemTransformer;
import com.wynntils.models.items.encoding.impl.item.CraftedGearItemTransformer;
import com.wynntils.models.items.encoding.impl.item.GearItemTransformer;
import com.wynntils.models.items.encoding.impl.item.TomeItemTransformer;
import com.wynntils.models.items.encoding.type.EncodingSettings;
import com.wynntils.models.items.encoding.type.ItemData;
import com.wynntils.models.items.encoding.type.ItemDataMap;
import com.wynntils.models.items.encoding.type.ItemTransformer;
import com.wynntils.models.items.encoding.type.ItemTransformingVersion;
import com.wynntils.models.items.encoding.type.ItemType;
import com.wynntils.models.items.items.game.CharmItem;
import com.wynntils.models.items.items.game.CraftedConsumableItem;
import com.wynntils.models.items.items.game.CraftedGearItem;
import com.wynntils.models.items.items.game.GearItem;
import com.wynntils.models.items.items.game.TomeItem;
import com.wynntils.utils.EncodedByteBuffer;
import com.wynntils.utils.type.ErrorOr;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class ItemTransformerRegistry {
    private final DataTransformerRegistry dataTransformerRegistry = new DataTransformerRegistry();
    private final ItemTransformerMap itemTransformers = new ItemTransformerMap();

    public ItemTransformerRegistry() {
        this.registerAllTransformers();
    }

    public ErrorOr<EncodedByteBuffer> encodeItem(WynnItem wynnItem, EncodingSettings encodingSettings) {
        ItemTransformer<WynnItem> transformer = this.getTransformer(wynnItem);
        if (transformer == null) {
            return ErrorOr.error("No item transformer found for " + wynnItem.getClass().getSimpleName());
        }
        try {
            return this.encodeItem(wynnItem, encodingSettings, transformer);
        }
        catch (Exception e) {
            WynntilsMod.error("Failed to encode item!", e);
            return ErrorOr.error("Failed to encode item!");
        }
    }

    public ErrorOr<WynnItem> decodeItem(EncodedByteBuffer encodedByteBuffer, String itemName) {
        ErrorOr<List<ItemData>> errorOrItemData = this.dataTransformerRegistry.decodeData(encodedByteBuffer);
        if (errorOrItemData.hasError()) {
            return ErrorOr.error(errorOrItemData.getError());
        }
        List<ItemData> itemData = errorOrItemData.getValue();
        Optional<TypeData> typeDataOpt = itemData.stream().filter(data -> data instanceof TypeData).map(data -> (TypeData)data).findFirst();
        if (typeDataOpt.isEmpty()) {
            return ErrorOr.error("No type data found in item data!");
        }
        TypeData typeData = typeDataOpt.get();
        ItemTransformer<WynnItem> transformer = this.itemTransformers.get(typeData.itemType());
        if (typeData.itemType() == ItemType.CRAFTED_GEAR || typeData.itemType() == ItemType.CRAFTED_CONSUMABLE) {
            itemData.removeIf(data -> data instanceof NameData);
            if (itemName != null) {
                itemData.add(NameData.sanitized(itemName));
            }
        }
        try {
            return this.decodeItem(itemData, transformer);
        }
        catch (Exception e) {
            WynntilsMod.error("Failed to decode item!", e);
            return ErrorOr.error("Failed to decode item!");
        }
    }

    public boolean canEncodeItem(WynnItem wynnItem) {
        return this.itemTransformers.get(wynnItem.getClass()) != null;
    }

    private ErrorOr<EncodedByteBuffer> encodeItem(WynnItem wynnItem, EncodingSettings encodingSettings, ItemTransformer<WynnItem> transformer) {
        ArrayList<ItemData> encodedData = new ArrayList<ItemData>();
        ItemTransformingVersion versionToEncodeWith = ItemTransformerRegistry.getEncodingVersionAccordingToItem(wynnItem);
        encodedData.add(new StartData(versionToEncodeWith));
        encodedData.addAll(transformer.encode(wynnItem, encodingSettings));
        encodedData.add(new EndData());
        return this.dataTransformerRegistry.encodeData(versionToEncodeWith, encodedData);
    }

    private static ItemTransformingVersion getEncodingVersionAccordingToItem(WynnItem wynnItem) {
        GearItem gearItem;
        boolean shinyStatPresentWithRerolls;
        ItemTransformingVersion versionToEncodeWith = ItemTransformingVersion.VERSION_1;
        if (wynnItem instanceof GearItem && (shinyStatPresentWithRerolls = (gearItem = (GearItem)wynnItem).getItemInstance().map(GearInstance::shinyStat).flatMap(shinyStat -> shinyStat.map(stat -> stat.shinyRerolls() != 0)).orElse(false).booleanValue())) {
            versionToEncodeWith = ItemTransformingVersion.VERSION_2;
        }
        return versionToEncodeWith;
    }

    private ErrorOr<WynnItem> decodeItem(List<ItemData> itemData, ItemTransformer<WynnItem> transformer) {
        return transformer.decodeItem(new ItemDataMap(itemData));
    }

    private ItemTransformer<WynnItem> getTransformer(WynnItem wynnItem) {
        return this.itemTransformers.get(wynnItem.getClass());
    }

    private <T extends WynnItem> void registerItemTransformer(Class<T> itemClass, ItemTransformer<T> itemTransformer) {
        this.itemTransformers.put(itemClass, itemTransformer);
    }

    private void registerAllTransformers() {
        this.registerItemTransformer(GearItem.class, new GearItemTransformer());
        this.registerItemTransformer(TomeItem.class, new TomeItemTransformer());
        this.registerItemTransformer(CharmItem.class, new CharmItemTransformer());
        this.registerItemTransformer(CraftedGearItem.class, new CraftedGearItemTransformer());
        this.registerItemTransformer(CraftedConsumableItem.class, new CraftedConsumableItemTransformer());
    }

    private static final class ItemTransformerMap {
        private final Map<Class<? extends WynnItem>, ItemTransformer<? extends WynnItem>> itemTransformers = new HashMap<Class<? extends WynnItem>, ItemTransformer<? extends WynnItem>>();
        private final Map<ItemType, ItemTransformer<? extends WynnItem>> typeTransformers = new HashMap<ItemType, ItemTransformer<? extends WynnItem>>();

        private ItemTransformerMap() {
        }

        public void put(Class<? extends WynnItem> itemClass, ItemTransformer<? extends WynnItem> itemTransformer) {
            if (this.itemTransformers.put(itemClass, itemTransformer) != null) {
                throw new IllegalArgumentException("Item transformer already registered for " + itemClass.getSimpleName());
            }
            if (this.typeTransformers.put(itemTransformer.getType(), itemTransformer) != null) {
                throw new IllegalArgumentException("Item transformer already registered for " + String.valueOf((Object)itemTransformer.getType()));
            }
        }

        public <T extends WynnItem> ItemTransformer<T> get(Class<T> itemClass) {
            return this.itemTransformers.get(itemClass);
        }

        public <T extends WynnItem> ItemTransformer<T> get(ItemType type) {
            return this.typeTransformers.get((Object)type);
        }
    }
}

