/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.encoding.impl.block;

import com.wynntils.models.gear.type.ConsumableType;
import com.wynntils.models.items.encoding.data.CustomConsumableTypeData;
import com.wynntils.models.items.encoding.type.DataTransformer;
import com.wynntils.models.items.encoding.type.DataTransformerType;
import com.wynntils.models.items.encoding.type.ItemTransformingVersion;
import com.wynntils.utils.type.ArrayReader;
import com.wynntils.utils.type.ErrorOr;
import com.wynntils.utils.type.UnsignedByte;

public class CustomConsumableTypeDataTransformer
extends DataTransformer<CustomConsumableTypeData> {
    @Override
    protected ErrorOr<UnsignedByte[]> encodeData(ItemTransformingVersion version, CustomConsumableTypeData data) {
        switch (version) {
            default: {
                throw new MatchException(null, null);
            }
            case VERSION_1: 
            case VERSION_2: 
        }
        return this.encodeCustomConsumableTypeData(data);
    }

    @Override
    public ErrorOr<CustomConsumableTypeData> decodeData(ItemTransformingVersion version, ArrayReader<UnsignedByte> byteReader) {
        switch (version) {
            default: {
                throw new MatchException(null, null);
            }
            case VERSION_1: 
            case VERSION_2: 
        }
        return this.decodeCustomConsumableTypeData(byteReader);
    }

    @Override
    public byte getId() {
        return DataTransformerType.CUSTOM_CONSUMABLE_TYPE_DATA_TRANSFORMER.getId();
    }

    private ErrorOr<UnsignedByte[]> encodeCustomConsumableTypeData(CustomConsumableTypeData data) {
        return ErrorOr.of(new UnsignedByte[]{UnsignedByte.of((byte)data.consumableType().getEncodingId())});
    }

    private ErrorOr<CustomConsumableTypeData> decodeCustomConsumableTypeData(ArrayReader<UnsignedByte> byteReader) {
        short typeId = byteReader.read().value();
        ConsumableType type = ConsumableType.fromEncodingId(typeId);
        if (type == null) {
            return ErrorOr.error("Unknown consumable type id: " + typeId);
        }
        return ErrorOr.of(new CustomConsumableTypeData(type));
    }
}

