/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.encoding.impl.block;

import com.wynntils.core.components.Models;
import com.wynntils.models.items.encoding.data.ShinyData;
import com.wynntils.models.items.encoding.type.DataTransformer;
import com.wynntils.models.items.encoding.type.DataTransformerType;
import com.wynntils.models.items.encoding.type.ItemTransformingVersion;
import com.wynntils.models.stats.type.ShinyStat;
import com.wynntils.utils.UnsignedByteUtils;
import com.wynntils.utils.type.ArrayReader;
import com.wynntils.utils.type.ErrorOr;
import com.wynntils.utils.type.UnsignedByte;

public class ShinyDataTransformer
extends DataTransformer<ShinyData> {
    @Override
    public ErrorOr<UnsignedByte[]> encodeData(ItemTransformingVersion version, ShinyData data) {
        return switch (version) {
            default -> throw new MatchException(null, null);
            case ItemTransformingVersion.VERSION_1 -> ErrorOr.of(ShinyDataTransformer.encodeShinyData(data));
            case ItemTransformingVersion.VERSION_2 -> ErrorOr.of(ShinyDataTransformer.encodeShinyDataV2(data));
        };
    }

    @Override
    protected boolean shouldEncodeData(ItemTransformingVersion version, ShinyData data) {
        return data.shinyStat() != null && data.shinyStat().statType() != null;
    }

    @Override
    public ErrorOr<ShinyData> decodeData(ItemTransformingVersion version, ArrayReader<UnsignedByte> byteReader) {
        return switch (version) {
            default -> throw new MatchException(null, null);
            case ItemTransformingVersion.VERSION_1 -> this.decodeShinyData(byteReader);
            case ItemTransformingVersion.VERSION_2 -> ShinyDataTransformer.decodeShinyDataV2(byteReader);
        };
    }

    @Override
    public byte getId() {
        return DataTransformerType.SHINY_DATA_TRANSFORMER.getId();
    }

    private static UnsignedByte[] encodeShinyDataV2(ShinyData data) {
        UnsignedByte[] shinyStatValueBytes = UnsignedByteUtils.encodeVariableSizedInteger(data.shinyStat().value());
        UnsignedByte[] bytes = new UnsignedByte[shinyStatValueBytes.length + 2];
        bytes[0] = UnsignedByte.of((byte)data.shinyStat().statType().id());
        bytes[1] = UnsignedByte.of((byte)data.shinyStat().shinyRerolls());
        System.arraycopy(shinyStatValueBytes, 0, bytes, 2, shinyStatValueBytes.length);
        return bytes;
    }

    private static ErrorOr<ShinyData> decodeShinyDataV2(ArrayReader<UnsignedByte> byteReader) {
        UnsignedByte statTypeId = byteReader.read();
        UnsignedByte shinyRerolls = byteReader.read();
        long statValue = UnsignedByteUtils.decodeVariableSizedInteger(byteReader);
        return ErrorOr.of(new ShinyData(new ShinyStat(Models.Shiny.getShinyStatType(statTypeId.value()), statValue, shinyRerolls.value())));
    }

    private static UnsignedByte[] encodeShinyData(ShinyData data) {
        UnsignedByte[] shinyStatValueBytes = UnsignedByteUtils.encodeVariableSizedInteger(data.shinyStat().value());
        UnsignedByte[] bytes = new UnsignedByte[shinyStatValueBytes.length + 1];
        bytes[0] = UnsignedByte.of((byte)data.shinyStat().statType().id());
        System.arraycopy(shinyStatValueBytes, 0, bytes, 1, shinyStatValueBytes.length);
        return bytes;
    }

    private ErrorOr<ShinyData> decodeShinyData(ArrayReader<UnsignedByte> byteReader) {
        UnsignedByte statTypeId = byteReader.read();
        long statValue = UnsignedByteUtils.decodeVariableSizedInteger(byteReader);
        return ErrorOr.of(new ShinyData(new ShinyStat(Models.Shiny.getShinyStatType(statTypeId.value()), statValue, 0)));
    }
}

