/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.items.game;

import com.wynntils.models.character.type.ClassType;
import com.wynntils.models.elements.type.Element;
import com.wynntils.models.elements.type.Powder;
import com.wynntils.models.gear.type.GearAttackSpeed;
import com.wynntils.models.gear.type.GearRequirements;
import com.wynntils.models.gear.type.GearTier;
import com.wynntils.models.gear.type.GearType;
import com.wynntils.models.items.items.game.GameItem;
import com.wynntils.models.items.properties.ClassableItemProperty;
import com.wynntils.models.items.properties.CraftedItemProperty;
import com.wynntils.models.items.properties.DurableItemProperty;
import com.wynntils.models.items.properties.GearTierItemProperty;
import com.wynntils.models.items.properties.GearTypeItemProperty;
import com.wynntils.models.items.properties.LeveledItemProperty;
import com.wynntils.models.items.properties.PowderedItemProperty;
import com.wynntils.models.items.properties.RequirementItemProperty;
import com.wynntils.models.stats.type.DamageType;
import com.wynntils.models.stats.type.StatActualValue;
import com.wynntils.models.stats.type.StatPossibleValues;
import com.wynntils.models.stats.type.StatType;
import com.wynntils.utils.type.CappedValue;
import com.wynntils.utils.type.Pair;
import com.wynntils.utils.type.RangedValue;
import java.util.List;
import java.util.Optional;

public class CraftedGearItem
extends GameItem
implements GearTierItemProperty,
GearTypeItemProperty,
DurableItemProperty,
LeveledItemProperty,
PowderedItemProperty,
CraftedItemProperty,
ClassableItemProperty,
RequirementItemProperty {
    private final String name;
    private final int effectStrength;
    private final GearType gearType;
    private final GearAttackSpeed attackSpeed;
    private final int health;
    private final List<Pair<DamageType, RangedValue>> damages;
    private final List<Pair<Element, Integer>> defences;
    private final GearRequirements requirements;
    private final List<StatPossibleValues> possibleValues;
    private final List<StatActualValue> identifications;
    private final List<Powder> powders;
    private final int powderSlots;
    private final boolean requirementsMet;
    private final CappedValue durability;

    public CraftedGearItem(String name, int effectStrength, GearType gearType, GearAttackSpeed attackSpeed, int health, List<Pair<DamageType, RangedValue>> damages, List<Pair<Element, Integer>> defences, GearRequirements requirements, List<StatPossibleValues> possibleValues, List<StatActualValue> identifications, List<Powder> powders, int powderSlots, boolean requirementsMet, CappedValue durability) {
        this.name = name;
        this.effectStrength = effectStrength;
        this.gearType = gearType;
        this.attackSpeed = attackSpeed;
        this.health = health;
        this.damages = damages;
        this.defences = defences;
        this.requirements = requirements;
        this.possibleValues = possibleValues;
        this.identifications = identifications;
        this.powders = powders;
        this.powderSlots = powderSlots;
        this.requirementsMet = requirementsMet;
        this.durability = durability;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getEffectStrength() {
        return this.effectStrength;
    }

    @Override
    public GearType getGearType() {
        return this.gearType;
    }

    public Optional<GearAttackSpeed> getAttackSpeed() {
        return Optional.ofNullable(this.attackSpeed);
    }

    public int getHealth() {
        return this.health;
    }

    @Override
    public int getLevel() {
        return this.requirements.level();
    }

    public List<Pair<DamageType, RangedValue>> getDamages() {
        return this.damages;
    }

    public List<Pair<Element, Integer>> getDefences() {
        return this.defences;
    }

    public GearRequirements getRequirements() {
        return this.requirements;
    }

    @Override
    public List<StatType> getStatTypes() {
        return this.identifications.stream().map(StatActualValue::statType).toList();
    }

    @Override
    public List<StatActualValue> getIdentifications() {
        return this.identifications;
    }

    @Override
    public List<StatPossibleValues> getPossibleValues() {
        return this.possibleValues;
    }

    @Override
    public ClassType getRequiredClass() {
        return this.requirements.classType().orElse(null);
    }

    @Override
    public List<Powder> getPowders() {
        return this.powders;
    }

    @Override
    public int getPowderSlots() {
        return this.powderSlots;
    }

    @Override
    public CappedValue getDurability() {
        return this.durability;
    }

    @Override
    public GearTier getGearTier() {
        return GearTier.CRAFTED;
    }

    @Override
    public boolean meetsActualRequirements() {
        return this.requirementsMet;
    }

    @Override
    public String toString() {
        return "CraftedGearItem{name='" + this.name + "', effectStrength=" + this.effectStrength + ", gearType=" + String.valueOf((Object)this.gearType) + ", attackSpeed=" + String.valueOf((Object)this.attackSpeed) + ", health=" + this.health + ", damages=" + String.valueOf(this.damages) + ", defences=" + String.valueOf(this.defences) + ", requirements=" + String.valueOf(this.requirements) + ", possibleValues=" + String.valueOf(this.possibleValues) + ", identifications=" + String.valueOf(this.identifications) + ", powders=" + String.valueOf(this.powders) + ", powderSlots=" + this.powderSlots + ", durability=" + String.valueOf(this.durability) + "}";
    }
}

