/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.lootrun.beacons;

import com.wynntils.core.components.Services;
import com.wynntils.core.persisted.config.NullableConfig;
import com.wynntils.models.beacons.type.BeaconKind;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;

public enum LootrunBeaconKind implements BeaconKind,
NullableConfig
{
    GREEN(CustomColor.fromInt(65408), CommonColors.GREEN),
    YELLOW(CustomColor.fromInt(0xFFFF33), CommonColors.YELLOW),
    BLUE(CustomColor.fromInt(6053094), CommonColors.BLUE),
    PURPLE(CustomColor.fromInt(0xFF00FF), CommonColors.PURPLE),
    GRAY(CustomColor.fromInt(0xBFBFBF), CommonColors.LIGHT_GRAY),
    ORANGE(CustomColor.fromInt(16749824), CommonColors.ORANGE),
    RED(CustomColor.fromInt(0xFF0000), CommonColors.RED),
    DARK_GRAY(CustomColor.fromInt(0x808080), CommonColors.GRAY),
    WHITE(CommonColors.WHITE, CommonColors.WHITE),
    AQUA(CustomColor.fromInt(0x55FFFF), CommonColors.AQUA),
    CRIMSON(CustomColor.fromInt(61456), CommonColors.GRADIENT_2),
    RAINBOW(CustomColor.fromInt(61440), CommonColors.RAINBOW);

    private final CustomColor customColor;
    private final CustomColor displayColor;

    private LootrunBeaconKind(CustomColor customColor, CustomColor displayColor) {
        this.customColor = customColor;
        this.displayColor = displayColor;
    }

    @Override
    public CustomColor getCustomColor() {
        return this.customColor;
    }

    @Override
    public float getCustomModelData() {
        return Services.CustomModel.getFloat("beacon_color").orElse(Float.valueOf(-1.0f)).floatValue();
    }

    public static LootrunBeaconKind fromName(String name) {
        for (LootrunBeaconKind color : LootrunBeaconKind.values()) {
            if (!color.name().equalsIgnoreCase(name)) continue;
            return color;
        }
        return null;
    }

    public static LootrunBeaconKind fromColor(CustomColor color) {
        for (LootrunBeaconKind beaconKind : LootrunBeaconKind.values()) {
            if (!beaconKind.getCustomColor().equals(color)) continue;
            return beaconKind;
        }
        return null;
    }

    public CustomColor getDisplayColor() {
        return this.displayColor;
    }
}

