/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.lootrun.type;

import com.wynntils.models.beacons.type.Beacon;
import com.wynntils.models.lootrun.beacons.LootrunBeaconKind;
import com.wynntils.models.lootrun.type.MissionType;
import com.wynntils.models.lootrun.type.TrialType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class LootrunDetails {
    private Map<LootrunBeaconKind, Integer> selectedBeacons = new TreeMap<LootrunBeaconKind, Integer>();
    private LootrunBeaconKind lastTaskBeaconColor = null;
    private boolean lastTaskVibrantBeacon = false;
    private Beacon<LootrunBeaconKind> closestBeacon = null;
    private int redBeaconTaskCount = 0;
    private List<Integer> orangeBeaconCounts = new ArrayList<Integer>();
    private int orangeAmount = -1;
    private int rainbowBeaconCount = 0;
    private int rainbowAmount = -1;
    private List<MissionType> missions = new ArrayList<MissionType>();
    private List<TrialType> trials = new ArrayList<TrialType>();
    private int sacrifices = 0;
    private int rerolls = 0;

    public Map<LootrunBeaconKind, Integer> getSelectedBeacons() {
        return Collections.unmodifiableMap(this.selectedBeacons);
    }

    public void setSelectedBeacons(Map<LootrunBeaconKind, Integer> selectedBeacons) {
        this.selectedBeacons = new TreeMap<LootrunBeaconKind, Integer>(selectedBeacons);
    }

    public void incrementBeaconCount(LootrunBeaconKind color) {
        this.selectedBeacons.put(color, this.selectedBeacons.getOrDefault(this.closestBeacon.beaconKind(), 0) + 1);
    }

    public LootrunBeaconKind getLastTaskBeaconColor() {
        return this.lastTaskBeaconColor;
    }

    public void setLastTaskBeaconColor(LootrunBeaconKind lastTaskBeaconColor) {
        this.lastTaskBeaconColor = lastTaskBeaconColor;
    }

    public boolean getLastTaskVibrantBeacon() {
        return this.lastTaskVibrantBeacon;
    }

    public void setLastTaskVibrantBeacon(boolean lastTaskVibrantBeacon) {
        this.lastTaskVibrantBeacon = lastTaskVibrantBeacon;
    }

    public Beacon<LootrunBeaconKind> getClosestBeacon() {
        return this.closestBeacon;
    }

    public void setClosestBeacon(Beacon<LootrunBeaconKind> closestBeacon) {
        this.closestBeacon = closestBeacon;
    }

    public int getRedBeaconTaskCount() {
        return this.redBeaconTaskCount;
    }

    public void setRedBeaconTaskCount(int redBeaconTaskCount) {
        this.redBeaconTaskCount = redBeaconTaskCount;
    }

    public List<Integer> getOrangeBeaconCounts() {
        return Collections.unmodifiableList(this.orangeBeaconCounts);
    }

    public void setOrangeBeaconCounts(List<Integer> orangeBeaconCounts) {
        this.orangeBeaconCounts = new ArrayList<Integer>(orangeBeaconCounts);
    }

    public int getOrangeAmount() {
        return this.orangeAmount;
    }

    public void setOrangeAmount(int orangeAmount) {
        this.orangeAmount = orangeAmount;
    }

    public int getRainbowBeaconCount() {
        return this.rainbowBeaconCount;
    }

    public void setRainbowBeaconCount(int rainbowBeaconCount) {
        this.rainbowBeaconCount = rainbowBeaconCount;
    }

    public int getRainbowAmount() {
        return this.rainbowAmount;
    }

    public void setRainbowAmount(int rainbowAmount) {
        this.rainbowAmount = rainbowAmount;
    }

    public List<MissionType> getMissions() {
        return Collections.unmodifiableList(this.missions);
    }

    public void setMissions(List<MissionType> missions) {
        this.missions = new ArrayList<MissionType>(missions);
    }

    public void addMission(MissionType newMission) {
        this.missions.add(newMission);
    }

    public List<TrialType> getTrials() {
        return Collections.unmodifiableList(this.trials);
    }

    public void setTrials(List<TrialType> trials) {
        this.trials = new ArrayList<TrialType>(trials);
    }

    public void addTrial(TrialType newTrial) {
        this.trials.add(newTrial);
    }

    public int getSacrifices() {
        return this.sacrifices;
    }

    public void setSacrifices(int sacrifices) {
        this.sacrifices = sacrifices;
    }

    public int getRerolls() {
        return this.rerolls;
    }

    public void setRerolls(int rerolls) {
        this.rerolls = rerolls;
    }
}

