/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.objectives;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.scoreboard.ScoreboardPart;
import com.wynntils.handlers.scoreboard.ScoreboardSegment;
import com.wynntils.models.objectives.WynnObjective;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractObjectivesScoreboardPart
extends ScoreboardPart {
    private static final Pattern OBJECTIVE_PATTERN_ONE_LINE = Pattern.compile("^\u00a7([abc])[- ]\\s\u00a77(.*): *\u00a7f(\\d+)\u00a77/(\\d+)$");
    private static final Pattern OBJECTIVE_PATTERN_MULTILINE_START = Pattern.compile("^\u00a7([abc])[- ]\\s\u00a77(.*)$");
    private static final Pattern OBJECTIVE_PATTERN_MULTILINE_END = Pattern.compile(".*\u00a7f(\\d+)\u00a77/(\\d+)$");
    private static final Pattern SEGMENT_HEADER = Pattern.compile("^\u00a7.\u00a7l[A-Za-z ]+:.*$");
    private static final Pattern EVENT_PART = Pattern.compile("([\u2605\u2b51] )");
    private static final StyledText ALL_DONE = StyledText.fromString("\u00a7c- \u00a77All done");

    protected List<WynnObjective> parseObjectives(ScoreboardSegment segment) {
        ArrayList<WynnObjective> parsedObjectives = new ArrayList<WynnObjective>();
        ArrayList<StyledText> actualContent = new ArrayList<StyledText>();
        StringBuilder multiLine = new StringBuilder();
        boolean hasEventBonus = segment.getHeader().find(EVENT_PART);
        for (StyledText line : segment.getContent()) {
            if (line.matches(OBJECTIVE_PATTERN_ONE_LINE)) {
                actualContent.add(line);
                continue;
            }
            if (line.matches(OBJECTIVE_PATTERN_MULTILINE_START)) {
                if (!multiLine.isEmpty()) {
                    WynntilsMod.error("ObjectiveManager: Multi-line objective start repeatedly:");
                    WynntilsMod.error("Already got: " + String.valueOf(multiLine));
                    WynntilsMod.error("Next line: " + String.valueOf(line));
                }
                multiLine = new StringBuilder(line.getString());
                continue;
            }
            if (!multiLine.isEmpty()) {
                multiLine.append(line.getString());
            }
            if (!line.getMatcher(OBJECTIVE_PATTERN_MULTILINE_END).matches()) continue;
            actualContent.add(StyledText.fromString(multiLine.toString().trim().replaceAll(" +", " ")));
            multiLine = new StringBuilder();
        }
        if (!multiLine.isEmpty() && !SEGMENT_HEADER.matcher(multiLine).matches()) {
            WynntilsMod.error("ObjectiveManager: Got a not finished multi-line objective: " + String.valueOf(multiLine));
        }
        for (StyledText line : actualContent) {
            Matcher objectiveMatcher = line.getMatcher(OBJECTIVE_PATTERN_ONE_LINE);
            if (!objectiveMatcher.matches()) {
                WynntilsMod.error("ObjectiveManager: Broken objective stored: " + String.valueOf(line));
                continue;
            }
            boolean isGuildObjective = Objects.equals(objectiveMatcher.group(1), "b");
            WynnObjective parsed = WynnObjective.parseObjectiveLine(line, isGuildObjective, hasEventBonus);
            parsedObjectives.add(parsed);
        }
        return parsedObjectives;
    }

    protected static boolean isSegmentAllDone(ScoreboardSegment segment) {
        return segment.getContent().size() == 1 && segment.getContent().getFirst().equals(ALL_DONE);
    }

    @Override
    public void reset() {
        Models.Objectives.resetObjectives();
    }
}

