/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.raid;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Model;
import com.wynntils.core.components.Models;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.storage.Storage;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.chat.event.ChatMessageEvent;
import com.wynntils.mc.event.ContainerClickEvent;
import com.wynntils.mc.event.ContainerCloseEvent;
import com.wynntils.mc.event.ContainerSetContentEvent;
import com.wynntils.mc.event.MenuEvent;
import com.wynntils.mc.event.ScreenInitEvent;
import com.wynntils.mc.event.TitleSetTextEvent;
import com.wynntils.models.combat.type.DamageDealtEvent;
import com.wynntils.models.containers.Container;
import com.wynntils.models.containers.containers.RaidRewardChestContainer;
import com.wynntils.models.containers.event.ValuableFoundEvent;
import com.wynntils.models.gear.type.GearTier;
import com.wynntils.models.items.items.game.AspectItem;
import com.wynntils.models.items.items.game.EmeraldItem;
import com.wynntils.models.items.items.game.TomeItem;
import com.wynntils.models.raid.bossbar.ParasiteOvertakenBar;
import com.wynntils.models.raid.event.RaidChallengeEvent;
import com.wynntils.models.raid.event.RaidEndedEvent;
import com.wynntils.models.raid.event.RaidNewBestTimeEvent;
import com.wynntils.models.raid.event.RaidStartedEvent;
import com.wynntils.models.raid.raids.NestOfTheGrootslangsRaid;
import com.wynntils.models.raid.raids.OrphionsNexusOfLightRaid;
import com.wynntils.models.raid.raids.RaidKind;
import com.wynntils.models.raid.raids.TheCanyonColossusRaid;
import com.wynntils.models.raid.raids.TheNamelessAnomalyRaid;
import com.wynntils.models.raid.scoreboard.RaidScoreboardPart;
import com.wynntils.models.raid.type.HistoricRaidInfo;
import com.wynntils.models.raid.type.RaidInfo;
import com.wynntils.models.raid.type.RaidRoomInfo;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.models.worlds.type.WorldState;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.LoreUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.StyledTextUtils;
import com.wynntils.utils.type.CappedValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;

public final class RaidModel
extends Model {
    public static final Integer MAXIMUM_CHALLENGE_ROOMS = 3;
    public static final Integer MAXIMUM_BOSS_ROOMS = 2;
    private static final Pattern CHALLENGE_COMPLETED_PATTERN = Pattern.compile("\udb00\udc5e\u00a7a\u00a7lChallenge Completed");
    private static final Pattern RAID_COMPLETED_PATTERN = Pattern.compile("\u00a7f\u00a7lR\u00a7#4d4d4dff\u00a7laid Completed!");
    private static final Pattern RAID_FAILED_PATTERN = Pattern.compile("\u00a74\u00a7kRa\u00a7c\u00a7lid Failed!");
    private static final int RAID_REWARD_CHEST_ASPECT_SLOTS_START = 11;
    private static final int RAID_REWARD_CHEST_ASPECT_SLOTS_END = 15;
    private static final int RAID_REWARD_CHEST_REWARD_SLOTS_START = 27;
    private static final int RAID_REWARD_CHEST_REWARD_SLOTS_END = 53;
    private static final Pattern REWARD_PULLS_PATTERN = Pattern.compile("\u00a7.(\\d+)\u00a77 Reward Pulls");
    private static final Pattern ASPECT_PULLS_PATTERN = Pattern.compile("\u00a7.(\\d+)\u00a77 Aspect Pulls");
    private static final Pattern RAID_CHOOSE_BUFF_PATTERN = Pattern.compile("\u00a7#d6401eff(\\uE009\\uE002|\\uE001) \u00a7#fa7f63ff((\u00a7o)?(\\w+))\u00a7#d6401eff has chosen the \u00a7#fa7f63ff(\\w+ \\w+)\u00a7#d6401eff buff!");
    private static final ParasiteOvertakenBar PARASITE_OVERTAKEN_BAR = new ParasiteOvertakenBar();
    private static final Pattern PARASITE_OVERTAKEN_PATTERN = Pattern.compile("\u00a7#d6401eff(?:\ue009\ue002|\ue001) \u00a7#fa7f63ff(?<player>.+?)\u00a7#d6401eff has been overtaken! Keep attacking \u00a7#ffc85fffThe Parasite\u00a7#d6401eff to save them!");
    @Persisted
    private final Storage<Map<String, Long>> bestTimes = new Storage(new TreeMap());
    @Persisted
    private final Storage<Integer> numRaidsWithoutMythicAspect = new Storage<Integer>(0);
    @Persisted
    private final Storage<Integer> numAspectPullsWithoutMythicAspect = new Storage<Integer>(0);
    @Persisted
    private final Storage<Integer> numRaidsWithoutMythicTome = new Storage<Integer>(0);
    @Persisted
    private final Storage<Integer> numRewardPullsWithoutMythicTome = new Storage<Integer>(0);
    @Persisted
    private final Storage<Integer> expectedNumAspectPulls = new Storage<Integer>(-1);
    @Persisted
    private final Storage<Integer> expectedNumRewardPulls = new Storage<Integer>(-1);
    @Persisted
    public final Storage<List<HistoricRaidInfo>> historicRaids = new Storage(new ArrayList());
    private static final List<RaidKind> RAIDS = new ArrayList<RaidKind>();
    private static final RaidScoreboardPart RAID_SCOREBOARD_PART = new RaidScoreboardPart();
    private final Map<String, List<String>> partyRaidBuffs = new HashMap<String, List<String>>();
    private int foundNumRewardPulls;
    private int expectedRaidRewardChestId = -2;
    private boolean foundMythicTome;
    private boolean foundMythicAspect;
    private boolean rewardChestIsOpened = false;
    private boolean hasProcessedRewards = true;
    private boolean rerollingRewards = false;
    private boolean completedCurrentChallenge = false;
    private boolean inBuffRoom = false;
    private boolean inIntermissionRoom = false;
    private boolean parasiteOvertaken = false;
    private CappedValue challenges = CappedValue.EMPTY;
    private int timeLeft = 0;
    private RaidInfo currentRaid;

    public RaidModel() {
        super(List.of());
        Handlers.BossBar.registerBar(PARASITE_OVERTAKEN_BAR);
        Handlers.Scoreboard.addPart(RAID_SCOREBOARD_PART);
        this.registerRaids();
    }

    @SubscribeEvent
    public void onTitle(TitleSetTextEvent event) {
        Component component = event.getComponent();
        StyledText styledText = StyledText.fromComponent(component);
        if (this.currentRaid == null) {
            RaidKind raidKind = this.getRaidFromTitle(styledText);
            if (raidKind != null) {
                this.currentRaid = new RaidInfo(raidKind);
                this.completedCurrentChallenge = false;
                this.parasiteOvertaken = false;
                WynntilsMod.postEvent(new RaidStartedEvent(raidKind));
            }
        } else if (styledText.matches(RAID_COMPLETED_PATTERN)) {
            this.completeRaid();
        } else if (styledText.matches(RAID_FAILED_PATTERN)) {
            this.failedRaid();
        }
    }

    @SubscribeEvent
    public void onChatMessage(ChatMessageEvent.Match event) {
        StyledText styledText = event.getMessage();
        Matcher rewardPullMatcher = styledText.getMatcher(REWARD_PULLS_PATTERN);
        if (rewardPullMatcher.find()) {
            this.expectedNumRewardPulls.store(Integer.parseInt(rewardPullMatcher.group(1)));
            this.hasProcessedRewards = false;
            return;
        }
        Matcher aspectPullMatcher = styledText.getMatcher(ASPECT_PULLS_PATTERN);
        if (aspectPullMatcher.find()) {
            this.expectedNumAspectPulls.store(Integer.parseInt(aspectPullMatcher.group(1)));
            return;
        }
        StyledText unwrapped = StyledTextUtils.unwrap(styledText).stripAlignment();
        if (this.inBuffRoom) {
            Matcher matcher = unwrapped.getMatcher(RAID_CHOOSE_BUFF_PATTERN);
            if (matcher.matches()) {
                String playerName = matcher.group(4);
                if (matcher.group(3) != null && (playerName = StyledTextUtils.extractNameAndNick(event.getMessage()).key()) == null) {
                    return;
                }
                String buff = matcher.group(5);
                this.partyRaidBuffs.computeIfAbsent(playerName, k -> new ArrayList()).add(buff);
            }
            return;
        }
        Matcher matcher = unwrapped.getMatcher(PARASITE_OVERTAKEN_PATTERN);
        if (matcher.matches()) {
            this.parasiteOvertaken = matcher.group("player").equals(McUtils.playerName());
            return;
        }
        if (this.inIntermissionRoom) {
            return;
        }
        if (styledText.matches(CHALLENGE_COMPLETED_PATTERN)) {
            this.completeChallenge();
        }
    }

    @SubscribeEvent
    public void onDamageDealtEvent(DamageDealtEvent event) {
        if (this.currentRaid == null) {
            return;
        }
        if (this.inIntermissionRoom || this.inBuffRoom) {
            return;
        }
        this.currentRaid.addDamageToCurrentRoom(event.getDamages().values().stream().mapToLong(d -> d).sum());
    }

    @SubscribeEvent
    public void onWorldStateChange(WorldStateEvent event) {
        if (this.currentRaid != null && event.getNewState() == WorldState.WORLD) {
            this.currentRaid = null;
            this.completedCurrentChallenge = false;
            this.timeLeft = 0;
            this.challenges = CappedValue.EMPTY;
            this.partyRaidBuffs.clear();
            this.parasiteOvertaken = false;
            McUtils.sendMessageToClient((Component)Component.literal((String)"Raid tracking has been interrupted, you will not be able to see progress for the current raid").withStyle(ChatFormatting.DARK_RED));
        }
    }

    @SubscribeEvent
    public void onScreenInit(ScreenInitEvent.Pre e) {
        Container container = Models.Container.getCurrentContainer();
        if (container instanceof RaidRewardChestContainer) {
            RaidRewardChestContainer raidRewardChest = (RaidRewardChestContainer)container;
            this.expectedRaidRewardChestId = raidRewardChest.getContainerId();
        } else {
            this.expectedRaidRewardChestId = -2;
        }
    }

    @SubscribeEvent
    public void onSlotClicked(ContainerClickEvent e) {
        if (e.getItemStack().isEmpty()) {
            return;
        }
        Container container = Models.Container.getCurrentContainer();
        if (container instanceof RaidRewardChestContainer) {
            RaidRewardChestContainer raidRewardChest = (RaidRewardChestContainer)container;
            if (e.getSlotNum() == 5) {
                StyledText rerollLoreConfirm = LoreUtils.getLore(e.getItemStack()).getFirst();
                if (rerollLoreConfirm.matches(RaidRewardChestContainer.REROLL_CONFIRM_PATTERN)) {
                    this.rerollingRewards = true;
                    this.hasProcessedRewards = false;
                }
            }
        }
    }

    @SubscribeEvent
    public void onSetContent(ContainerSetContentEvent.Post event) {
        int i;
        StyledText rerollLoreConfirm;
        if (event.getContainerId() != this.expectedRaidRewardChestId) {
            return;
        }
        ItemStack rerollItem = event.getItems().get(5);
        if (!rerollItem.isEmpty() && (rerollLoreConfirm = LoreUtils.getLore(rerollItem).getFirst()).matches(RaidRewardChestContainer.REROLL_CONFIRM_PATTERN)) {
            return;
        }
        this.rewardChestIsOpened = true;
        if (this.hasProcessedRewards) {
            return;
        }
        this.hasProcessedRewards = true;
        if ((Integer)this.expectedNumAspectPulls.get() == -1 || (Integer)this.expectedNumRewardPulls.get() == -1) {
            WynntilsMod.warn("[RaidModel] Set content of raid reward chest, but did not detect number of expected pulls. Got expectedNumAspectPulls=" + String.valueOf(this.expectedNumAspectPulls.get()) + " and expectedNumRewardPulls=" + String.valueOf(this.expectedNumRewardPulls.get()) + ". Probably, the player tried closing the chest before, which got cancelled and the contents of the chest got refreshed. Ignoring contents of this raid chest.");
            return;
        }
        List<ItemStack> items = event.getItems();
        this.foundMythicAspect = false;
        for (i = 11; i <= 15; ++i) {
            this.processAspectItemFind(items.get(i), i);
        }
        this.foundMythicTome = false;
        this.foundNumRewardPulls = 0;
        for (i = 27; i <= 53; ++i) {
            this.processRewardItemFind(items.get(i), i);
        }
    }

    @SubscribeEvent
    public void onContainerClose(ContainerCloseEvent.Post event) {
        if (!this.rewardChestIsOpened) {
            return;
        }
        this.expectedRaidRewardChestId = -2;
        if ((Integer)this.expectedNumRewardPulls.get() == -1 || (Integer)this.expectedNumAspectPulls.get() == -1) {
            WynntilsMod.warn("[RaidModel] Failed to update dry raid counts after closing the reward chest. Did not detect number of expected pulls. Got expectedNumAspectPulls=" + String.valueOf(this.expectedNumAspectPulls.get()) + " and expectedNumRewardPulls=" + String.valueOf(this.expectedNumRewardPulls.get()) + ". Probably, the player tried closing the chest before, which got cancelled and the contents of the chest got refreshed.");
            return;
        }
        if (this.foundMythicAspect) {
            this.numRaidsWithoutMythicAspect.store(0);
            this.numAspectPullsWithoutMythicAspect.store(0);
        } else {
            this.numRaidsWithoutMythicAspect.store((Integer)this.numRaidsWithoutMythicAspect.get() + 1);
            this.numAspectPullsWithoutMythicAspect.store((Integer)this.numAspectPullsWithoutMythicAspect.get() + (Integer)this.expectedNumAspectPulls.get());
        }
        if ((Integer)this.expectedNumRewardPulls.get() <= 27 && this.foundNumRewardPulls != (Integer)this.expectedNumRewardPulls.get()) {
            WynntilsMod.warn("[RaidModel] Expected user to receive " + String.valueOf(this.expectedNumRewardPulls.get()) + " pulls based on raid summary in chat. However, detected " + this.foundNumRewardPulls + " items in reward chest. Awarding " + String.valueOf(this.expectedNumRewardPulls.get()) + " pulls based on raid summary chat message.");
        }
        if (this.foundMythicTome) {
            this.numRaidsWithoutMythicTome.store(0);
            this.numRewardPullsWithoutMythicTome.store(0);
        } else {
            this.numRaidsWithoutMythicTome.store((Integer)this.numRaidsWithoutMythicTome.get() + 1);
            this.numRewardPullsWithoutMythicTome.store((Integer)this.numRewardPullsWithoutMythicTome.get() + (Integer)this.expectedNumRewardPulls.get());
        }
        this.expectedNumAspectPulls.store(-1);
        this.expectedNumRewardPulls.store(-1);
        this.rewardChestIsOpened = false;
    }

    @SubscribeEvent
    public void onMenuClosed(MenuEvent.MenuClosedEvent event) {
        if (!this.rewardChestIsOpened) {
            return;
        }
        if (!this.rerollingRewards) {
            return;
        }
        if ((Integer)this.expectedNumRewardPulls.get() == -1 || (Integer)this.expectedNumAspectPulls.get() == -1) {
            WynntilsMod.warn("[RaidModel] Failed to update dry raid counts after rerolling the reward chest. Did not detect number of expected pulls. Got expectedNumAspectPulls=" + String.valueOf(this.expectedNumAspectPulls.get()) + " and expectedNumRewardPulls=" + String.valueOf(this.expectedNumRewardPulls.get()) + ".");
            return;
        }
        if (this.foundMythicAspect) {
            this.numRaidsWithoutMythicAspect.store(0);
            this.numAspectPullsWithoutMythicAspect.store((Integer)this.expectedNumAspectPulls.get());
        } else {
            this.numAspectPullsWithoutMythicAspect.store((Integer)this.numAspectPullsWithoutMythicAspect.get() + (Integer)this.expectedNumAspectPulls.get());
        }
        if ((Integer)this.expectedNumRewardPulls.get() <= 27 && this.foundNumRewardPulls != (Integer)this.expectedNumRewardPulls.get()) {
            WynntilsMod.warn("[RaidModel] Expected user to receive " + String.valueOf(this.expectedNumRewardPulls.get()) + " pulls based on raid summary in chat. However, detected " + this.foundNumRewardPulls + " items in reward chest. Awarding " + String.valueOf(this.expectedNumRewardPulls.get()) + " pulls based on raid summary chat message.");
        }
        if (this.foundMythicTome) {
            this.numRaidsWithoutMythicTome.store(0);
            this.numRewardPullsWithoutMythicTome.store((Integer)this.expectedNumRewardPulls.get());
        } else {
            this.numRewardPullsWithoutMythicTome.store((Integer)this.numRewardPullsWithoutMythicTome.get() + (Integer)this.expectedNumRewardPulls.get());
        }
        this.rewardChestIsOpened = false;
        this.rerollingRewards = false;
    }

    public void tryEnterChallengeIntermission() {
        if (this.currentRaid == null) {
            return;
        }
        if (this.inIntermissionRoom) {
            return;
        }
        this.inBuffRoom = false;
        this.inIntermissionRoom = true;
    }

    public void tryStartChallenge(StyledText challengeLine) {
        if (this.currentRaid == null) {
            return;
        }
        int challengeNum = this.currentRaid.completedChallengeCount() + 1;
        String roomName = this.currentRaid.getRaidKind().getChallengeName(challengeNum, challengeLine.getStringWithoutFormatting());
        if (roomName.isEmpty()) {
            return;
        }
        this.inIntermissionRoom = false;
        this.currentRaid.startChallenge(challengeNum, roomName);
        WynntilsMod.postEvent(new RaidChallengeEvent.Started(this.currentRaid));
    }

    public void completeChallenge() {
        if (this.currentRaid == null) {
            return;
        }
        if (!this.completedCurrentChallenge) {
            this.currentRaid.completeCurrentChallenge();
            this.completedCurrentChallenge = true;
            WynntilsMod.postEvent(new RaidChallengeEvent.Completed(this.currentRaid));
        }
    }

    public void enterBuffRoom() {
        if (this.currentRaid == null) {
            return;
        }
        if (this.inBuffRoom) {
            return;
        }
        if (this.completedCurrentChallenge) {
            this.completedCurrentChallenge = false;
            this.inIntermissionRoom = false;
            this.inBuffRoom = true;
        }
    }

    public void failedRaid() {
        if (this.currentRaid == null) {
            return;
        }
        WynntilsMod.postEvent(new RaidEndedEvent.Failed(this.currentRaid));
        ((List)this.historicRaids.get()).add(new HistoricRaidInfo(this.currentRaid.getRaidKind().getRaidName(), this.currentRaid.getRaidKind().getAbbreviation(), this.currentRaid.getChallenges(), System.currentTimeMillis()));
        this.historicRaids.touched();
        this.currentRaid = null;
        this.completedCurrentChallenge = false;
        this.timeLeft = 0;
        this.challenges = CappedValue.EMPTY;
        this.partyRaidBuffs.clear();
        this.parasiteOvertaken = false;
    }

    public boolean isParasiteOvertaken() {
        return this.parasiteOvertaken;
    }

    public void resetParasiteOvertaken() {
        this.parasiteOvertaken = false;
    }

    public RaidInfo getCurrentRaid() {
        return this.currentRaid;
    }

    public List<String> getRaidMajorIds(String playerName) {
        if (this.currentRaid == null) {
            return List.of();
        }
        if (!this.partyRaidBuffs.containsKey(playerName)) {
            return List.of();
        }
        List<String> rawBuffNames = this.partyRaidBuffs.get(playerName);
        ArrayList<String> majorIds = new ArrayList<String>();
        for (String rawBuffName : rawBuffNames) {
            String[] buffParts = rawBuffName.split(" ");
            if (buffParts.length < 2) continue;
            String buffName = buffParts[0];
            int buffTier = MathUtils.integerFromRoman(buffParts[1]);
            String majorId = this.currentRaid.getRaidKind().majorIdFromBuff(buffName, buffTier);
            if (majorId == null) continue;
            majorIds.add(majorId);
        }
        return majorIds;
    }

    public RaidKind getRaidFromColor(CustomColor color) {
        return RAIDS.stream().filter(raid -> raid.getRaidColor().equals(color)).findFirst().orElse(null);
    }

    public String getCurrentRoomName() {
        if (this.currentRaid == null || this.inIntermissionRoom || this.inBuffRoom) {
            return "";
        }
        RaidRoomInfo currentRoom = this.currentRaid.getCurrentRoom();
        if (currentRoom == null) {
            return "";
        }
        return currentRoom.getRoomName();
    }

    public String getRoomName(int roomNum) {
        if (this.currentRaid == null) {
            return "";
        }
        if (this.isBossRoom(roomNum)) {
            return this.currentRaid.getRaidKind().getBossName(roomNum);
        }
        RaidRoomInfo room = this.currentRaid.getRoomByNumber(roomNum);
        if (room == null) {
            return "";
        }
        return room.getRoomName();
    }

    public long currentRaidTime() {
        if (this.currentRaid == null) {
            return -1L;
        }
        return this.currentRaid.getTimeInRaid();
    }

    public long getIntermissionTime() {
        if (this.currentRaid == null) {
            return -1L;
        }
        return this.currentRaid.getIntermissionTime();
    }

    public long currentRoomTime() {
        if (this.currentRaid == null || this.currentRaid.getCurrentRoom() == null) {
            return -1L;
        }
        return this.currentRaid.getCurrentRoom().getRoomTotalTime();
    }

    public long getRoomTime(int roomNum) {
        if (this.currentRaid == null) {
            return -1L;
        }
        RaidRoomInfo roomInfo = this.currentRaid.getRoomByNumber(roomNum);
        if (roomInfo == null) {
            return -1L;
        }
        return roomInfo.getRoomTotalTime();
    }

    public long getRaidDamage() {
        if (this.currentRaid == null) {
            return -1L;
        }
        return this.currentRaid.getRaidDamage();
    }

    public long getCurrentRoomDamage() {
        if (this.currentRaid == null || this.currentRaid.getCurrentRoom() == null) {
            return -1L;
        }
        return this.currentRaid.getCurrentRoom().getRoomDamage();
    }

    public long getRoomDamage(int roomNum) {
        if (this.currentRaid == null) {
            return -1L;
        }
        RaidRoomInfo roomInfo = this.currentRaid.getRoomByNumber(roomNum);
        if (roomInfo == null) {
            return -1L;
        }
        return roomInfo.getRoomDamage();
    }

    public int getRaidChallengeCount() {
        if (this.currentRaid == null) {
            return -1;
        }
        return this.currentRaid.getRaidKind().getChallengeCount();
    }

    public boolean raidHasRoom(int roomNum) {
        if (this.currentRaid == null || roomNum < 1) {
            return false;
        }
        return roomNum <= this.currentRaid.getRaidKind().getChallengeCount();
    }

    public int getRaidBossCount() {
        if (this.currentRaid == null) {
            return -1;
        }
        return this.currentRaid.getRaidKind().getBossCount();
    }

    public boolean isBossRoom(int roomNum) {
        if (this.currentRaid == null || roomNum < 1) {
            return false;
        }
        int challengeCount = this.currentRaid.getRaidKind().getChallengeCount();
        if (roomNum <= challengeCount) {
            return false;
        }
        return roomNum <= this.currentRaid.getRaidKind().getBossCount() + challengeCount;
    }

    public boolean isInBuffRoom() {
        return this.inBuffRoom;
    }

    public boolean isInIntermissionRoom() {
        return this.inIntermissionRoom;
    }

    public void setTimeLeft(int seconds) {
        this.timeLeft = seconds;
    }

    public int getTimeLeft() {
        return this.timeLeft;
    }

    public void setChallenges(CappedValue challenges) {
        this.challenges = challenges;
    }

    public CappedValue getChallenges() {
        return this.challenges;
    }

    public int getRaidsWithoutMythicAspect() {
        return (Integer)this.numRaidsWithoutMythicAspect.get();
    }

    public int getAspectPullsWithoutMythicAspect() {
        return (Integer)this.numAspectPullsWithoutMythicAspect.get();
    }

    public int getRaidsWithoutMythicTome() {
        return (Integer)this.numRaidsWithoutMythicTome.get();
    }

    public int getRewardPullsWithoutMythicTome() {
        return (Integer)this.numRewardPullsWithoutMythicTome.get();
    }

    public long getRaidBestTime(String raidName) {
        for (RaidKind raidKind : RAIDS) {
            if (!raidKind.getRaidName().equalsIgnoreCase(raidName) && !raidKind.getAbbreviation().equalsIgnoreCase(raidName)) continue;
            return ((Map)this.bestTimes.get()).getOrDefault(raidKind.getRaidName(), -1L);
        }
        return -1L;
    }

    private void completeRaid() {
        if (this.currentRaid == null) {
            return;
        }
        this.currentRaid.completeCurrentChallenge();
        WynntilsMod.postEvent(new RaidEndedEvent.Completed(this.currentRaid));
        ((List)this.historicRaids.get()).add(new HistoricRaidInfo(this.currentRaid.getRaidKind().getRaidName(), this.currentRaid.getRaidKind().getAbbreviation(), this.currentRaid.getChallenges(), System.currentTimeMillis()));
        this.historicRaids.touched();
        this.checkForNewPersonalBest();
        this.currentRaid = null;
        this.completedCurrentChallenge = false;
        this.timeLeft = 0;
        this.challenges = CappedValue.EMPTY;
        this.partyRaidBuffs.clear();
        this.parasiteOvertaken = false;
    }

    private void checkForNewPersonalBest() {
        long timeInRaid = this.currentRaid.getTimeInRaid() - this.currentRaid.getIntermissionTime();
        if (timeInRaid == 0L) {
            WynntilsMod.warn("Completed raid time was 0, tracking failed.");
            return;
        }
        if (((Map)this.bestTimes.get()).get(this.currentRaid.getRaidKind().getRaidName()) == null) {
            ((Map)this.bestTimes.get()).put(this.currentRaid.getRaidKind().getRaidName(), timeInRaid);
            this.bestTimes.touched();
        } else {
            long currentBestTime = (Long)((Map)this.bestTimes.get()).get(this.currentRaid.getRaidKind().getRaidName());
            if (currentBestTime > timeInRaid) {
                ((Map)this.bestTimes.get()).put(this.currentRaid.getRaidKind().getRaidName(), timeInRaid);
                this.bestTimes.touched();
                WynntilsMod.postEvent(new RaidNewBestTimeEvent(this.currentRaid.getRaidKind().getRaidName(), timeInRaid));
            }
        }
    }

    private void processAspectItemFind(ItemStack itemStack, int slotId) {
        if (itemStack.isEmpty()) {
            return;
        }
        Optional<AspectItem> aspectOptional = Models.Item.asWynnItem(itemStack, AspectItem.class);
        if (aspectOptional.isPresent()) {
            AspectItem aspectItem = aspectOptional.get();
            if (aspectItem.getGearTier() == GearTier.MYTHIC) {
                this.foundMythicAspect = true;
                WynntilsMod.postEvent(new ValuableFoundEvent(itemStack, ValuableFoundEvent.ItemSource.RAID_REWARD_CHEST));
            }
            return;
        }
        WynntilsMod.warn("[RaidModel] Unexpectedly found item \"" + StyledText.fromComponent(itemStack.getHoverName()).getStringWithoutFormatting() + "\" at slot " + slotId + ", but this slot should be an aspect reward slot.");
    }

    private void processRewardItemFind(ItemStack itemStack, int slotId) {
        if (itemStack.isEmpty()) {
            return;
        }
        ++this.foundNumRewardPulls;
        Optional<AspectItem> aspectOptional = Models.Item.asWynnItem(itemStack, AspectItem.class);
        if (aspectOptional.isPresent()) {
            AspectItem aspectItem = aspectOptional.get();
            WynntilsMod.warn("[RaidModel] User found aspect item \"" + String.valueOf(aspectItem) + "\" at slot " + slotId + ", but this slot should be a reward item slot.");
            return;
        }
        Optional<EmeraldItem> emeraldOptional = Models.Item.asWynnItem(itemStack, EmeraldItem.class);
        if (emeraldOptional.isPresent()) {
            return;
        }
        Optional<TomeItem> tomeItemOptional = Models.Item.asWynnItemProperty(itemStack, TomeItem.class);
        if (tomeItemOptional.isPresent()) {
            TomeItem tomeItem = tomeItemOptional.get();
            if (tomeItem.getGearTier() == GearTier.MYTHIC) {
                this.foundMythicTome = true;
                WynntilsMod.postEvent(new ValuableFoundEvent(itemStack, ValuableFoundEvent.ItemSource.RAID_REWARD_CHEST));
            }
            return;
        }
    }

    private RaidKind getRaidFromTitle(StyledText title) {
        return RAIDS.stream().filter(raid -> raid.getEntryTitle().equals(title)).findFirst().orElse(null);
    }

    private void registerRaids() {
        this.registerRaid(new NestOfTheGrootslangsRaid());
        this.registerRaid(new OrphionsNexusOfLightRaid());
        this.registerRaid(new TheCanyonColossusRaid());
        this.registerRaid(new TheNamelessAnomalyRaid());
    }

    private void registerRaid(RaidKind raidKind) {
        RAIDS.add(raidKind);
    }
}

