/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.spells.actionbar.matchers;

import com.wynntils.core.WynntilsMod;
import com.wynntils.handlers.actionbar.ActionBarSegment;
import com.wynntils.handlers.actionbar.ActionBarSegmentMatcher;
import com.wynntils.models.spells.actionbar.segments.SpellSegment;
import com.wynntils.models.spells.type.SpellDirection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SpellSegmentMatcher
implements ActionBarSegmentMatcher {
    private static final String SEGMENT_SEPARATOR = "\udaff\udfe0";
    private static final String LEFT_CLICK = "[\ue100\ue103]";
    private static final String RIGHT_CLICK = "[\ue101|\ue104]";
    private static final String NO_CLICK = "[\ue102\ue105]";
    private static final String SEPARATOR = "\\s\ue106\\s";
    private static final Pattern SPELL_REGEX = Pattern.compile("\udaff\udfe0(?<first>[\ue100\ue103]|[\ue101|\ue104]|[\ue102\ue105])\\s\ue106\\s(?<second>[\ue100\ue103]|[\ue101|\ue104]|[\ue102\ue105])\\s\ue106\\s(?<third>[\ue100\ue103]|[\ue101|\ue104]|[\ue102\ue105])\udaff\udfe0");
    private static final Pattern NO_CLICK_PATTERN = Pattern.compile("[\ue102\ue105]");
    private static final Pattern RIGHT_CLICK_PATTERN = Pattern.compile("[\ue101|\ue104]");
    private static final Pattern LEFT_CLICK_PATTERN = Pattern.compile("[\ue100\ue103]");

    @Override
    public ActionBarSegment parse(String actionBar) {
        Matcher matcher = SPELL_REGEX.matcher(actionBar);
        if (!matcher.find()) {
            return null;
        }
        SpellDirection first = this.fromCharacter(matcher.group("first"));
        SpellDirection second = this.fromCharacter(matcher.group("second"));
        SpellDirection third = this.fromCharacter(matcher.group("third"));
        SpellDirection[] directions = first == null ? SpellDirection.NO_SPELL : (second == null ? new SpellDirection[]{first} : (third == null ? new SpellDirection[]{first, second} : new SpellDirection[]{first, second, third}));
        return new SpellSegment(matcher.group(), directions);
    }

    private SpellDirection fromCharacter(String spellCharacter) {
        if (LEFT_CLICK_PATTERN.matcher(spellCharacter).matches()) {
            return SpellDirection.LEFT;
        }
        if (RIGHT_CLICK_PATTERN.matcher(spellCharacter).matches()) {
            return SpellDirection.RIGHT;
        }
        if (NO_CLICK_PATTERN.matcher(spellCharacter).matches()) {
            return null;
        }
        WynntilsMod.warn("Unknown spell character: " + spellCharacter);
        return null;
    }
}

