/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.statuseffects;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Model;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.event.PlayerInfoFooterChangedEvent;
import com.wynntils.models.statuseffects.event.StatusEffectsChangedEvent;
import com.wynntils.models.statuseffects.type.StatusEffect;
import com.wynntils.models.worlds.event.WorldStateEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

public final class StatusEffectModel
extends Model {
    private static final Pattern STATUS_EFFECT_PATTERN = Pattern.compile("(?<prefix>.+?)\u00a77\\s?(?<modifier>(\\-|\\+)?([\\-\\.\\d]+))?(?<modifierSuffix>((\\/\\d+s)|%)?)?\\s?(?<name>\\+?['a-zA-Z\\/\\s]+?)\\s(?<timer>\u00a7[84a]\\((?<minutes>(\\d{2}|\\*{2})):(?<seconds>(\\d{2}|\\*{2}))\\))");
    private static final StyledText STATUS_EFFECTS_TITLE = StyledText.fromString("\u00a7d\u00a7lStatus Effects");
    private List<StatusEffect> statusEffects = List.of();

    public StatusEffectModel() {
        super(List.of());
    }

    public List<StatusEffect> getStatusEffects() {
        return this.statusEffects;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onWorldStateChanged(WorldStateEvent e) {
        this.statusEffects = List.of();
        WynntilsMod.postEvent(new StatusEffectsChangedEvent());
    }

    @SubscribeEvent
    public void onTabListCustomization(PlayerInfoFooterChangedEvent event) {
        StyledText[] effects;
        StyledText footer = event.getFooter();
        if (footer.isEmpty()) {
            if (!this.statusEffects.isEmpty()) {
                this.statusEffects = List.of();
                WynntilsMod.postEvent(new StatusEffectsChangedEvent());
            }
            return;
        }
        if (!footer.startsWith(STATUS_EFFECTS_TITLE)) {
            return;
        }
        ArrayList<StatusEffect> newStatusEffects = new ArrayList<StatusEffect>();
        for (StyledText effect : effects = footer.split("\\s{2}")) {
            Matcher m;
            StyledText trimmedEffect = effect.trim();
            if (trimmedEffect.isEmpty() || !(m = trimmedEffect.getMatcher(STATUS_EFFECT_PATTERN)).find()) continue;
            String color = ChatFormatting.GRAY.toString();
            Style prefixStyle = effect.getFirstPart().getPartStyle().getStyle();
            StyledText prefix = StyledText.fromComponent((Component)Component.literal((String)m.group("prefix").trim()).withStyle(prefixStyle));
            StyledText name = StyledText.fromString(color + m.group("name").trim());
            StyledText minutes = StyledText.fromString(m.group("minutes")).trim();
            StyledText seconds = StyledText.fromString(m.group("seconds")).trim();
            StyledText displayedTime = StyledText.fromString(m.group("timer"));
            int duration = -1;
            try {
                duration = Integer.parseInt(minutes.getString()) * 60 + Integer.parseInt(seconds.getString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String modifierGroup = m.group("modifier");
            StyledText modifier = modifierGroup == null ? StyledText.EMPTY : StyledText.fromString(color + modifierGroup.trim());
            String modifierSuffixGroup = m.group("modifierSuffix");
            StyledText modifierSuffix = modifierSuffixGroup == null ? StyledText.EMPTY : StyledText.fromString(color + modifierSuffixGroup.trim());
            newStatusEffects.add(new StatusEffect(name, modifier, modifierSuffix, displayedTime, prefix, duration));
        }
        this.statusEffects = newStatusEffects;
        WynntilsMod.postEvent(new StatusEffectsChangedEvent());
    }

    public StatusEffect searchStatusEffectByName(String query) {
        for (StatusEffect effect : this.statusEffects) {
            if (!effect.getName().getStringWithoutFormatting().startsWith(query)) continue;
            return effect;
        }
        return null;
    }
}

