/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.worlds.profile;

import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ServerProfile {
    private final String serverName;
    private final Set<String> players;
    private long firstSeen;

    public ServerProfile(String serverName, Set<String> players, long firstSeem) {
        this.serverName = serverName;
        this.firstSeen = firstSeem;
        this.players = players;
    }

    public String getServerName() {
        return this.serverName;
    }

    public Set<String> getPlayers() {
        return this.players;
    }

    public long getFirstSeen() {
        return this.firstSeen;
    }

    public String getUptime() {
        long millis = System.currentTimeMillis() - this.firstSeen;
        return String.format("%dh %dm", TimeUnit.MILLISECONDS.toHours(millis), TimeUnit.MILLISECONDS.toMinutes(millis) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(millis)));
    }

    public int getUptimeInMinutes() {
        return (int)TimeUnit.MILLISECONDS.toMinutes(System.currentTimeMillis() - this.firstSeen);
    }

    public void matchTime(long serverTime) {
        this.firstSeen = System.currentTimeMillis() - serverTime + this.firstSeen;
    }
}

